/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.stores.InputDataStore;
import jams.workspace.stores.TSDataStore;
import java.util.ArrayList;
import java.util.List;

public class TimeSeriesIndicators
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Datastore ID")
    public Attribute.String id;
    protected List<String> dateStrings;
    protected List<Attribute.Calendar> dates;
    protected List<Double>[] values;
    protected Attribute.Calendar lastPlusOne;

    protected void readTSData() {
        DefaultDataSet ds;
        InputDataStore is = this.getModel().getWorkspace().getInputDataStore(this.id.getValue());
        if (is == null) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore could not be found!");
            return;
        }
        if (!(is instanceof TSDataStore)) {
            this.getModel().getRuntime().sendHalt("Error accessing datastore \"" + this.id + "\" from " + this.getInstanceName() + ": Datastore is not a time series datastore!");
            return;
        }
        TSDataStore store = (TSDataStore)is;
        Attribute.Calendar storeDate = store.getStartDate().clone();
        int storeUnit = store.getTimeUnit();
        int storeUnitCount = store.getTimeUnitCount();
        this.values = new List[store.getDataSetDefinition().getColumnCount()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new ArrayList<Double>();
        }
        this.dateStrings = new ArrayList<String>();
        this.dates = new ArrayList<Attribute.Calendar>();
        double missing = Double.parseDouble(store.getMissingDataValue());
        while ((ds = store.getNext()) != null) {
            this.dates.add(storeDate.clone());
            this.dateStrings.add(storeDate.toString());
            DataValue[] data = ds.getData();
            for (int i = 1; i < data.length; ++i) {
                double d;
                String s = data[i].getString();
                if (s.equals("NaN") || s.equals("Infinity") || s.isEmpty()) {
                    d = JAMS.getMissingDataValue();
                } else {
                    d = data[i].getDouble();
                    if (d == missing) {
                        d = JAMS.getMissingDataValue();
                    }
                }
                this.values[i - 1].add(d);
            }
            storeDate.add(storeUnit, storeUnitCount);
        }
        this.lastPlusOne = storeDate;
    }
}

