/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class JAMSAscGridReader {
    int ncols;
    int nrows;
    double x11corner;
    double y11corner;
    double cellsize;
    double nodatavalue = 0.0;
    double[][] grid;
    double lowest_value = Double.POSITIVE_INFINITY;

    public JAMSAscGridReader(String path) {
        try {
            StringTokenizer st;
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(path));
            int datafound = 0;
            while (datafound < 5) {
                line = reader.readLine();
                st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.contains("ncols")) {
                        this.ncols = new Integer(st.nextToken());
                        ++datafound;
                    }
                    if (tok.contains("nrows")) {
                        this.nrows = new Integer(st.nextToken());
                        ++datafound;
                    }
                    if (tok.contains("xllcorner")) {
                        this.x11corner = new Double(st.nextToken());
                        ++datafound;
                    }
                    if (tok.contains("yllcorner")) {
                        this.y11corner = new Double(st.nextToken());
                        ++datafound;
                    }
                    if (!tok.contains("cellsize")) continue;
                    this.cellsize = new Double(st.nextToken());
                    ++datafound;
                }
            }
            this.grid = new double[this.ncols][this.nrows];
            int x = 0;
            int y = 0;
            boolean firsttoken = true;
            block4: while ((line = reader.readLine()) != null) {
                st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    if (y >= this.nrows) {
                        System.out.println("error to many entrys");
                        continue block4;
                    }
                    String tok = st.nextToken();
                    if (firsttoken) {
                        firsttoken = false;
                        if (tok.contains("NODATA_value")) {
                            this.nodatavalue = new Double(st.nextToken());
                        }
                        if (!st.hasMoreTokens()) continue;
                        tok = st.nextToken();
                    }
                    this.grid[x][y] = new Double(tok);
                    if (Math.abs(this.grid[x][y] - this.nodatavalue) < 1.0E-4) {
                        this.grid[x][y] = -1.0;
                    }
                    if (this.grid[x][y] != -1.0 && this.grid[x][y] < this.lowest_value) {
                        this.lowest_value = this.grid[x][y];
                    }
                    if (++x < this.ncols) continue;
                    x = 0;
                    ++y;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        for (int x = 0; x < this.ncols; ++x) {
            for (int y = 0; y < this.nrows; ++y) {
                if (this.grid[x][y] != -1.0) continue;
                this.grid[x][y] = -1.0;
            }
        }
    }

    double getValue(double x, double y) {
        y = this.y11corner + (double)this.nrows * this.cellsize - (y - this.y11corner);
        int East = (int)((x - this.x11corner) / this.cellsize);
        int West = East + 1;
        int North = (int)((y - this.y11corner) / this.cellsize);
        int South = North + 1;
        if (East < 0 || East >= this.ncols || North < 0 || North >= this.nrows) {
            return -1.0;
        }
        if (West >= this.ncols || South >= this.nrows) {
            return this.grid[East][North];
        }
        if (this.grid[East][North] == -1.0 || this.grid[West][North] == -1.0 || this.grid[East][South] == -1.0 || this.grid[West][South] == -1.0) {
            return -1.0;
        }
        double xA = (double)East * this.cellsize + this.x11corner;
        double yA = (double)North * this.cellsize + this.y11corner;
        double zA = this.grid[East][North];
        double xB = (double)(East + 1) * this.cellsize + this.x11corner;
        double yB = (double)North * this.cellsize + this.y11corner;
        double zB = this.grid[East + 1][North];
        double xC = (double)(East + 1) * this.cellsize + this.x11corner;
        double yC = (double)(North + 1) * this.cellsize + this.y11corner;
        double zC = this.grid[East + 1][North + 1];
        double xD = (double)East * this.cellsize + this.x11corner;
        double yD = (double)(North + 1) * this.cellsize + this.y11corner;
        double zD = this.grid[East][North + 1];
        double rx = x - xD;
        double ry = y - yD;
        double result = 0.0;
        if ((xA - xC) * rx + (yA - yC) * ry > 0.0) {
            double lambda = (x - xA) / (xB - xA);
            double theta = (y - yA) / (yD - yA);
            result = zA + lambda * (zB - zA) + theta * (zD - zA);
        } else {
            double lambda = (x - xC) / (xD - xC);
            double theta = (y - yC) / (yB - yC);
            result = zC + lambda * (zD - zC) + theta * (zB - zC);
        }
        return result;
    }

    public double GetX11Corner() {
        return this.x11corner;
    }

    public double GetY11Corner() {
        return this.y11corner;
    }

    public int GetNumberOfColums() {
        return this.ncols;
    }

    public int GetNumberOfRows() {
        return this.nrows;
    }

    public double GetCellSize() {
        return this.cellsize;
    }
}

