/*
 * Decompiled with CFR 0.152.
 */
package jams.components.datatransfer;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="DoubleTransfer", author="Sven Kralisch", description="Component for simply transferring multiple double attributes) to a target entity. Can be used to implement a simple routing mechanism (e.g. HRU to HRU or HRU to reach) by taking a source entity's double data and moving it to specified.", version="1.0_0", date="2012-09-27")
public class DoubleTransfer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Target entity")
    public Attribute.Entity target;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Data to be transferred")
    public Attribute.Double[] values;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Target entity's receiving attributes")
    public Attribute.String[] inNames;

    public void run() {
        if (!this.target.isEmpty()) {
            int i = 0;
            for (Attribute.Double value : this.values) {
                this.target.setDouble(this.inNames[i].getValue(), value.getValue() + this.target.getDouble(this.inNames[i].getValue()));
                ++i;
            }
        }
    }
}

