/*
 * Decompiled with CFR 0.152.
 */
package jams.components.conditional;

import jams.components.core.SpatialContext;
import jams.data.AbstractDataSupplier;
import jams.data.ArrayDataSupplier;
import jams.data.Attribute;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Iterator;

@JAMSComponentDescription(title="Filtered spatial context", author="Sven Kralisch", date="2012-07-06", version="1.2_0", description="This component is a spatial context which iterates over entities having specific attribute values. Attribute values are not evaluated during model runtime. Therefore it can be used only for filtering overstatic attributes.")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2012-07-06", comment="Initial version"), @VersionComments.Entry(version="1.1_0", date="", comment="added attribute \"attributeValuesAlternative\" as alternative for \"attributeValues\". Version 1.0_0 compared attributeValues with startsWith function. This is now changed to compareTo function."), @VersionComments.Entry(version="1.2_0", date="2015-08-01", comment="Fixed wrong behaviour which was caused by the use of initAll() instead of init()")})
public class FilteredSpatialContext
extends SpatialContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Double attribute to filter")
    public Attribute.String attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute values to match")
    public Attribute.String[] attributeValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Attribute values to match")
    public Attribute.StringArray attributeValuesAlternative;

    public void init() {
        if (this.attributeName == null || (this.attributeValuesAlternative == null || this.attributeValuesAlternative.getValue().length == 0) && (this.attributeValues == null || this.attributeValues.length == 0)) {
            super.init();
            return;
        }
        StringArrayDataSupplier attributeValuesIter = null;
        if (this.attributeValues != null && this.attributeValuesAlternative != null) {
            this.getModel().getRuntime().sendErrorMsg(this.getInstanceName() + ":Either attributeValues must be set or attributeValuesAlternative, but not both at the same time");
        }
        attributeValuesIter = this.attributeValues != null ? new StringArrayDataSupplier(this.attributeValues) : new ArrayDataSupplier((Object[])this.attributeValuesAlternative.getValue());
        ArrayList<Attribute.Entity> entityList = new ArrayList<Attribute.Entity>();
        for (Attribute.Entity e : this.getEntities().getEntities()) {
            try {
                if (!e.existsAttribute(this.attributeName.getValue())) continue;
                Object o = e.getObject(this.attributeName.getValue());
                double p = Double.parseDouble(o.toString());
                boolean found = false;
                Iterator iterator = attributeValuesIter.iterator();
                while (iterator.hasNext()) {
                    String value = (String)iterator.next();
                    double q = Double.parseDouble(value);
                    if (p != q) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                entityList.add(e);
            }
            catch (Attribute.Entity.NoSuchAttributeException ex) {
                this.getModel().getRuntime().handle((Throwable)ex);
            }
        }
        this.entities = this.getModel().getRuntime().getDataFactory().createEntityCollection();
        this.entities.setEntities(entityList);
        super.init();
    }

    @Override
    public Attribute.EntityCollection getEntities() {
        return this.entities;
    }

    @Override
    public void setEntities(Attribute.EntityCollection entities) {
        this.entities = entities;
    }

    public long getNumberOfIterations() {
        return -1L;
    }

    public long getRunCount() {
        return -1L;
    }

    private class StringArrayDataSupplier
    extends AbstractDataSupplier<String, Attribute.String[]> {
        public StringArrayDataSupplier(Attribute.String[] input) {
            super((Object)input);
        }

        public int size() {
            return ((Attribute.String[])this.input).length;
        }

        public String get(int i) {
            return ((Attribute.String[])this.input)[i].getValue();
        }
    }
}

