/*
 * Decompiled with CFR 0.152.
 */
package jams.components.concurrency;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@JAMSComponentDescription(title="SubbasinPartitioner", author="Sven Kralisch", description="Creates a partitioning of entities in an entity collection in such a way that two entities from different partitions are not interdependent. The entities' sub-basin membership is used for this purpose. The maximum number of partitions can be configured by a component attribute.", date="2013-04-08", version="1.0_0")
public class SubbasinPartitioner
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Input entity collection")
    public Attribute.EntityCollection inEntities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Resulting entity collections, length of this array defines the number of partitions")
    public Attribute.EntityCollection[] outEntities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Name of the attribute describing the HRU's subbasin membership in the input file", defaultValue="subbasin")
    public Attribute.String subbasinAttribute;

    public void init() {
        List<List<Attribute.Entity>> alList = this.createSubbasinPartitioning(this.inEntities, this.subbasinAttribute.getValue());
        ArrayList<Attribute.Entity>[] listArray = this.distributeEntities(alList, this.outEntities.length);
        this.getModel().getRuntime().println("");
        this.getModel().getRuntime().println("Partitioning of " + this.inEntities.getValue().size() + " entities resulted in " + listArray.length + " partitions:");
        for (int i = 0; i < this.outEntities.length; ++i) {
            this.getModel().getRuntime().println(String.format("    partition %02d: %d entities", i, listArray[i].size()));
            this.outEntities[i].setValue(listArray[i]);
        }
        this.getModel().getRuntime().println("");
    }

    protected List<List<Attribute.Entity>> createSubbasinPartitioning(Attribute.EntityCollection col, String asso) {
        ArrayList<List<Attribute.Entity>> alList = new ArrayList<List<Attribute.Entity>>();
        HashMap<Double, ArrayList<Attribute.Entity>> subbasinMap = new HashMap<Double, ArrayList<Attribute.Entity>>();
        for (Attribute.Entity e : col.getEntities()) {
            try {
                double subbasinID = e.getDouble(asso);
                ArrayList<Attribute.Entity> entityList = (ArrayList<Attribute.Entity>)subbasinMap.get(subbasinID);
                if (entityList == null) {
                    entityList = new ArrayList<Attribute.Entity>();
                    subbasinMap.put(subbasinID, entityList);
                }
                entityList.add(e);
            }
            catch (Attribute.Entity.NoSuchAttributeException ex) {
                this.getModel().getRuntime().sendErrorMsg("Component attribute " + asso + " is not exising in entity " + e.getId() + "!");
            }
        }
        for (List subbasin : subbasinMap.values()) {
            alList.add(subbasin);
        }
        Collections.sort(alList, new Comparator<List<Attribute.Entity>>(){

            @Override
            public int compare(List<Attribute.Entity> o1, List<Attribute.Entity> o2) {
                return o1.size() - o2.size();
            }
        });
        return alList;
    }

    private ArrayList<Attribute.Entity>[] distributeEntities(List<List<Attribute.Entity>> alList, int numberOfLists) {
        ArrayList[] listArray = new ArrayList[numberOfLists];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        while (alList.size() > 0) {
            int sum = 0;
            for (ArrayList list : listArray) {
                sum += list.size();
            }
            double avgSize = sum / listArray.length;
            for (ArrayList list : listArray) {
                while ((double)list.size() <= avgSize && alList.size() > 0) {
                    List<Attribute.Entity> largestList = alList.remove(alList.size() - 1);
                    list.addAll(largestList);
                }
            }
        }
        return listArray;
    }
}

