/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="MovingAggregation", author="Sven Kralisch", description="Calculate a moving averages of time series data", date="2018-10-25", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class MovingAggregation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Values to aggregate")
    public Attribute.DoubleArray inputValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Size of aggregation window")
    public Attribute.Integer windowSize;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time. If set, the output will be doneon a yearly basis, resulting in one value per year.")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calc mean? If not, calc sum.", defaultValue="true")
    public Attribute.Boolean calcMean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Continue aggregation? If yes, aggregation continues based on current aggregated values which are used for initialization before the first aggregation step.", defaultValue="false")
    public Attribute.Boolean continueAggregation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Aggregation results")
    public Attribute.DoubleArray aggregatedValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Yearly aggregation results")
    public Attribute.DoubleArray aggregatedValuesYearly;
    private int counter;
    private int valueCounter;
    private int startDay = -1;
    private double[] a;
    private double[] ya;

    public void init() {
        this.counter = this.continueAggregation.getValue() ? this.windowSize.getValue() : 0;
    }

    public void run() {
        if (this.aggregatedValues.getValue() == null) {
            this.aggregatedValues.setValue(new double[this.inputValues.getValue().length]);
        }
        this.a = this.aggregatedValues.getValue();
        if (this.counter < this.windowSize.getValue()) {
            ++this.counter;
        }
        this.add(this.counter);
        if (this.time != null) {
            int i;
            if (this.startDay < 0) {
                this.startDay = this.time.get(6);
                this.aggregatedValuesYearly.setValue(new double[this.inputValues.getValue().length]);
                this.ya = new double[this.inputValues.getValue().length];
                for (i = 0; i < this.a.length; ++i) {
                    int n = i;
                    this.ya[n] = this.ya[n] + this.a[i];
                }
                this.valueCounter = 1;
            }
            if (this.time.get(6) == this.startDay) {
                for (i = 0; i < this.a.length; ++i) {
                    this.aggregatedValuesYearly.getValue()[i] = this.ya[i] / (double)this.valueCounter;
                    this.ya[i] = 0.0;
                }
                this.valueCounter = 0;
            }
            for (i = 0; i < this.a.length; ++i) {
                int n = i;
                this.ya[n] = this.ya[n] + this.a[i];
            }
            ++this.valueCounter;
        }
    }

    private void add(int n) {
        double[] in = this.inputValues.getValue();
        if (this.calcMean.getValue()) {
            for (int i = 0; i < this.a.length; ++i) {
                this.a[i] = (this.a[i] * (double)(n - 1) + in[i]) / (double)n;
            }
        } else {
            for (int i = 0; i < this.a.length; ++i) {
                this.a[i] = this.a[i] * (double)(n - 1) / (double)n + in[i];
            }
        }
    }

    public void cleanup() {
    }
}

