/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.time;

import java.io.PrintStream;
import java.util.Date;

public class EggClock {
    private long startTimeMillis;
    private long startSubTimeMillis;
    private final String preFix;
    private final String postFix;
    private boolean started = false;

    public EggClock(String preFix, String postFix) {
        this.preFix = preFix;
        this.postFix = postFix;
    }

    public void start() {
        this.startSubTimeMillis = this.startTimeMillis = System.currentTimeMillis();
        this.started = true;
    }

    public void startAndPrint(PrintStream pm) {
        if (!this.started) {
            this.start();
            pm.println(new Date(this.startTimeMillis));
        } else {
            pm.println("Clock already started before, ignoring call.");
        }
    }

    public void printTimePassedInMinutes(PrintStream pm) {
        this.printTimePassedInMinutes(pm, this.startTimeMillis);
    }

    public void printTimePassedInSeconds(PrintStream pm) {
        this.printTimePassedInSeconds(pm, this.startTimeMillis);
    }

    public void startSub() {
        this.startSubTimeMillis = System.currentTimeMillis();
    }

    public void printSubTimePassedInMinutes(PrintStream pm) {
        this.printTimePassedInMinutes(pm, this.startSubTimeMillis);
    }

    public void printSubTimePassedInSeconds(PrintStream pm) {
        this.printTimePassedInSeconds(pm, this.startSubTimeMillis);
    }

    private void printTimePassedInMinutes(PrintStream pm, long startTimeMillis) {
        long currentTimeMillis = System.currentTimeMillis();
        int mins = (int)Math.round((double)(currentTimeMillis - startTimeMillis) / 1000.0 / 60.0);
        if (this.preFix != null) {
            pm.print(this.preFix);
        }
        pm.print(mins);
        if (this.postFix != null) {
            pm.print(this.postFix);
        }
    }

    private void printTimePassedInSeconds(PrintStream pm, long startTimeMillis) {
        long currentTimeMillis = System.currentTimeMillis();
        int mins = (int)Math.round((double)(currentTimeMillis - startTimeMillis) / 1000.0);
        if (this.preFix != null) {
            pm.print(this.preFix);
        }
        pm.print(mins);
        if (this.postFix != null) {
            pm.print(this.postFix);
        }
    }
}

