/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.matrixes;

import org.jgrasstools.gears.utils.math.matrixes.ColumnVector;
import org.jgrasstools.gears.utils.math.matrixes.MatrixException;
import org.jgrasstools.gears.utils.math.matrixes.RowVector;
import org.jgrasstools.gears.utils.math.matrixes.SquareMatrix;

public class LinearSystem
extends SquareMatrix {
    private static final double TOLERANCE = 1.0E-5;
    private static final int MAX_ITER;
    protected SquareMatrix LU;
    protected int[] permutation;
    protected int exchangeCount;

    public LinearSystem(int n) {
        super(n);
        this.reset();
    }

    public LinearSystem(double[][] values) {
        super(values);
    }

    @Override
    protected void set(double[][] values) {
        super.set(values);
        this.reset();
    }

    @Override
    public void set(int r, int c, double value) throws MatrixException {
        super.set(r, c, value);
        this.reset();
    }

    @Override
    public void setRow(RowVector rv, int r) throws MatrixException {
        super.setRow(rv, r);
        this.reset();
    }

    @Override
    public void setColumn(ColumnVector cv, int c) throws MatrixException {
        super.setColumn(cv, c);
        this.reset();
    }

    protected void reset() {
        this.LU = null;
        this.permutation = null;
        this.exchangeCount = 0;
    }

    public ColumnVector solve(ColumnVector b, boolean improve) throws MatrixException {
        if (b.nRows != this.nRows) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        this.decompose();
        ColumnVector y = this.forwardSubstitution(b);
        ColumnVector x = this.backSubstitution(y);
        if (improve) {
            this.improve(b, x);
        }
        return x;
    }

    protected void decompose() throws MatrixException {
        if (this.LU != null) {
            return;
        }
        this.LU = new SquareMatrix(this.copyValues2D());
        this.permutation = new int[this.nRows];
        double[] scales = new double[this.nRows];
        for (int r = 0; r < this.nRows; ++r) {
            this.permutation[r] = r;
            double largestRowElmt = 0.0;
            for (int c = 0; c < this.nRows; ++c) {
                double elmt = Math.abs(this.LU.at(r, c));
                if (!(largestRowElmt < elmt)) continue;
                largestRowElmt = elmt;
            }
            if (largestRowElmt == 0.0) {
                throw new MatrixException("Matrix has a zero row.");
            }
            scales[r] = 1.0 / largestRowElmt;
        }
        this.forwardElimination(scales);
        if (this.LU.at(this.permutation[this.nRows - 1], this.nRows - 1) == 0.0) {
            throw new MatrixException("Matrix is singular.");
        }
    }

    private void forwardElimination(double[] scales) throws MatrixException {
        for (int rPivot = 0; rPivot < this.nRows - 1; ++rPivot) {
            double largestScaledElmt = 0.0;
            int rLargest = 0;
            for (int r = rPivot; r < this.nRows; ++r) {
                int pr = this.permutation[r];
                double absElmt = Math.abs(this.LU.at(pr, rPivot));
                double scaledElmt = absElmt * scales[pr];
                if (!(largestScaledElmt < scaledElmt)) continue;
                largestScaledElmt = scaledElmt;
                rLargest = r;
            }
            if (largestScaledElmt == 0.0) {
                throw new MatrixException("Matrix is singular.");
            }
            if (rLargest != rPivot) {
                int temp = this.permutation[rPivot];
                this.permutation[rPivot] = this.permutation[rLargest];
                this.permutation[rLargest] = temp;
                ++this.exchangeCount;
            }
            int prPivot = this.permutation[rPivot];
            double pivotElmt = this.LU.at(prPivot, rPivot);
            for (int r = rPivot + 1; r < this.nRows; ++r) {
                int pr = this.permutation[r];
                double multiple = this.LU.at(pr, rPivot) / pivotElmt;
                this.LU.set(pr, rPivot, multiple);
                if (multiple == 0.0) continue;
                for (int c = rPivot + 1; c < this.nCols; ++c) {
                    double elmt = this.LU.at(pr, c);
                    this.LU.set(pr, c, elmt -= multiple * this.LU.at(prPivot, c));
                }
            }
        }
    }

    private ColumnVector forwardSubstitution(ColumnVector b) throws MatrixException {
        ColumnVector y = new ColumnVector(this.nRows);
        for (int r = 0; r < this.nRows; ++r) {
            int pr = this.permutation[r];
            double dot = 0.0;
            for (int c = 0; c < r; ++c) {
                dot += this.LU.at(pr, c) * y.at(c);
            }
            y.set(r, b.at(pr) - dot);
        }
        return y;
    }

    private ColumnVector backSubstitution(ColumnVector y) throws MatrixException {
        ColumnVector x = new ColumnVector(this.nRows);
        for (int r = this.nRows - 1; r >= 0; --r) {
            int pr = this.permutation[r];
            double dot = 0.0;
            for (int c = r + 1; c < this.nRows; ++c) {
                dot += this.LU.at(pr, c) * x.at(c);
            }
            x.set(r, (y.at(r) - dot) / this.LU.at(pr, r));
        }
        return x;
    }

    private void improve(ColumnVector b, ColumnVector x) throws MatrixException {
        double largestX = 0.0;
        for (int r = 0; r < this.nRows; ++r) {
            double absX = Math.abs(x.values[r][0]);
            if (!(largestX < absX)) continue;
            largestX = absX;
        }
        if (largestX == 0.0) {
            return;
        }
        ColumnVector residuals = new ColumnVector(this.nRows);
        for (int iter = 0; iter < MAX_ITER; ++iter) {
            for (int r = 0; r < this.nRows; ++r) {
                double dot = 0.0;
                double[] row = this.values[r];
                for (int c = 0; c < this.nRows; ++c) {
                    double elmt = this.at(r, c);
                    dot += elmt * x.at(c);
                }
                double value = b.at(r) - dot;
                residuals.set(r, value);
            }
            ColumnVector z = this.solve(residuals, false);
            double largestDiff = 0.0;
            for (int r = 0; r < this.nRows; ++r) {
                double oldX = x.at(r);
                x.set(r, oldX + z.at(r));
                double diff = Math.abs(x.at(r) - oldX);
                if (!(largestDiff < diff)) continue;
                largestDiff = diff;
            }
            if (!(largestDiff < largestX * 1.0E-5)) continue;
            return;
        }
        throw new MatrixException("Solution did not converge.");
    }

    static {
        int i = 0;
        for (double t = 1.0E-5; t < 1.0; t *= 10.0) {
            ++i;
        }
        MAX_ITER = 2 * i;
    }
}

