/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.features;

import com.vividsolutions.jts.geom.Geometry;
import java.util.List;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class FeatureGeometrySubstitutor {
    private SimpleFeatureType newFeatureType;

    public FeatureGeometrySubstitutor(SimpleFeatureType oldFeatureType) throws Exception {
        this(oldFeatureType, null);
    }

    public FeatureGeometrySubstitutor(SimpleFeatureType oldFeatureType, Class<?> newGeometryType) throws Exception {
        List oldAttributeDescriptors = oldFeatureType.getAttributeDescriptors();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(oldFeatureType.getName());
        b.setCRS(oldFeatureType.getCoordinateReferenceSystem());
        if (newGeometryType == null) {
            b.addAll(oldAttributeDescriptors);
        } else {
            for (AttributeDescriptor attributeDescriptor : oldAttributeDescriptors) {
                if (attributeDescriptor instanceof GeometryDescriptor) {
                    b.add("the_geom", newGeometryType);
                    continue;
                }
                b.add(attributeDescriptor);
            }
        }
        this.newFeatureType = b.buildFeatureType();
    }

    public SimpleFeatureType getNewFeatureType() {
        return this.newFeatureType;
    }

    public SimpleFeature substituteGeometry(SimpleFeature oldFeature, Geometry newGeometry) {
        return this.substituteGeometry(oldFeature, newGeometry, null);
    }

    public SimpleFeature substituteGeometry(SimpleFeature oldFeature, Geometry newGeometry, String id) {
        Object[] attributes = oldFeature.getAttributes().toArray();
        Object[] newAttributes = new Object[attributes.length];
        System.arraycopy(attributes, 0, newAttributes, 0, attributes.length);
        newAttributes[0] = newGeometry;
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.newFeatureType);
        builder.addAll(newAttributes);
        SimpleFeature f = builder.buildFeature(id);
        return f;
    }
}

