/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jgrasstools.gears.utils.clustering.GvmCluster;
import org.jgrasstools.gears.utils.clustering.GvmClusterPair;
import org.jgrasstools.gears.utils.clustering.GvmClusterPairs;
import org.jgrasstools.gears.utils.clustering.GvmDefaultKeyer;
import org.jgrasstools.gears.utils.clustering.GvmKeyer;
import org.jgrasstools.gears.utils.clustering.GvmResult;
import org.jgrasstools.gears.utils.clustering.GvmSpace;

public class GvmClusters<S extends GvmSpace, K> {
    final int capacity;
    final S space;
    private GvmKeyer<K> keyer = new GvmDefaultKeyer();
    private final GvmCluster<S, K>[] clusters;
    private final GvmClusterPairs<S, K> pairs;
    private int additions = 0;
    private int count = 0;
    private int bound = 0;

    static double correct(double var) {
        return var >= 0.0 ? var : 0.0;
    }

    public GvmClusters(S space, int capacity) {
        if (space == null) {
            throw new IllegalArgumentException("null space");
        }
        if (capacity < 0) {
            throw new IllegalArgumentException("negative capacity");
        }
        this.space = space;
        this.capacity = capacity;
        this.clusters = new GvmCluster[capacity];
        this.pairs = new GvmClusterPairs(capacity * (capacity - 1) / 2);
    }

    public GvmKeyer<K> getKeyer() {
        return this.keyer;
    }

    public void setKeyer(GvmKeyer<K> keyer) {
        if (keyer == null) {
            throw new IllegalArgumentException();
        }
        this.keyer = keyer;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public S getSpace() {
        return this.space;
    }

    public void clear() {
        Arrays.fill(this.clusters, 0, this.bound, null);
        this.pairs.clear();
        this.additions = 0;
        this.count = 0;
        this.bound = 0;
    }

    public void add(double m, Object pt, K key) {
        if (m == 0.0) {
            return;
        }
        if (this.count < this.capacity) {
            GvmCluster cluster = new GvmCluster(this);
            this.clusters[this.additions] = cluster;
            cluster.set(m, pt);
            this.addPairs();
            cluster.key = this.keyer.addKey(cluster, key);
            ++this.count;
            this.bound = this.count;
        } else {
            GvmClusterPair<S, K> mergePair = this.pairs.peek();
            double mergeT = mergePair == null ? Double.MAX_VALUE : mergePair.value;
            GvmCluster<S, K> additionC = null;
            double additionT = Double.MAX_VALUE;
            for (int i = 0; i < this.clusters.length; ++i) {
                GvmCluster<S, K> cluster = this.clusters[i];
                double t = cluster.test(m, pt);
                if (!(t < additionT)) continue;
                additionC = cluster;
                additionT = t;
            }
            if (additionT <= mergeT) {
                additionC.add(m, pt);
                this.updatePairs(additionC);
                additionC.key = this.keyer.addKey(additionC, key);
            } else {
                GvmCluster c1 = mergePair.c1;
                GvmCluster c2 = mergePair.c2;
                if (c1.m0 < c2.m0) {
                    c1 = c2;
                    c2 = mergePair.c1;
                }
                c1.key = this.keyer.mergeKeys(c1, c2);
                c1.add(c2);
                this.updatePairs(c1);
                c2.set(m, pt);
                this.updatePairs(c2);
                c2.key = null;
                c2.key = this.keyer.addKey(c2, key);
            }
        }
        ++this.additions;
    }

    public void reduce(double maxVar, int minClusters) {
        int i;
        if (minClusters < 0) {
            throw new IllegalArgumentException("negative minClusters");
        }
        if (this.count <= minClusters) {
            return;
        }
        double totalVar = 0.0;
        double totalMass = 0.0;
        for (i = 0; i < this.count; ++i) {
            GvmCluster<S, K> cluster = this.clusters[i];
            totalVar += cluster.var;
            totalMass += cluster.m0;
        }
        while (this.count > minClusters) {
            if (this.count == 1) {
                for (i = 0; i < this.bound; ++i) {
                    GvmCluster<S, K> c = this.clusters[i];
                    if (c.removed) continue;
                    c.removed = true;
                    break;
                }
            } else {
                double diff;
                GvmClusterPair<S, K> mergePair = this.pairs.peek();
                GvmCluster c1 = mergePair.c1;
                GvmCluster c2 = mergePair.c2;
                if (c1.m0 < c2.m0) {
                    c1 = c2;
                    c2 = mergePair.c1;
                }
                if (maxVar >= 0.0 && (totalVar += (diff = c1.test(c2) - c1.var - c2.var)) / totalMass > maxVar) break;
                c1.key = this.keyer.mergeKeys(c1, c2);
                c1.add(c2);
                this.updatePairs(c1);
                this.removePairs(c2);
                c2.removed = true;
            }
            --this.count;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < this.bound) {
            boolean lose = this.clusters[i2].removed;
            if (lose) {
                ++i2;
                continue;
            }
            if (i2 != j) {
                this.clusters[j] = this.clusters[i2];
            }
            ++i2;
            ++j;
        }
        while (j < this.bound) {
            this.clusters[j] = null;
            ++j;
        }
        for (i = 0; i < this.count; ++i) {
            GvmCluster<S, K> cluster = this.clusters[i];
            GvmClusterPair<S, K>[] pairs = cluster.pairs;
            int k = 0;
            int j2 = 0;
            while (j2 < this.bound - 1) {
                boolean lose;
                GvmClusterPair pair = pairs[j2];
                boolean bl = lose = pair.c1.removed || pair.c2.removed;
                if (lose) {
                    ++j2;
                    continue;
                }
                if (j2 != k) {
                    pairs[k] = pairs[j2];
                }
                ++k;
                ++j2;
            }
            while (k < this.bound) {
                pairs[k] = null;
                ++k;
            }
        }
        this.bound = this.count;
    }

    public List<GvmResult<K>> results() {
        ArrayList<GvmResult<K>> list = new ArrayList<GvmResult<K>>(this.count);
        for (int i = 0; i < this.count; ++i) {
            GvmCluster<S, K> cluster = this.clusters[i];
            list.add(new GvmResult<K>(cluster));
        }
        return list;
    }

    private void addPairs() {
        GvmCluster<S, K> cj = this.clusters[this.count];
        int c = this.count - 1;
        for (int i = 0; i < this.count; ++i) {
            GvmCluster<S, K> ci = this.clusters[i];
            GvmClusterPair<S, K> pair = new GvmClusterPair<S, K>(ci, cj);
            ci.pairs[c] = pair;
            cj.pairs[i] = pair;
            this.pairs.add(pair);
        }
    }

    private void updatePairs(GvmCluster<S, K> cluster) {
        GvmClusterPair<S, K>[] pairs = cluster.pairs;
        if (this.count == this.bound) {
            int limit = this.count - 1;
            for (int i = 0; i < limit; ++i) {
                this.pairs.reprioritize(pairs[i]);
            }
        } else {
            int limit = this.bound - 1;
            for (int i = 0; i < limit; ++i) {
                GvmClusterPair pair = pairs[i];
                if (pair.c1.removed || pair.c2.removed) continue;
                this.pairs.reprioritize(pair);
            }
        }
    }

    private void removePairs(GvmCluster<S, K> cluster) {
        GvmClusterPair<S, K>[] pairs = cluster.pairs;
        for (int i = 0; i < this.bound - 1; ++i) {
            GvmClusterPair pair = pairs[i];
            if (pair.c1.removed || pair.c2.removed) continue;
            this.pairs.remove(pair);
        }
    }
}

