/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.chart;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jgrasstools.gears.utils.chart.IChart;
import org.jgrasstools.gears.utils.chart.PlotFrame;

public class CategoryHistogram
implements IChart {
    private String[] categories;
    private double[] values;
    private DefaultCategoryDataset dataset;
    private String title;
    private JFreeChart chart;

    public CategoryHistogram(String[] categories, double[] values) {
        this("Histogram", categories, values);
    }

    public CategoryHistogram(String title, String[] categories, double[] values) {
        this.title = title;
        this.categories = categories;
        this.values = values;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void createDataset() {
        this.dataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.categories.length; ++i) {
            this.dataset.addValue(this.values[i], (Comparable)((Object)""), (Comparable)((Object)this.categories[i]));
        }
    }

    @Override
    public JFreeChart getChart() {
        if (this.chart == null) {
            this.createDataset();
            this.chart = ChartFactory.createBarChart((String)this.title, (String)"Category", (String)"Value", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
            CategoryAxis rangeAxis = plot.getDomainAxis();
            rangeAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        }
        return this.chart;
    }

    public static void main(String[] args) {
        String[] asd = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        double[] qwe = new double[]{1.0, 2.0, 3.0, 2.5, 5.5, 1.0, 2.0};
        CategoryHistogram categoryHistogram = new CategoryHistogram(asd, qwe);
        PlotFrame frame = new PlotFrame(categoryHistogram);
        frame.setDimension(1600, 1000);
        frame.plot();
    }
}

