/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.intersections;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.operation.linemerge.LineSequencer;
import com.vividsolutions.jts.operation.overlay.snap.GeometrySnapper;
import com.vividsolutions.jts.operation.union.CascadedPolygonUnion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.graph.build.line.BasicLineGraphGenerator;
import org.geotools.graph.path.DijkstraShortestPathFinder;
import org.geotools.graph.path.Path;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.standard.DijkstraIterator;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.modules.v.intersections.FeatureElevationComparer;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;

@Description(value="Collection of Smoothing Algorithms. Type 0: McMasters Sliding Averaging Algorithm. The new position of each point is the average of the pLookahead  points around. Parameter pSlide is used for linear interpolation between old and new position.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Smoothing, Vector")
@Label(value="Vector Processing")
@Name(value="lineintersectioncorrector")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsLineIntersectionCorrector
extends JGTModel {
    @Description(value="The features to be corrected.")
    @In
    public SimpleFeatureCollection linesFeatures;
    @Description(value="The point features that define intersections.")
    @In
    public SimpleFeatureCollection pointFeatures;
    @Description(value="Protection buffer.")
    @In
    public double pBuffer = 0.05;
    @Description(value="Field name of sorting attribute.")
    @In
    public String fSort = null;
    @Description(value="Sorting order (default is true).")
    @In
    public boolean doReverse = true;
    @Description(value="The untouched features.")
    @Out
    public SimpleFeatureCollection untouchedFeatures;
    @Description(value="The corrected features.")
    @Out
    public SimpleFeatureCollection correctedFeatures;
    @Description(value="The non corrected features.")
    @Out
    public SimpleFeatureCollection errorFeatures;
    private static final double DELTA5 = 1.0E-5;
    private static final double DELTA6 = 1.0E-6;
    private GeometryFactory gF = GeometryUtilities.gf();

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.correctedFeatures == null, this.doReset)) {
            return;
        }
        this.untouchedFeatures = new DefaultFeatureCollection();
        this.correctedFeatures = new DefaultFeatureCollection();
        this.errorFeatures = new DefaultFeatureCollection();
        int pSize = this.pointFeatures.size();
        this.pm.message("Intersection points to handle: " + pSize);
        ArrayList<LineString> pointsEnvelopes = new ArrayList<LineString>(pSize);
        SimpleFeatureIterator pointsIterator = this.pointFeatures.features();
        this.pm.beginTask("Create point bounds...", pSize);
        while (pointsIterator.hasNext()) {
            Coordinate[] coordinates;
            SimpleFeature feature = (SimpleFeature)pointsIterator.next();
            Geometry point = (Geometry)feature.getDefaultGeometry();
            for (Coordinate c : coordinates = point.getCoordinates()) {
                double pbuff = 0.05;
                Coordinate ll = new Coordinate(c.x - pbuff, c.y - pbuff);
                Coordinate ul = new Coordinate(c.x - pbuff, c.y + pbuff);
                Coordinate ur = new Coordinate(c.x + pbuff, c.y + pbuff);
                Coordinate lr = new Coordinate(c.x + pbuff, c.y - pbuff);
                Coordinate end = new Coordinate(c.x - pbuff, c.y - pbuff);
                LineString envelopeLine = this.gF.createLineString(new Coordinate[]{ll, ul, ur, lr, end});
                pointsEnvelopes.add(envelopeLine);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        pointsIterator.close();
        SimpleFeatureIterator inFeatureIterator = this.linesFeatures.features();
        int size = this.linesFeatures.size();
        ArrayList<FeatureElevationComparer> badFeatures = new ArrayList<FeatureElevationComparer>(pSize);
        this.pm.beginTask("Extract intersecting lines...", size);
        while (inFeatureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)inFeatureIterator.next();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)geometry);
            boolean touched = false;
            for (LineString envelope : pointsEnvelopes) {
                if (!preparedGeometry.intersects((Geometry)envelope)) continue;
                badFeatures.add(new FeatureElevationComparer(feature, this.fSort, this.pBuffer, 0.0));
                touched = true;
                break;
            }
            if (!touched) {
                ((DefaultFeatureCollection)this.untouchedFeatures).add(feature);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        inFeatureIterator.close();
        Collections.sort(badFeatures);
        if (this.doReverse) {
            Collections.reverse(badFeatures);
        }
        int id = 0;
        size = badFeatures.size();
        this.pm.message("Found intersecting lines: " + size);
        this.pm.beginTask("Correcting intersections...", size);
        for (FeatureElevationComparer featureElevationComparer : badFeatures) {
            if (featureElevationComparer.toRemove()) continue;
            SimpleFeature feature = featureElevationComparer.getFeature();
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            int numGeometries = geometry.getNumGeometries();
            ArrayList<LineString> geomList = new ArrayList<LineString>(numGeometries);
            for (int i = 0; i < numGeometries; ++i) {
                geomList.add((LineString)geometry.getGeometryN(i));
            }
            LineString[] lsArray = geomList.toArray(new LineString[numGeometries]);
            try {
                boolean splitCoordinates = this.correctLineIntersections(featureElevationComparer, badFeatures, lsArray, id);
                if (splitCoordinates) {
                    geomList.clear();
                    for (LineString lineString : lsArray) {
                        ArrayList<Coordinate> tmpList;
                        int n;
                        Coordinate[] coordinates = lineString.getCoordinates();
                        if (coordinates[0].distance(coordinates[(n = coordinates.length) - 1]) < 1.0E-5) {
                            int i;
                            int length = coordinates.length;
                            int quarter = length / 4;
                            tmpList = new ArrayList<Coordinate>(coordinates.length);
                            for (i = quarter; i < coordinates.length - 1; ++i) {
                                tmpList.add(coordinates[i]);
                            }
                            for (i = 0; i <= quarter; ++i) {
                                tmpList.add(coordinates[i]);
                            }
                        } else {
                            throw new RuntimeException("Not implemented yet.");
                        }
                        Coordinate[] tmpArray = tmpList.toArray(new Coordinate[tmpList.size()]);
                        geomList.add(this.gF.createLineString(tmpArray));
                    }
                    lsArray = geomList.toArray(new LineString[numGeometries]);
                    this.correctLineIntersections(featureElevationComparer, badFeatures, lsArray, id);
                }
                ++id;
            }
            catch (Exception e) {
                e.printStackTrace();
                featureElevationComparer.setDirty(true);
                continue;
            }
            this.pm.worked(1);
        }
        this.pm.done();
        for (FeatureElevationComparer featureElevationComparer : badFeatures) {
            if (featureElevationComparer.toRemove()) continue;
            SimpleFeature feature = featureElevationComparer.getFeature();
            if (!featureElevationComparer.isDirty()) {
                ((DefaultFeatureCollection)this.correctedFeatures).add(feature);
                continue;
            }
            ((DefaultFeatureCollection)this.errorFeatures).add(feature);
        }
    }

    private DijkstraIterator.EdgeWeighter costFunction() {
        return new DijkstraIterator.EdgeWeighter(){

            public double getWeight(Edge e) {
                int id = e.getID();
                if (id % 2 == 0) {
                    return 1.0;
                }
                return 10000.0;
            }
        };
    }

    private boolean correctLineIntersections(FeatureElevationComparer currentFeatureElevationComparer, List<FeatureElevationComparer> comparerList, LineString[] lsArray, int currentLineIndex) throws Exception {
        ArrayList<LineString> newLines = new ArrayList<LineString>(lsArray.length);
        for (final LineString line : lsArray) {
            Coordinate[] lineCoords = line.getCoordinates();
            boolean hadEqualBounds = false;
            if (lineCoords[0].distance(lineCoords[lineCoords.length - 1]) < 1.0E-6) {
                hadEqualBounds = true;
                Coordinate coordinate = new Coordinate();
                coordinate.x = lineCoords[lineCoords.length - 1].x + 1.0E-6;
                coordinate.y = lineCoords[lineCoords.length - 1].y + 1.0E-6;
                lineCoords[lineCoords.length - 1] = coordinate;
            }
            ArrayList<Polygon> intersectingPolygons = new ArrayList<Polygon>();
            PreparedGeometry preparedLine = PreparedGeometryFactory.prepare((Geometry)line);
            int index = 0;
            for (FeatureElevationComparer featureComparer : comparerList) {
                if (featureComparer.toRemove()) continue;
                if (index == currentLineIndex) {
                    ++index;
                    continue;
                }
                ++index;
                Geometry geom = featureComparer.getGeometry();
                if (!preparedLine.intersects(geom)) continue;
                Geometry bufferPolygon = featureComparer.getBufferPolygon();
                int numGeometries = bufferPolygon.getNumGeometries();
                for (int i = 0; i < numGeometries; ++i) {
                    Geometry geometryN = bufferPolygon.getGeometryN(i);
                    intersectingPolygons.add((Polygon)geometryN);
                }
            }
            if (intersectingPolygons.size() > 0) {
                Geometry[] collection;
                block24: {
                    final Geometry union = CascadedPolygonUnion.union(intersectingPolygons);
                    if (union.covers((Geometry)this.gF.createPoint(lineCoords[0]))) {
                        return true;
                    }
                    collection = new Geometry[1];
                    long time1 = System.currentTimeMillis();
                    try {
                        collection[0] = union.symDifference((Geometry)line);
                    }
                    catch (Exception e) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                double snapTol = GeometrySnapper.computeOverlaySnapTolerance((Geometry)union, (Geometry)line);
                                Geometry aFix = OmsLineIntersectionCorrector.this.selfSnap(union, snapTol);
                                collection[0] = aFix.symDifference((Geometry)line);
                            }
                        });
                        t.start();
                        long time2 = System.currentTimeMillis();
                        long sec = (time2 - time1) / 1000L;
                        while (sec < 60L && collection[0] == null) {
                            Thread.sleep(300L);
                            time2 = System.currentTimeMillis();
                            sec = (time2 - time1) / 1000L;
                        }
                        if (t.isAlive()) {
                            t.interrupt();
                        }
                        if (collection[0] != null) break block24;
                        throw new RuntimeException("Didn't make it to create the snap.");
                    }
                }
                BasicLineGraphGenerator lineStringGen = new BasicLineGraphGenerator();
                if (!(collection[0] instanceof GeometryCollection)) continue;
                GeometryCollection geomCollection = (GeometryCollection)collection[0];
                int numGeometries = geomCollection.getNumGeometries();
                ArrayList<LineSegment> linesS = new ArrayList<LineSegment>(numGeometries);
                ArrayList<LineSegment> otherLinesS = new ArrayList<LineSegment>(numGeometries);
                for (int i = 0; i < numGeometries; ++i) {
                    LineSegment seg;
                    Coordinate sec;
                    Coordinate first;
                    int j;
                    Geometry geometryN = geomCollection.getGeometryN(i);
                    Coordinate[] coordinates = geometryN.getCoordinates();
                    if (geometryN instanceof LineString) {
                        for (j = 0; j < coordinates.length - 1; ++j) {
                            first = coordinates[j];
                            sec = coordinates[j + 1];
                            seg = new LineSegment(first, sec);
                            linesS.add(seg);
                        }
                        continue;
                    }
                    for (j = 0; j < coordinates.length - 1; ++j) {
                        first = coordinates[j];
                        sec = coordinates[j + 1];
                        seg = new LineSegment(first, sec);
                        otherLinesS.add(seg);
                    }
                }
                int id = 0;
                for (LineSegment l : linesS) {
                    lineStringGen.add((Object)l);
                    Edge edge = lineStringGen.getEdge(l.p0, l.p1);
                    edge.setID(id);
                    id += 2;
                }
                id = 1;
                for (LineSegment l : otherLinesS) {
                    lineStringGen.add((Object)l);
                    Edge edge = lineStringGen.getEdge(l.p0, l.p1);
                    edge.setID(id);
                    id += 2;
                }
                Graph graph = lineStringGen.getGraph();
                Node startNode = lineStringGen.getNode(lineCoords[0]);
                Node endNode = lineStringGen.getNode(lineCoords[lineCoords.length - 1]);
                DijkstraShortestPathFinder pfinder = new DijkstraShortestPathFinder(graph, (Graphable)startNode, this.costFunction());
                pfinder.calculate();
                Path path = null;
                try {
                    path = pfinder.getPath((Graphable)endNode);
                }
                catch (Exception e) {
                    return true;
                }
                LineSequencer ls = new LineSequencer();
                for (Edge edge : path.getEdges()) {
                    Object object = edge.getObject();
                    if (!(object instanceof LineSegment)) continue;
                    LineSegment seg = (LineSegment)object;
                    ls.add((Geometry)this.gF.createLineString(new Coordinate[]{seg.p0, seg.p1}));
                }
                Geometry sequencedLineStrings = ls.getSequencedLineStrings();
                Coordinate[] coordinates = sequencedLineStrings.getCoordinates();
                if (coordinates.length != 0) {
                    if (hadEqualBounds) {
                        coordinates[coordinates.length - 1] = new Coordinate(coordinates[0]);
                    }
                    ArrayList<Coordinate> tmp = new ArrayList<Coordinate>(coordinates.length);
                    for (int i = 0; i < coordinates.length; ++i) {
                        if (i % 2 != 0 && i != coordinates.length - 1) continue;
                        tmp.add(coordinates[i]);
                    }
                    coordinates = tmp.toArray(new Coordinate[tmp.size()]);
                    LineString resultGeometry = this.gF.createLineString(coordinates);
                    double newLength = resultGeometry.getLength();
                    double length = line.getLength();
                    if (Math.abs(length - newLength) > 0.5 * length) {
                        return true;
                    }
                    newLines.add(resultGeometry);
                    continue;
                }
                return true;
            }
            newLines.add(line);
        }
        LineString[] linesArray = newLines.size() == 0 ? lsArray : newLines.toArray(new LineString[newLines.size()]);
        MultiLineString multiLineString = this.gF.createMultiLineString(linesArray);
        currentFeatureElevationComparer.substituteGeometry((Geometry)multiLineString);
        return false;
    }

    private Geometry selfSnap(Geometry g, double snapTolerance) {
        GeometrySnapper snapper = new GeometrySnapper(g);
        Geometry snapped = snapper.snapTo(g, snapTolerance);
        Geometry fix = snapped.buffer(0.0);
        return fix;
    }
}

