/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core.liblas;

import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.liblas.LiblasJNALibrary;
import org.jgrasstools.gears.io.las.utils.LasUtils;
import org.joda.time.DateTime;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LiblasHeader
implements ILasHeader {
    private LiblasJNALibrary WRAPPER;
    private String signature = "";
    private short fileSourceId = 0;
    private long projectIdGuidData1 = 0L;
    private short projectIdGuidData2 = 0;
    private short projectIdGuidData3 = 0;
    private String projectIdGuidData4 = "";
    private byte versionMajor = 0;
    private byte versionMinor = 0;
    private String systemIdentifier = "";
    private String generatingSoftware = "";
    private short dayOfYear = 0;
    private short year = 0;
    private short headerSize = 0;
    private long offset = 0L;
    private long variableLengthRecordNum = 0L;
    private byte pointDataFormat = 0;
    private short recordLength = 0;
    private long pointRecordsCount = 0L;
    private int gpsTimeType;
    private double xScale = 0.0;
    private double yScale = 0.0;
    private double zScale = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double zOffset = 0.0;
    private double xMax = 0.0;
    private double xMin = 0.0;
    private double yMax = 0.0;
    private double yMin = 0.0;
    private double zMax = 0.0;
    private double zMin = 0.0;
    private CoordinateReferenceSystem crs;
    private ReferencedEnvelope3D dataEnvelope;

    public LiblasHeader(LiblasJNALibrary wrapper, long headerHandle, CoordinateReferenceSystem crs) {
        this.WRAPPER = wrapper;
        this.crs = crs;
        this.pointRecordsCount = this.WRAPPER.LASHeader_GetPointRecordsCount(headerHandle);
        this.recordLength = this.WRAPPER.LASHeader_GetDataRecordLength(headerHandle);
        this.xMin = this.WRAPPER.LASHeader_GetMinX(headerHandle);
        this.yMin = this.WRAPPER.LASHeader_GetMinY(headerHandle);
        this.zMin = this.WRAPPER.LASHeader_GetMinZ(headerHandle);
        this.xMax = this.WRAPPER.LASHeader_GetMaxX(headerHandle);
        this.yMax = this.WRAPPER.LASHeader_GetMaxY(headerHandle);
        this.zMax = this.WRAPPER.LASHeader_GetMaxZ(headerHandle);
        this.xOffset = this.WRAPPER.LASHeader_GetOffsetX(headerHandle);
        this.yOffset = this.WRAPPER.LASHeader_GetOffsetY(headerHandle);
        this.zOffset = this.WRAPPER.LASHeader_GetOffsetZ(headerHandle);
        this.xScale = this.WRAPPER.LASHeader_GetScaleX(headerHandle);
        this.yScale = this.WRAPPER.LASHeader_GetScaleY(headerHandle);
        this.zScale = this.WRAPPER.LASHeader_GetScaleZ(headerHandle);
        this.signature = this.WRAPPER.LASHeader_GetFileSignature(headerHandle);
        this.fileSourceId = this.WRAPPER.LASHeader_GetFileSourceId(headerHandle);
        this.WRAPPER.LASHeader_GetReserved(headerHandle);
        this.WRAPPER.LASHeader_GetProjectId(headerHandle);
        this.versionMajor = this.WRAPPER.LASHeader_GetVersionMajor(headerHandle);
        this.versionMinor = this.WRAPPER.LASHeader_GetVersionMinor(headerHandle);
        this.systemIdentifier = this.WRAPPER.LASHeader_GetSystemId(headerHandle);
        this.generatingSoftware = this.WRAPPER.LASHeader_GetSoftwareId(headerHandle);
        this.dayOfYear = this.WRAPPER.LASHeader_GetCreationDOY(headerHandle);
        this.year = this.WRAPPER.LASHeader_GetCreationYear(headerHandle);
        this.headerSize = this.WRAPPER.LASHeader_GetHeaderSize(headerHandle);
        this.offset = this.WRAPPER.LASHeader_GetDataOffset(headerHandle);
        this.pointDataFormat = this.WRAPPER.LASHeader_GetDataFormatId(headerHandle);
    }

    @Override
    public double[] getXYZScale() {
        return new double[]{this.xScale, this.yScale, this.zScale};
    }

    @Override
    public double[] getXYZOffset() {
        return new double[]{this.xOffset, this.yOffset, this.zOffset};
    }

    @Override
    public short getRecordLength() {
        return this.recordLength;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setGpsTimeType(int gpsTimeType) {
        this.gpsTimeType = gpsTimeType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("File signature: ").append(this.signature).append("\n");
        sb.append("File source ID: ").append(this.fileSourceId).append("\n");
        sb.append("Project ID - data 1: ").append(this.projectIdGuidData1).append("\n");
        sb.append("Project ID - data 2: ").append(this.projectIdGuidData2).append("\n");
        sb.append("Project ID - data 3: ").append(this.projectIdGuidData3).append("\n");
        sb.append("Project ID - data 4: ").append(this.projectIdGuidData4).append("\n");
        sb.append("Version: ").append(this.versionMajor).append(".").append(this.versionMinor).append("\n");
        sb.append("System identifier: ").append(this.systemIdentifier).append("\n");
        sb.append("Generating software: ").append(this.generatingSoftware).append("\n");
        if (this.dayOfYear != 0 && this.year != 0) {
            DateTime dateTime = new DateTime();
            dateTime = dateTime.withYear((int)this.year).withDayOfYear((int)this.dayOfYear);
            String dtString = dateTime.toString(LasUtils.dateTimeFormatterYYYYMMDD);
            sb.append("File creation date: ").append(dtString).append("\n");
        } else {
            sb.append("File creation Day of Year: ").append(this.dayOfYear).append("\n");
            sb.append("File creation Year: ").append(this.year).append("\n");
        }
        sb.append("Header size: ").append(this.headerSize).append("\n");
        sb.append("Offset to data: ").append(this.offset).append("\n");
        sb.append("Variable length records: ").append(this.variableLengthRecordNum).append("\n");
        sb.append("Point data format ID (0-99 for spec): ").append(this.pointDataFormat).append("\n");
        sb.append("Number of point records: ").append(this.pointRecordsCount).append("\n");
        sb.append("Record length: ").append(this.recordLength).append("\n");
        sb.append("Scale: [").append(this.xScale).append(", ").append(this.yScale).append(", ").append(this.zScale).append("]\n");
        sb.append("Offset: [").append(this.xOffset).append(", ").append(this.yOffset).append(", ").append(this.zOffset).append("]\n");
        sb.append("X Range: [").append(this.xMin).append(", ").append(this.xMax).append("]\n");
        sb.append("Y Range: [").append(this.yMin).append(", ").append(this.yMax).append("]\n");
        sb.append("Z Range: [").append(this.zMin).append(", ").append(this.zMax).append("]\n");
        sb.append("Has gps time info: ").append(this.hasGpsTime()).append("\n");
        sb.append("Has color info: ").append(this.hasRGB()).append("\n");
        return sb.toString();
    }

    @Override
    public String getVersion() {
        return this.versionMajor + "." + this.versionMinor;
    }

    @Override
    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public ReferencedEnvelope3D getDataEnvelope() {
        if (this.dataEnvelope == null) {
            this.dataEnvelope = new ReferencedEnvelope3D(this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax, this.getCrs());
        }
        return this.dataEnvelope;
    }

    @Override
    public long getRecordsCount() {
        return this.pointRecordsCount;
    }

    @Override
    public boolean hasGpsTime() {
        return this.pointDataFormat == 1 || this.pointDataFormat == 3;
    }

    @Override
    public boolean hasRGB() {
        return this.pointDataFormat == 2 || this.pointDataFormat == 3;
    }

    @Override
    public byte getPointDataFormat() {
        return this.pointDataFormat;
    }

    @Override
    public int getGpsTimeType() {
        return this.gpsTimeType;
    }
}

