/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.csv;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Utility class for reading data from a OMS formatted csv file to a double matrix (dates are saved as longs).")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Reading, csv")
@Label(value="Matrix Reader")
@Name(value="csvmatrixreader")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsCsvMatrixReader
extends JGTModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The file novalue to be translated into the internal novalue (defaults to -9999.0). Can be also a string.")
    @In
    public String fileNovalue = "-9999.0";
    @Description(value="The internal novalue to use (defaults to NaN).")
    @In
    public double novalue = Double.NaN;
    @Description(value="The matrix of read data.")
    @Out
    public double[][] outData;
    @Description(value="The data title.")
    @Out
    public String outTitle;
    @Description(value="The data subtitle.")
    @Out
    public String outSubTitle;
    @Description(value="The data series names.")
    @Out
    public String[] outIds;
    @Description(value="The data labels or null.")
    @Out
    public String[] outLabels;
    @Description(value="The data formats (dates and numeric formatting patterns) or null.")
    @Out
    public String[] outFormats;
    @Description(value="The data types (dates or numerics like double, int) or null.")
    @Out
    public String[] outTypes;
    private TableIterator<String[]> rowsIterator;
    private CSTable table;
    private int columnCount;
    private List<String> outIdsList = new ArrayList<String>();
    private List<String> outLabelsList = new ArrayList<String>();
    private List<String> outFormatsList = new ArrayList<String>();
    private List<String> outTypesList = new ArrayList<String>();
    private List<double[]> outDataList = new ArrayList<double[]>();
    private DateTimeFormatter dateFormatter;

    private void ensureOpen() throws IOException {
        if (this.table == null) {
            int i;
            this.table = DataIO.table((File)new File(this.file), null);
            this.outTitle = this.table.getName();
            Map info = this.table.getInfo();
            Set entrySet = info.entrySet();
            for (Map.Entry entry : entrySet) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.toLowerCase().equals("subtitle")) continue;
                this.outSubTitle = value;
            }
            this.columnCount = this.table.getColumnCount();
            for (i = 1; i <= this.columnCount; ++i) {
                String columnName = this.table.getColumnName(i);
                if (i > 1) {
                    this.outIdsList.add(columnName);
                }
                Map columnInfo = this.table.getColumnInfo(i);
                Set entrySet1 = columnInfo.entrySet();
                for (Map.Entry entry : entrySet1) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key.toLowerCase().equals("label")) {
                        this.outLabelsList.add(value);
                    }
                    if (key.toLowerCase().equals("format")) {
                        this.outFormatsList.add(value);
                    }
                    if (!key.toLowerCase().equals("type")) continue;
                    if ((value = value.toLowerCase().trim()).length() == 0) {
                        value = "double";
                    }
                    this.outTypesList.add(value);
                }
            }
            if (this.outIdsList.size() > 0) {
                this.outIds = this.outIdsList.toArray(new String[0]);
            }
            if (this.outLabelsList.size() > 0) {
                this.outLabels = this.outLabelsList.toArray(new String[0]);
            }
            if (this.outFormatsList.size() > 0) {
                this.outFormats = this.outFormatsList.toArray(new String[0]);
            }
            if (this.outTypesList.size() == 0) {
                for (i = 1; i <= this.columnCount; ++i) {
                    this.outTypesList.add("double");
                }
            }
            this.outTypes = this.outTypesList.toArray(new String[0]);
            this.rowsIterator = (TableIterator)this.table.rows().iterator();
        }
    }

    @Execute
    public void read() throws IOException {
        this.ensureOpen();
        while (this.rowsIterator.hasNext()) {
            String[] row = (String[])this.rowsIterator.next();
            double[] record = new double[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                double value;
                if (i == 0 && this.outTypes[i].equals("date") && this.outFormats.length > i) {
                    if (this.dateFormatter == null) {
                        this.dateFormatter = DateTimeFormat.forPattern((String)this.outFormats[i]);
                    }
                    DateTime dateTime = this.dateFormatter.parseDateTime(row[i]);
                    record[i - 1] = dateTime.getMillis();
                    continue;
                }
                record[i - 1] = value = Double.parseDouble(row[i]);
            }
            this.outDataList.add(record);
        }
        this.outData = new double[this.outDataList.size()][];
        int index = 0;
        for (double[] record : this.outDataList) {
            this.outData[index++] = record;
        }
    }

    @Finalize
    public void close() throws IOException {
        this.rowsIterator.close();
    }
}

