/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords.chrono;

import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.field.PreciseDurationDateTimeField;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.ZeroIsMaxDateTimeField;

public final class ThreeSixtyDayChronology
extends BaseChronology {
    private static final DurationField millisecondDuration = MillisDurationField.INSTANCE;
    private static final DurationField secondDuration = new PreciseDurationField(DurationFieldType.seconds(), 1000L);
    private static final DurationField minuteDuration = new PreciseDurationField(DurationFieldType.minutes(), 60000L);
    private static final DurationField hourDuration = new PreciseDurationField(DurationFieldType.hours(), 3600000L);
    private static final DurationField halfdayDuration = new PreciseDurationField(DurationFieldType.halfdays(), 43200000L);
    private static final DurationField dayDuration = new PreciseDurationField(DurationFieldType.days(), 2L * halfdayDuration.getUnitMillis());
    private static final DurationField weekDuration = new PreciseDurationField(DurationFieldType.weeks(), 7L * dayDuration.getUnitMillis());
    private static final DurationField monthDuration = new PreciseDurationField(DurationFieldType.months(), 30L * dayDuration.getUnitMillis());
    private static final DurationField yearDuration = new PreciseDurationField(DurationFieldType.years(), 12L * monthDuration.getUnitMillis());
    private static final DurationField centuryDuration = new PreciseDurationField(DurationFieldType.years(), 100L * yearDuration.getUnitMillis());
    private static final DateTimeField millisOfSecond = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), millisecondDuration, secondDuration);
    private static final DateTimeField millisOfDay = new PreciseDateTimeField(DateTimeFieldType.millisOfDay(), millisecondDuration, dayDuration);
    private static final DateTimeField secondOfMinute = new PreciseDateTimeField(DateTimeFieldType.secondOfMinute(), secondDuration, minuteDuration);
    private static final DateTimeField secondOfDay = new PreciseDateTimeField(DateTimeFieldType.secondOfDay(), secondDuration, dayDuration);
    private static final DateTimeField minuteOfHour = new PreciseDateTimeField(DateTimeFieldType.minuteOfHour(), minuteDuration, hourDuration);
    private static final DateTimeField minuteOfDay = new PreciseDateTimeField(DateTimeFieldType.minuteOfDay(), minuteDuration, dayDuration);
    private static final DateTimeField hourOfDay = new PreciseDateTimeField(DateTimeFieldType.hourOfDay(), hourDuration, dayDuration);
    private static final DateTimeField hourOfHalfday = new PreciseDateTimeField(DateTimeFieldType.hourOfHalfday(), hourDuration, halfdayDuration);
    private static final DateTimeField halfdayOfDay = new PreciseDateTimeField(DateTimeFieldType.halfdayOfDay(), halfdayDuration, dayDuration);
    private static final DateTimeField clockhourOfDay = new ZeroIsMaxDateTimeField(hourOfDay, DateTimeFieldType.clockhourOfDay());
    private static final DateTimeField clockhourOfHalfday = new ZeroIsMaxDateTimeField(hourOfHalfday, DateTimeFieldType.clockhourOfHalfday());
    private static final DateTimeField dayOfWeek = new PreciseDateTimeField(DateTimeFieldType.dayOfWeek(), dayDuration, weekDuration);
    private static final DateTimeField dayOfMonth = new OneBasedPreciseDateTimeField(DateTimeFieldType.dayOfMonth(), dayDuration, monthDuration);
    private static final DateTimeField dayOfYear = new OneBasedPreciseDateTimeField(DateTimeFieldType.dayOfYear(), dayDuration, yearDuration);
    private static final DateTimeField monthOfYear = new OneBasedPreciseDateTimeField(DateTimeFieldType.monthOfYear(), monthDuration, yearDuration);
    private static final DateTimeField yearOfCentury = new PreciseDateTimeField(DateTimeFieldType.yearOfCentury(), yearDuration, centuryDuration);
    private static final DateTimeField year = new PreciseDurationDateTimeField(DateTimeFieldType.year(), yearDuration){

        public int get(long instant) {
            return (int)Math.floor((double)instant * 1.0 / (double)yearDuration.getUnitMillis()) + 1970;
        }

        public DurationField getRangeDurationField() {
            return null;
        }

        public int getMinimumValue() {
            return this.get(Long.MIN_VALUE);
        }

        public int getMaximumValue() {
            return this.get(Long.MAX_VALUE) - 1;
        }
    };
    private static final ThreeSixtyDayChronology INSTANCE_UTC = new ThreeSixtyDayChronology();

    private ThreeSixtyDayChronology() {
    }

    public static ThreeSixtyDayChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public DurationField millis() {
        return millisecondDuration;
    }

    public DurationField seconds() {
        return secondDuration;
    }

    public DurationField minutes() {
        return minuteDuration;
    }

    public DurationField hours() {
        return hourDuration;
    }

    public DurationField halfdays() {
        return halfdayDuration;
    }

    public DurationField days() {
        return dayDuration;
    }

    public DurationField weeks() {
        return weekDuration;
    }

    public DurationField months() {
        return monthDuration;
    }

    public DurationField years() {
        return yearDuration;
    }

    public DurationField centuries() {
        return centuryDuration;
    }

    public DateTimeField millisOfSecond() {
        return millisOfSecond;
    }

    public DateTimeField millisOfDay() {
        return millisOfDay;
    }

    public DateTimeField secondOfMinute() {
        return secondOfMinute;
    }

    public DateTimeField secondOfDay() {
        return secondOfDay;
    }

    public DateTimeField minuteOfHour() {
        return minuteOfHour;
    }

    public DateTimeField minuteOfDay() {
        return minuteOfDay;
    }

    public DateTimeField hourOfDay() {
        return hourOfDay;
    }

    public DateTimeField hourOfHalfday() {
        return hourOfHalfday;
    }

    public DateTimeField halfdayOfDay() {
        return halfdayOfDay;
    }

    public DateTimeField clockhourOfDay() {
        return clockhourOfDay;
    }

    public DateTimeField clockhourOfHalfday() {
        return clockhourOfHalfday;
    }

    public DateTimeField dayOfWeek() {
        return dayOfWeek;
    }

    public DateTimeField dayOfMonth() {
        return dayOfMonth;
    }

    public DateTimeField dayOfYear() {
        return dayOfYear;
    }

    public DateTimeField monthOfYear() {
        return monthOfYear;
    }

    public DateTimeField year() {
        return year;
    }

    public DateTimeField yearOfCentury() {
        return yearOfCentury;
    }

    public DateTimeZone getZone() {
        return DateTimeZone.UTC;
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone.equals((Object)DateTimeZone.UTC)) {
            return INSTANCE_UTC;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return "360-day Chronology in UTC";
    }

    private static final class OneBasedPreciseDateTimeField
    extends PreciseDateTimeField {
        public OneBasedPreciseDateTimeField(DateTimeFieldType fieldType, DurationField unit, DurationField range) {
            super(fieldType, unit, range);
        }

        public int getMinimumValue() {
            return super.getMinimumValue() + 1;
        }

        public int getMaximumValue() {
            return super.getMaximumValue() + 1;
        }

        public int get(long instant) {
            return super.get(instant) + 1;
        }
    }
}

