/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.constants.AxisType;
import uk.ac.rdg.resc.ncwms.coords.Longitude;
import uk.ac.rdg.resc.ncwms.coords.OneDCoordAxis;

class Regular1DCoordAxis
extends OneDCoordAxis {
    private static final Logger logger = LoggerFactory.getLogger(Regular1DCoordAxis.class);
    private double start;
    private double stride;
    private double maxValue;
    private boolean wraps;

    public Regular1DCoordAxis(double start, double stride, int count, AxisType axisType) {
        super(axisType, count);
        this.start = start;
        this.stride = stride;
        this.maxValue = this.start + this.stride * (double)(this.size - 1);
        this.wraps = false;
        if (this.isLongitude()) {
            Longitude st = new Longitude(this.start);
            Longitude mid = new Longitude(this.start + this.stride * (double)this.size / 2.0);
            Longitude end = new Longitude(this.start + this.stride * (double)this.size);
            logger.debug("Longitudes: st = {}, mid = {}, end = {}", new Object[]{st.getValue(), mid.getValue(), end.getValue()});
            if (st.equals(end) || st.getClockwiseDistanceTo(mid) > st.getClockwiseDistanceTo(end)) {
                this.wraps = true;
            }
        }
        logger.debug("Created regular {} axis, wraps = {}", (Object)this.getAxisType(), (Object)this.wraps);
    }

    @Override
    public int getIndex(double coordValue) {
        if (this.isLongitude()) {
            logger.debug("Finding value for longitude {}", (Object)coordValue);
            Longitude lon = new Longitude(coordValue);
            if (this.wraps || lon.isBetween(this.start, this.maxValue)) {
                Longitude startLon = new Longitude(this.start);
                double distance = startLon.getClockwiseDistanceTo(lon);
                double exactNumSteps = distance / this.stride;
                int index = (int)Math.round(exactNumSteps) % this.size;
                logger.debug("returning {}", (Object)index);
                return index;
            }
            logger.debug("out of range: returning -1");
            return -1;
        }
        logger.debug("Finding value for {}, {}", (Object)this.getAxisType(), (Object)coordValue);
        double distance = coordValue - this.start;
        double exactNumSteps = distance / this.stride;
        int index = (int)Math.round(exactNumSteps);
        logger.debug("index = {}, count = {}", (Object)index, (Object)this.size);
        if (index < 0 || index >= this.size) {
            logger.debug("returning -1");
            return -1;
        }
        logger.debug("returning {}", (Object)index);
        return index;
    }

    public double getStart() {
        return this.start;
    }

    public double getStride() {
        return this.stride;
    }

    @Override
    public double getCoordValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range for this axis");
        }
        return this.start + (double)index * this.stride;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Regular1DCoordAxis)) {
            return false;
        }
        Regular1DCoordAxis otherAxis = (Regular1DCoordAxis)obj;
        return this.start == otherAxis.start && this.stride == otherAxis.stride && this.size == otherAxis.size && this.getAxisType() == otherAxis.getAxisType();
    }
}

