/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import uk.ac.rdg.resc.ncwms.coords.HorizontalCoordSys;
import uk.ac.rdg.resc.ncwms.coords.LonLatPosition;
import uk.ac.rdg.resc.ncwms.coords.LonLatPositionImpl;
import uk.ac.rdg.resc.ncwms.coords.OneDCoordAxis;

public class OneDCoordSys
extends HorizontalCoordSys {
    private final OneDCoordAxis xAxis;
    private final OneDCoordAxis yAxis;
    private final ProjectionImpl proj;

    OneDCoordSys(OneDCoordAxis xAxis, OneDCoordAxis yAxis, ProjectionImpl proj) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.proj = proj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int[] lonLatToGrid(LonLatPosition lonLatPoint) {
        ProjectionPointImpl point;
        if (this.proj == null) {
            return new int[]{this.getXIndex(lonLatPoint.getLongitude()), this.getYIndex(lonLatPoint.getLatitude())};
        }
        ProjectionImpl projectionImpl = this.proj;
        synchronized (projectionImpl) {
            point = this.proj.latLonToProj(lonLatPoint.getLatitude(), lonLatPoint.getLongitude());
        }
        int iIndex = this.xAxis.getIndex(point.getX());
        int jIndex = this.yAxis.getIndex(point.getY());
        if (iIndex < 0 || jIndex < 0) {
            return null;
        }
        return new int[]{iIndex, jIndex};
    }

    @Override
    public final LonLatPosition gridToLonLat(int i, int j) {
        if (i < 0 || i >= this.xAxis.getSize() || j < 0 || j >= this.yAxis.getSize()) {
            return null;
        }
        if (this.proj == null) {
            return new LonLatPositionImpl(this.xAxis.getCoordValue(i), this.yAxis.getCoordValue(j));
        }
        LatLonPointImpl llp = this.proj.projToLatLon(this.xAxis.getCoordValue(i), this.yAxis.getCoordValue(j));
        return new LonLatPositionImpl(llp.getLongitude(), llp.getLatitude());
    }

    public final int getXIndex(double xCoord) {
        return this.xAxis.getIndex(xCoord);
    }

    public final int getYIndex(double yCoord) {
        return this.yAxis.getIndex(yCoord);
    }
}

