/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.coords;

public class Longitude {
    private double value;
    public static final boolean ROUND_UP = true;
    public static final boolean ROUND_DOWN = false;

    public Longitude(double value) {
        this.value = Longitude.constrain360(value);
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    public double getClockwiseDistanceTo(Longitude endpoint) {
        double distance = endpoint.getValue() - this.getValue();
        if (distance < 0.0) {
            distance += 360.0;
        }
        return distance;
    }

    public double getClockwiseDistanceTo(double endpoint) {
        return this.getClockwiseDistanceTo(new Longitude(endpoint));
    }

    public boolean isBetween(double v1, double v2) {
        Longitude lon1 = new Longitude(v1);
        Longitude lon2 = new Longitude(v2);
        return lon1.getClockwiseDistanceTo(this) <= lon1.getClockwiseDistanceTo(lon2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Longitude) {
            return this.equals((Longitude)obj);
        }
        return false;
    }

    public boolean equals(Longitude other) {
        double distance = this.getClockwiseDistanceTo(other);
        distance = Longitude.constrain180(distance);
        if (this.getValue() < 1.0E-6) {
            return Math.abs(distance) < 1.0E-6;
        }
        double fracDiff = distance / this.getValue();
        return Math.abs(fracDiff) < 1.0E-6;
    }

    public boolean equals(double other) {
        return this.equals(new Longitude(other));
    }

    public static double constrain360(double input) {
        double temp = input % 360.0;
        return input >= 0.0 ? temp : temp + 360.0;
    }

    public static double constrain180(double input) {
        double val360 = Longitude.constrain360(input);
        return val360 <= 180.0 ? val360 : val360 - 360.0;
    }

    public static void main(String[] args) {
        Longitude long1 = new Longitude(245.67);
        Longitude long2 = new Longitude(389.02);
        Longitude long3 = new Longitude(578.32);
        Longitude long4 = new Longitude(-156.23);
        Longitude long5 = new Longitude(-1050.0);
        Longitude long6 = new Longitude(29.02);
        Longitude long7 = new Longitude(0.0);
        System.out.println("Long1 (should be 245.67): " + long1);
        System.out.println("Long2 (should be 29.02): " + long2);
        System.out.println("Long3 (should be 218.32): " + long3);
        System.out.println("Long4 (should be 203.77): " + long4);
        System.out.println("Long5 (should be 30.00): " + long5);
        System.out.println("");
        System.out.println("Distance from 245.67 to 29.02 (should be 143.35): " + long1.getClockwiseDistanceTo(long2));
        System.out.println("Distance from 29.02 to 245.67 (should be 216.65): " + long2.getClockwiseDistanceTo(long1));
        System.out.println("Test of equality (29.02 = 389.02?): " + long2.equals(long6));
        System.out.println("Test of equality (0 = 360?): " + long7.equals(360.0));
        System.out.println("Test of equality (0 = 359?): " + long7.equals(359.98999));
    }
}

