/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import uk.ac.rdg.resc.ncwms.controller.GetFeatureInfoDataRequest;
import uk.ac.rdg.resc.ncwms.controller.GetFeatureInfoRequest;
import uk.ac.rdg.resc.ncwms.controller.GetMapDataRequest;
import uk.ac.rdg.resc.ncwms.controller.GetMapRequest;
import uk.ac.rdg.resc.ncwms.controller.GetMapStyleRequest;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.controller.ServerConfig;
import uk.ac.rdg.resc.ncwms.controller.WmsVersion;
import uk.ac.rdg.resc.ncwms.coords.CrsHelper;
import uk.ac.rdg.resc.ncwms.coords.HorizontalGrid;
import uk.ac.rdg.resc.ncwms.coords.HorizontalPosition;
import uk.ac.rdg.resc.ncwms.coords.LineString;
import uk.ac.rdg.resc.ncwms.coords.LonLatPosition;
import uk.ac.rdg.resc.ncwms.coords.PixelMap;
import uk.ac.rdg.resc.ncwms.coords.PointList;
import uk.ac.rdg.resc.ncwms.exceptions.CurrentUpdateSequence;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidDimensionValueException;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidFormatException;
import uk.ac.rdg.resc.ncwms.exceptions.InvalidUpdateSequence;
import uk.ac.rdg.resc.ncwms.exceptions.LayerNotDefinedException;
import uk.ac.rdg.resc.ncwms.exceptions.Wms1_1_1Exception;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.graphics.ColorPalette;
import uk.ac.rdg.resc.ncwms.graphics.ImageFormat;
import uk.ac.rdg.resc.ncwms.graphics.ImageProducer;
import uk.ac.rdg.resc.ncwms.graphics.KmzFormat;
import uk.ac.rdg.resc.ncwms.usagelog.UsageLogEntry;
import uk.ac.rdg.resc.ncwms.usagelog.UsageLogger;
import uk.ac.rdg.resc.ncwms.util.Range;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.Dataset;
import uk.ac.rdg.resc.ncwms.wms.Layer;
import uk.ac.rdg.resc.ncwms.wms.ScalarLayer;
import uk.ac.rdg.resc.ncwms.wms.VectorLayer;

public abstract class AbstractWmsController
extends AbstractController {
    private static final Logger log = LoggerFactory.getLogger(AbstractWmsController.class);
    private static final int LAYER_LIMIT = 1;
    private static final String FEATURE_INFO_XML_FORMAT = "text/xml";
    private static final String FEATURE_INFO_PNG_FORMAT = "image/png";
    protected ServerConfig serverConfig;
    protected UsageLogger usageLogger;

    public void init() throws Exception {
        File paletteLocationDir = this.serverConfig.getPaletteFilesLocation(this.getServletContext());
        if (paletteLocationDir != null && paletteLocationDir.exists() && paletteLocationDir.isDirectory()) {
            ColorPalette.loadPalettes(paletteLocationDir);
        } else {
            log.info("Directory of palette files does not exist or is not a directory");
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        UsageLogEntry usageLogEntry = new UsageLogEntry(httpServletRequest);
        boolean logUsage = true;
        RequestParams params = new RequestParams(httpServletRequest.getParameterMap());
        try {
            String request = params.getMandatoryString("request");
            usageLogEntry.setWmsOperation(request);
            ModelAndView modelAndView = this.dispatchWmsRequest(request, params, httpServletRequest, httpServletResponse, usageLogEntry);
            return modelAndView;
        }
        catch (WmsException wmse) {
            usageLogEntry.setException(wmse);
            String wmsVersion = params.getWmsVersion();
            if (wmsVersion != null && wmsVersion.equals("1.1.1")) {
                throw new Wms1_1_1Exception(wmse);
            }
            throw wmse;
        }
        catch (SocketException se) {
            ModelAndView modelAndView = null;
            return modelAndView;
        }
        catch (IOException ioe) {
            if (ioe.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            throw ioe;
        }
        catch (Exception e) {
            usageLogEntry.setException(e);
            throw e;
        }
        finally {
            if (logUsage && this.usageLogger != null) {
                this.usageLogger.logUsage(usageLogEntry);
            }
        }
    }

    protected abstract ModelAndView dispatchWmsRequest(String var1, RequestParams var2, HttpServletRequest var3, HttpServletResponse var4, UsageLogEntry var5) throws Exception;

    protected ModelAndView getCapabilities(Collection<? extends Dataset> datasets, DateTime lastUpdateTime, RequestParams params, HttpServletRequest httpServletRequest, UsageLogEntry usageLogEntry) throws WmsException, IOException {
        WmsVersion wmsVersion;
        String service = params.getMandatoryString("service");
        if (!service.equals("WMS")) {
            throw new WmsException("The value of the SERVICE parameter must be \"WMS\"");
        }
        String versionStr = params.getWmsVersion();
        usageLogEntry.setWmsVersion(versionStr);
        String format = params.getString("format");
        usageLogEntry.setOutputFormat(format);
        String updateSeqStr = params.getString("updatesequence");
        if (updateSeqStr != null) {
            DateTime updateSequence;
            try {
                updateSequence = WmsUtils.iso8601ToDateTime(updateSeqStr, (Chronology)ISOChronology.getInstanceUTC());
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidUpdateSequence(updateSeqStr + " is not a valid ISO date-time");
            }
            if (updateSequence.isEqual((ReadableInstant)lastUpdateTime)) {
                throw new CurrentUpdateSequence(updateSeqStr);
            }
            if (updateSequence.isAfter((ReadableInstant)lastUpdateTime)) {
                throw new InvalidUpdateSequence(updateSeqStr + " is later than the current server updatesequence value");
            }
        }
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("config", this.serverConfig);
        models.put("datasets", datasets);
        models.put("lastUpdate", lastUpdateTime == null ? new DateTime() : lastUpdateTime);
        models.put("wmsBaseUrl", httpServletRequest.getRequestURL().toString());
        String[] supportedCrsCodes = new String[]{"EPSG:4326", "CRS:84", "EPSG:41001", "EPSG:3857", "EPSG:27700", "EPSG:3408", "EPSG:3409", "EPSG:32661", "EPSG:32761"};
        models.put("supportedCrsCodes", supportedCrsCodes);
        models.put("supportedImageFormats", ImageFormat.getSupportedMimeTypes());
        models.put("layerLimit", 1);
        models.put("featureInfoFormats", new String[]{FEATURE_INFO_PNG_FORMAT, FEATURE_INFO_XML_FORMAT});
        models.put("legendWidth", 110);
        models.put("legendHeight", 264);
        models.put("paletteNames", ColorPalette.getAvailablePaletteNames());
        WmsVersion wmsVersion2 = wmsVersion = versionStr == null ? WmsVersion.VERSION_1_3_0 : new WmsVersion(versionStr);
        if (wmsVersion.compareTo(WmsVersion.VERSION_1_3_0) >= 0) {
            return new ModelAndView("capabilities_xml", models);
        }
        return new ModelAndView("capabilities_xml_1_1_1", models);
    }

    protected ModelAndView getMap(RequestParams params, LayerFactory layerFactory, HttpServletResponse httpServletResponse, UsageLogEntry usageLogEntry) throws WmsException, Exception {
        GetMapRequest getMapRequest = new GetMapRequest(params);
        usageLogEntry.setGetMapRequest(getMapRequest);
        GetMapStyleRequest styleRequest = getMapRequest.getStyleRequest();
        String mimeType = getMapRequest.getStyleRequest().getImageFormat();
        ImageFormat imageFormat = ImageFormat.get(mimeType);
        GetMapDataRequest dr = getMapRequest.getDataRequest();
        if (dr.getHeight() > this.serverConfig.getMaxImageHeight() || dr.getWidth() > this.serverConfig.getMaxImageWidth()) {
            throw new WmsException("Requested image size exceeds the maximum of " + this.serverConfig.getMaxImageWidth() + "x" + this.serverConfig.getMaxImageHeight());
        }
        String layerName = AbstractWmsController.getLayerName(dr);
        Layer layer = layerFactory.getLayer(layerName);
        usageLogEntry.setLayer(layer);
        HorizontalGrid grid = new HorizontalGrid(dr.getCrsCode(), dr.getWidth(), dr.getHeight(), dr.getBbox());
        String[] styles = styleRequest.getStyles();
        ImageProducer imageProducer = new ImageProducer.Builder().layer(layer).width(dr.getWidth()).height(dr.getHeight()).style(styles.length == 0 ? null : styles[0]).colourScaleRange(styleRequest.getColorScaleRange()).backgroundColour(styleRequest.getBackgroundColour()).transparent(styleRequest.isTransparent()).logarithmic(styleRequest.isScaleLogarithmic()).opacity(styleRequest.getOpacity()).numColourBands(styleRequest.getNumColourBands()).build();
        if (imageProducer.isTransparent() && !imageFormat.supportsFullyTransparentPixels()) {
            throw new WmsException("The image format " + mimeType + " does not support fully-transparent pixels");
        }
        if (imageProducer.getOpacity() < 100 && !imageFormat.supportsPartiallyTransparentPixels()) {
            throw new WmsException("The image format " + mimeType + " does not support partially-transparent pixels");
        }
        double zValue = AbstractWmsController.getElevationValue(dr.getElevationString(), layer);
        ArrayList<String> tValueStrings = new ArrayList<String>();
        List<DateTime> timeValues = AbstractWmsController.getTimeValues(dr.getTimeString(), layer);
        if (timeValues.size() > 1 && !imageFormat.supportsMultipleFrames()) {
            throw new WmsException("The image format " + mimeType + " does not support multiple frames");
        }
        usageLogEntry.setNumTimeSteps(timeValues.size());
        long beforeExtractData = System.currentTimeMillis();
        for (DateTime timeValue : timeValues) {
            ArrayList<List<Float>> picData = new ArrayList<List<Float>>(2);
            if (layer instanceof ScalarLayer) {
                picData.add(this.readDataGrid((ScalarLayer)layer, timeValue, zValue, grid, usageLogEntry));
            } else if (layer instanceof VectorLayer) {
                VectorLayer vecLayer = (VectorLayer)layer;
                picData.add(this.readDataGrid(vecLayer.getEastwardComponent(), timeValue, zValue, grid, usageLogEntry));
                picData.add(this.readDataGrid(vecLayer.getNorthwardComponent(), timeValue, zValue, grid, usageLogEntry));
            } else {
                throw new IllegalStateException("Unrecognized layer type");
            }
            String tValueStr = "";
            if (timeValues.size() > 1 && timeValue != null) {
                tValueStr = WmsUtils.dateTimeToISO8601(timeValue);
            }
            tValueStrings.add(tValueStr);
            imageProducer.addFrame(picData, tValueStr);
        }
        long timeToExtractData = System.currentTimeMillis() - beforeExtractData;
        usageLogEntry.setTimeToExtractDataMs(timeToExtractData);
        BufferedImage legend = imageFormat.requiresLegend() ? imageProducer.getLegend() : null;
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(mimeType);
        if (imageFormat instanceof KmzFormat) {
            httpServletResponse.setHeader("Content-Disposition", "inline; filename=" + layer.getDataset().getId() + "_" + layer.getId() + ".kmz");
        }
        imageFormat.writeImage(imageProducer.getRenderedFrames(), (OutputStream)httpServletResponse.getOutputStream(), layer, tValueStrings, dr.getElevationString(), grid.getBbox(), legend);
        return null;
    }

    private static String getLayerName(GetMapDataRequest getMapDataRequest) throws WmsException {
        String[] layers = getMapDataRequest.getLayers();
        if (layers.length == 0) {
            throw new WmsException("Must provide a value for the LAYERS parameter");
        }
        if (layers.length > 1) {
            throw new WmsException("You may only create a map from 1 layer(s) at a time");
        }
        return layers[0];
    }

    protected ModelAndView getFeatureInfo(RequestParams params, LayerFactory layerFactory, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, UsageLogEntry usageLogEntry) throws WmsException, Exception {
        List<Float> tsData;
        GetFeatureInfoRequest request = new GetFeatureInfoRequest(params);
        usageLogEntry.setGetFeatureInfoRequest(request);
        GetFeatureInfoDataRequest dr = request.getDataRequest();
        if (dr.getFeatureCount() != 1) {
            throw new WmsException("Can only provide feature info for one layer at a time");
        }
        if (!request.getOutputFormat().equals(FEATURE_INFO_XML_FORMAT) && !request.getOutputFormat().equals(FEATURE_INFO_PNG_FORMAT)) {
            throw new InvalidFormatException("The output format " + request.getOutputFormat() + " is not valid for GetFeatureInfo");
        }
        String layerName = AbstractWmsController.getLayerName(dr);
        Layer layer = layerFactory.getLayer(layerName);
        usageLogEntry.setLayer(layer);
        HorizontalGrid grid = new HorizontalGrid(dr.getCrsCode(), dr.getWidth(), dr.getHeight(), dr.getBbox());
        double x = grid.getXAxisValues()[dr.getPixelColumn()];
        double y = grid.getYAxisValues()[dr.getPixelRow()];
        LonLatPosition lonLat = grid.getCrsHelper().crsToLonLat(x, y);
        usageLogEntry.setFeatureInfoLocation(lonLat.getLongitude(), lonLat.getLatitude());
        int[] gridCoords = layer.getHorizontalCoordSys().lonLatToGrid(lonLat);
        LonLatPosition gridCellCentre = layer.getHorizontalCoordSys().gridToLonLat(gridCoords);
        double zValue = AbstractWmsController.getElevationValue(dr.getElevationString(), layer);
        List<DateTime> tValues = AbstractWmsController.getTimeValues(dr.getTimeString(), layer);
        usageLogEntry.setNumTimeSteps(tValues.size());
        if (layer instanceof ScalarLayer) {
            tsData = ((ScalarLayer)layer).readTimeseries(tValues, zValue, lonLat);
        } else if (layer instanceof VectorLayer) {
            VectorLayer vecLayer = (VectorLayer)layer;
            List<Float> tsDataEast = vecLayer.getEastwardComponent().readTimeseries(tValues, zValue, lonLat);
            List<Float> tsDataNorth = vecLayer.getNorthwardComponent().readTimeseries(tValues, zValue, lonLat);
            tsData = WmsUtils.getMagnitudes(tsDataEast, tsDataNorth);
        } else {
            throw new IllegalStateException("Unrecognized layer type");
        }
        if (tValues.size() != tsData.size()) {
            throw new IllegalStateException("Internal error: timeseries length inconsistency");
        }
        TreeMap<DateTime, Float> featureData = new TreeMap<DateTime, Float>();
        for (int i = 0; i < tValues.size(); ++i) {
            featureData.put(tValues.get(i), tsData.get(i));
        }
        if (request.getOutputFormat().equals(FEATURE_INFO_XML_FORMAT)) {
            HashMap<String, Object> models = new HashMap<String, Object>();
            models.put("longitude", lonLat.getLongitude());
            models.put("latitude", lonLat.getLatitude());
            models.put("gridCoords", gridCoords);
            models.put("gridCentre", gridCellCentre);
            models.put("data", featureData);
            return new ModelAndView("showFeatureInfo_xml", models);
        }
        TimeSeries ts = new TimeSeries((Comparable)((Object)"Data"), Millisecond.class);
        for (DateTime dateTime : featureData.keySet()) {
            ts.add((RegularTimePeriod)new Millisecond(dateTime.toDate()), (Number)featureData.get(dateTime));
        }
        TimeSeriesCollection xydataset = new TimeSeriesCollection();
        xydataset.addSeries(ts);
        String title = "Lon: " + lonLat.getLongitude() + ", Lat: " + lonLat.getLatitude();
        String yLabel = layer.getTitle() + " (" + layer.getUnits() + ")";
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Date / time", (String)yLabel, (XYDataset)xydataset, (boolean)false, (boolean)false, (boolean)false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0));
        renderer.setSeriesShapesVisible(0, true);
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        chart.getXYPlot().setNoDataMessage("There is no data for your choice");
        chart.getXYPlot().setNoDataMessageFont(new Font("sansserif", 1, 32));
        httpServletResponse.setContentType(FEATURE_INFO_PNG_FORMAT);
        ChartUtilities.writeChartAsPNG((OutputStream)httpServletResponse.getOutputStream(), (JFreeChart)chart, (int)400, (int)300);
        return null;
    }

    protected ModelAndView getLegendGraphic(RequestParams params, LayerFactory layerFactory, HttpServletResponse httpServletResponse) throws Exception {
        BufferedImage legend;
        int numColourBands = GetMapStyleRequest.getNumColourBands(params);
        String paletteName = params.getString("palette");
        String colorBarOnly = params.getString("colorbaronly", "false");
        if (colorBarOnly.equalsIgnoreCase("true")) {
            int width = params.getPositiveInt("width", 50);
            int height = params.getPositiveInt("height", 200);
            ColorPalette palette = ColorPalette.get(paletteName);
            legend = palette.createColorBar(width, height, numColourBands);
        } else {
            String layerName = params.getMandatoryString("layer");
            Layer layer = layerFactory.getLayer(layerName);
            ColorPalette palette = paletteName == null ? layer.getDefaultColorPalette() : ColorPalette.get(paletteName);
            Boolean isLogScale = GetMapStyleRequest.isLogScale(params);
            boolean logarithmic = isLogScale == null ? layer.isLogScaling() : isLogScale.booleanValue();
            Range<Float> colorScaleRange = GetMapStyleRequest.getColorScaleRange(params);
            if (colorScaleRange == null) {
                colorScaleRange = layer.getApproxValueRange();
            } else if (colorScaleRange.isEmpty()) {
                throw new WmsException("Cannot automatically create a colour scale for a legend graphic.  Use COLORSCALERANGE=default or specify the scale extremes explicitly.");
            }
            legend = palette.createLegend(numColourBands, layer, logarithmic, colorScaleRange);
        }
        httpServletResponse.setContentType(FEATURE_INFO_PNG_FORMAT);
        ImageIO.write((RenderedImage)legend, "png", (OutputStream)httpServletResponse.getOutputStream());
        return null;
    }

    protected ModelAndView getTransect(RequestParams params, LayerFactory layerFactory, HttpServletResponse response, UsageLogEntry usageLogEntry) throws Exception {
        List<Float> transectData;
        String layerStr = params.getMandatoryString("layer");
        Layer layer = layerFactory.getLayer(layerStr);
        String crsCode = params.getMandatoryString("crs");
        String lineString = params.getMandatoryString("linestring");
        String outputFormat = params.getMandatoryString("format");
        DateTime tValue = AbstractWmsController.getTimeValues(params.getString("time"), layer).get(0);
        double zValue = AbstractWmsController.getElevationValue(params.getString("elevation"), layer);
        if (!outputFormat.equals(FEATURE_INFO_PNG_FORMAT) && !outputFormat.equals(FEATURE_INFO_XML_FORMAT)) {
            throw new InvalidFormatException(outputFormat);
        }
        usageLogEntry.setLayer(layer);
        usageLogEntry.setOutputFormat(outputFormat);
        CrsHelper crsHelper = CrsHelper.fromCrsCode(crsCode);
        LineString transect = new LineString(lineString, crsHelper);
        log.debug("Got {} control points", (Object)transect.getControlPoints().size());
        PointList pointList = AbstractWmsController.getOptimalTransectPointList(layer, transect);
        log.debug("Using transect consisting of {} points", (Object)pointList.size());
        if (layer instanceof ScalarLayer) {
            transectData = ((ScalarLayer)layer).readPointList(tValue, zValue, pointList);
        } else if (layer instanceof VectorLayer) {
            VectorLayer vecLayer = (VectorLayer)layer;
            List<Float> tsDataEast = vecLayer.getEastwardComponent().readPointList(tValue, zValue, pointList);
            List<Float> tsDataNorth = vecLayer.getNorthwardComponent().readPointList(tValue, zValue, pointList);
            transectData = WmsUtils.getMagnitudes(tsDataEast, tsDataNorth);
        } else {
            throw new IllegalStateException("Unrecognized layer type");
        }
        log.debug("Transect: Got {} dataValues", (Object)transectData.size());
        response.setContentType(outputFormat);
        if (outputFormat.equals(FEATURE_INFO_PNG_FORMAT)) {
            XYSeries series = new XYSeries((Comparable)((Object)"data"), true);
            for (int i = 0; i < transectData.size(); ++i) {
                series.add((double)i, (Number)transectData.get(i));
            }
            XYSeriesCollection xySeriesColl = new XYSeriesCollection();
            xySeriesColl.addSeries(series);
            JFreeChart chart = ChartFactory.createXYLineChart((String)("Transect for " + layer.getTitle()), (String)"distance along transect (arbitrary units)", (String)(layer.getTitle() + " (" + layer.getUnits() + ")"), (XYDataset)xySeriesColl, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            XYPlot plot = chart.getXYPlot();
            plot.getRenderer().setSeriesPaint(0, (Paint)Color.RED);
            if (layer.getDataset().getCopyrightStatement() != null) {
                TextTitle textTitle = new TextTitle(layer.getDataset().getCopyrightStatement());
                textTitle.setFont(new Font("SansSerif", 0, 10));
                textTitle.setPosition(RectangleEdge.BOTTOM);
                textTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                chart.addSubtitle((Title)textTitle);
            }
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setAutoRangeIncludesZero(false);
            plot.setNoDataMessage("There is no data for what you have chosen.");
            Double prevCtrlPointDistance = null;
            for (int i = 0; i < transect.getControlPoints().size(); ++i) {
                double ctrlPointDistance = transect.getFractionalControlPointDistance(i);
                if (prevCtrlPointDistance != null) {
                    log.debug("ctrl point [" + i + "].");
                    log.debug("prevCtrlPointDistance " + prevCtrlPointDistance);
                    log.debug("ctrlPointDistance " + ctrlPointDistance);
                    IntervalMarker target = new IntervalMarker((double)transectData.size() * prevCtrlPointDistance, (double)transectData.size() * ctrlPointDistance);
                    target.setLabel("[" + AbstractWmsController.printTwoDecimals(transect.getControlPoints().get(i - 1).getY()) + "," + AbstractWmsController.printTwoDecimals(transect.getControlPoints().get(i - 1).getX()) + "]");
                    target.setLabelFont(new Font("SansSerif", 2, 11));
                    if (i % 2 == 0) {
                        target.setPaint((Paint)new Color(222, 222, 255, 128));
                        target.setLabelAnchor(RectangleAnchor.TOP_LEFT);
                        target.setLabelTextAnchor(TextAnchor.TOP_LEFT);
                    } else {
                        target.setPaint((Paint)new Color(233, 225, 146, 128));
                        target.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
                        target.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
                    }
                    plot.addDomainMarker((Marker)target);
                }
                prevCtrlPointDistance = transect.getFractionalControlPointDistance(i);
            }
            ChartUtilities.writeChartAsPNG((OutputStream)response.getOutputStream(), (JFreeChart)chart, (int)400, (int)300);
        } else if (outputFormat.equals(FEATURE_INFO_XML_FORMAT)) {
            LinkedHashMap<HorizontalPosition, Float> dataPoints = new LinkedHashMap<HorizontalPosition, Float>();
            List<HorizontalPosition> points = pointList.asList();
            for (int i = 0; i < points.size(); ++i) {
                dataPoints.put(points.get(i), transectData.get(i));
            }
            HashMap<String, Object> models = new HashMap<String, Object>();
            models.put("crs", crsCode);
            models.put("layer", layer);
            models.put("linestring", lineString);
            models.put("data", dataPoints);
            return new ModelAndView("showTransect_xml", models);
        }
        return null;
    }

    private static String printTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        DecimalFormatSymbols decSym = DecimalFormatSymbols.getInstance(new Locale("us", "US"));
        twoDForm.setDecimalFormatSymbols(decSym);
        return twoDForm.format(d);
    }

    private static PointList getOptimalTransectPointList(Layer layer, LineString transect) throws Exception {
        int numTransectPoints = 500;
        int lastNumGridPointsSampled = -1;
        PointList pointList = null;
        while (true) {
            List<HorizontalPosition> points = transect.getPointsOnPath(numTransectPoints);
            PointList testPointList = PointList.fromList(points, transect.getCrsHelper());
            int numGridPointsSampled = new PixelMap(layer.getHorizontalCoordSys(), testPointList).getNumUniqueIJPairs();
            log.debug("With {} transect points, we'll sample {} grid points", (Object)numTransectPoints, (Object)numGridPointsSampled);
            if (!((double)numGridPointsSampled > (double)lastNumGridPointsSampled * 1.1)) break;
            lastNumGridPointsSampled = numGridPointsSampled;
            numTransectPoints += 500;
            pointList = testPointList;
        }
        return pointList;
    }

    public static double getElevationValue(String zValue, Layer layer) throws InvalidDimensionValueException {
        if (layer.getElevationValues().isEmpty()) {
            return Double.NaN;
        }
        if (zValue == null) {
            double defaultVal = layer.getDefaultElevationValue();
            if (Double.isNaN(defaultVal)) {
                throw new InvalidDimensionValueException("elevation", "null");
            }
            return defaultVal;
        }
        if (zValue.contains(",") || zValue.contains("/")) {
            throw new InvalidDimensionValueException("elevation", zValue);
        }
        try {
            return Double.parseDouble(zValue);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidDimensionValueException("elevation", zValue);
        }
    }

    public static List<DateTime> getTimeValues(String timeString, Layer layer) throws InvalidDimensionValueException {
        if (layer.getTimeValues().isEmpty()) {
            return Arrays.asList(new DateTime[]{null});
        }
        if (timeString == null) {
            DateTime defaultDateTime = layer.getDefaultTimeValue();
            if (defaultDateTime == null) {
                throw new InvalidDimensionValueException("time", timeString);
            }
            return Arrays.asList(defaultDateTime);
        }
        ArrayList<DateTime> tValues = new ArrayList<DateTime>();
        for (String t : timeString.split(",")) {
            String[] startStop = t.split("/");
            if (startStop.length == 1) {
                tValues.add(AbstractWmsController.findTValue(startStop[0], layer));
                continue;
            }
            if (startStop.length == 2) {
                tValues.addAll(AbstractWmsController.findTValues(startStop[0], startStop[1], layer));
                continue;
            }
            throw new InvalidDimensionValueException("time", t);
        }
        return tValues;
    }

    public static int findTIndex(String isoDateTime, Layer layer) throws InvalidDimensionValueException {
        DateTime target;
        if (isoDateTime.equals("current")) {
            target = layer.getCurrentTimeValue();
        } else {
            try {
                target = WmsUtils.iso8601ToDateTime(isoDateTime, layer.getChronology());
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidDimensionValueException("time", isoDateTime);
            }
        }
        int index = WmsUtils.findTimeIndex(layer.getTimeValues(), target);
        if (index < 0) {
            throw new InvalidDimensionValueException("time", isoDateTime);
        }
        return index;
    }

    private static DateTime findTValue(String isoDateTime, Layer layer) throws InvalidDimensionValueException {
        return layer.getTimeValues().get(AbstractWmsController.findTIndex(isoDateTime, layer));
    }

    private static List<DateTime> findTValues(String isoDateTimeStart, String isoDateTimeEnd, Layer layer) throws InvalidDimensionValueException {
        int endIndex;
        int startIndex = AbstractWmsController.findTIndex(isoDateTimeStart, layer);
        if (startIndex > (endIndex = AbstractWmsController.findTIndex(isoDateTimeEnd, layer))) {
            throw new InvalidDimensionValueException("time", isoDateTimeStart + "/" + isoDateTimeEnd);
        }
        List<DateTime> layerTValues = layer.getTimeValues();
        ArrayList<DateTime> tValues = new ArrayList<DateTime>();
        for (int i = startIndex; i <= endIndex; ++i) {
            tValues.add(layerTValues.get(i));
        }
        return tValues;
    }

    protected List<Float> readDataGrid(ScalarLayer layer, DateTime dateTime, double elevation, HorizontalGrid grid, UsageLogEntry usageLogEntry) throws InvalidDimensionValueException, IOException {
        return layer.readPointList(dateTime, elevation, grid);
    }

    public void shutdown() {
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setUsageLogger(UsageLogger usageLogger) {
        this.usageLogger = usageLogger;
    }

    public static interface LayerFactory {
        public Layer getLayer(String var1) throws LayerNotDefinedException;
    }
}

