/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.integration;

public abstract class SimpsonIntegral {
    public static final int SIMPSON = 0;
    public static final int TRAPEZOIDAL = 0;
    protected double strapezoid = 0.0;
    protected double lowerlimit = 0.0;
    protected double upperlimit = 0.0;
    protected int maxsteps = 0;
    protected double accuracy = 0.0;

    protected double simpson() {
        double s = 0.0;
        double st = 0.0;
        double ost = 0.0;
        double os = 0.0;
        for (int i = 1; i < this.maxsteps; ++i) {
            st = this.trapezoid(i);
            s = (4.0 * st - ost) / 3.0;
            if (i > 5 && (Math.abs(s - os) < this.accuracy * Math.abs(os) || s == 0.0 && os == 0.0)) {
                return s;
            }
            os = s;
            ost = st;
        }
        return 0.0;
    }

    protected double trapezoid(int n) {
        double x = 0.0;
        double tnm = 0.0;
        double sum = 0.0;
        double del = 0.0;
        int it = 0;
        int j = 0;
        if (n == 1) {
            this.strapezoid = 0.5 * (this.upperlimit - this.lowerlimit) * (this.equation(this.lowerlimit) + this.equation(this.upperlimit));
        } else {
            it = (int)Math.pow(2.0, n - 1);
            tnm = it;
            del = (this.upperlimit - this.lowerlimit) / tnm;
            x = this.lowerlimit + 0.5 * del;
            sum = 0.0;
            j = 1;
            while (j <= it) {
                if (x >= this.upperlimit) {
                    System.out.println("hoi");
                }
                sum += this.equation(x);
                ++j;
                x += del;
            }
            this.strapezoid = 0.5 * (this.strapezoid + (this.upperlimit - this.lowerlimit) * sum / tnm);
        }
        return this.strapezoid;
    }

    protected abstract double equation(double var1);
}

