/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.clustering;

import java.util.Arrays;
import org.jgrasstools.gears.utils.clustering.GvmSpace;

public class GvmVectorSpace
extends GvmSpace {
    private final int dimensions;

    private static double[] coords(Object obj) {
        return (double[])obj;
    }

    public GvmVectorSpace(int dimensions) {
        if (dimensions < 1) {
            throw new IllegalArgumentException("non-positive dimensions");
        }
        this.dimensions = dimensions;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public double[] newOrigin() {
        return new double[this.dimensions];
    }

    public double[] newCopy(Object pt) {
        return (double[])GvmVectorSpace.coords(pt).clone();
    }

    @Override
    public double magnitudeSqr(Object pt) {
        double sum = 0.0;
        double[] coords = GvmVectorSpace.coords(pt);
        for (int i = 0; i < this.dimensions; ++i) {
            double c = coords[i];
            sum += c * c;
        }
        return sum;
    }

    @Override
    public double sum(Object pt) {
        double sum = 0.0;
        for (double coord : GvmVectorSpace.coords(pt)) {
            sum += coord;
        }
        return sum;
    }

    @Override
    public void setToOrigin(Object pt) {
        Arrays.fill(GvmVectorSpace.coords(pt), 0.0);
    }

    @Override
    public void setTo(Object dstPt, Object srcPt) {
        System.arraycopy(GvmVectorSpace.coords(srcPt), 0, GvmVectorSpace.coords(dstPt), 0, this.dimensions);
    }

    @Override
    public void setToScaled(Object dstPt, double m, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        for (int i = 0; i < this.dimensions; ++i) {
            dstCoords[i] = m * srcCoords[i];
        }
    }

    @Override
    public void setToScaledSqr(Object dstPt, double m, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        for (int i = 0; i < this.dimensions; ++i) {
            double c = srcCoords[i];
            dstCoords[i] = m * c * c;
        }
    }

    @Override
    public void add(Object dstPt, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            dstCoords[n] = dstCoords[n] + srcCoords[i];
        }
    }

    @Override
    public void addScaled(Object dstPt, double m, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            dstCoords[n] = dstCoords[n] + m * srcCoords[i];
        }
    }

    @Override
    public void addScaledSqr(Object dstPt, double m, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        int i = 0;
        while (i < this.dimensions) {
            double c = srcCoords[i];
            int n = i++;
            dstCoords[n] = dstCoords[n] + m * c * c;
        }
    }

    @Override
    public void subtract(Object dstPt, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            dstCoords[n] = dstCoords[n] - srcCoords[i];
        }
    }

    @Override
    public void subtractScaled(Object dstPt, double m, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            dstCoords[n] = dstCoords[n] - m * srcCoords[i];
        }
    }

    @Override
    public void subtractScaledSqr(Object dstPt, double m, Object srcPt) {
        double[] dstCoords = GvmVectorSpace.coords(dstPt);
        double[] srcCoords = GvmVectorSpace.coords(srcPt);
        int i = 0;
        while (i < this.dimensions) {
            double c = srcCoords[i];
            int n = i++;
            dstCoords[n] = dstCoords[n] - m * c * c;
        }
    }

    @Override
    public void scale(Object pt, double m) {
        double[] coords = GvmVectorSpace.coords(pt);
        int i = 0;
        while (i < this.dimensions) {
            int n = i++;
            coords[n] = coords[n] * m;
        }
    }

    @Override
    public void square(Object pt) {
        double[] coords = GvmVectorSpace.coords(pt);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            coords[n] = coords[n] * coords[i];
        }
    }

    @Override
    public double distance(Object pt1, Object pt2) {
        double[] coords1 = GvmVectorSpace.coords(pt1);
        double[] coords2 = GvmVectorSpace.coords(pt2);
        double sum = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double d = coords1[i] - coords2[i];
            sum += d * d;
        }
        return Math.sqrt(sum);
    }

    @Override
    public double variance(double m, Object pt, Object ptSqr) {
        double[] coords = GvmVectorSpace.coords(pt);
        double[] sqrCoords = GvmVectorSpace.coords(ptSqr);
        double sum = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double c = coords[i];
            sum += sqrCoords[i] - c * c / m;
        }
        return sum;
    }

    @Override
    public double variance(double m1, Object pt1, Object ptSqr1, double m2, Object pt2) {
        double[] coords1 = GvmVectorSpace.coords(pt1);
        double[] sqrCoords1 = GvmVectorSpace.coords(ptSqr1);
        double[] coords2 = GvmVectorSpace.coords(pt2);
        double m0 = m1 + m2;
        double sum = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double c2 = coords2[i];
            double c = coords1[i] + m2 * c2;
            double cSqr = sqrCoords1[i] + m2 * c2 * c2;
            sum += cSqr - c * c / m0;
        }
        return sum;
    }

    @Override
    public double variance(double m1, Object pt1, Object ptSqr1, double m2, Object pt2, Object ptSqr2) {
        double[] coords1 = GvmVectorSpace.coords(pt1);
        double[] sqrCoords1 = GvmVectorSpace.coords(ptSqr1);
        double[] coords2 = GvmVectorSpace.coords(pt2);
        double[] sqrCoords2 = GvmVectorSpace.coords(ptSqr2);
        double m0 = m1 + m2;
        double sum = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double c = coords1[i] + coords2[i];
            double cSqr = sqrCoords1[i] + sqrCoords2[i];
            sum += cSqr - c * c / m0;
        }
        return sum;
    }

    @Override
    public String toString(Object pt) {
        return Arrays.toString(GvmVectorSpace.coords(pt));
    }
}

