/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;

public class RegionMap
extends HashMap<String, Double> {
    private static final long serialVersionUID = 1L;

    public int getCols() {
        Double cols = (Double)this.get("COLS");
        if (cols != null) {
            return cols.intValue();
        }
        return -1;
    }

    public int getRows() {
        Double rows = (Double)this.get("ROWS");
        if (rows != null) {
            return rows.intValue();
        }
        return -1;
    }

    public double getNorth() {
        Double n = (Double)this.get("NORTH");
        if (n != null) {
            return n;
        }
        return Double.NaN;
    }

    public double getSouth() {
        Double s = (Double)this.get("SOUTH");
        if (s != null) {
            return s;
        }
        return Double.NaN;
    }

    public double getEast() {
        Double e = (Double)this.get("EAST");
        if (e != null) {
            return e;
        }
        return Double.NaN;
    }

    public double getWest() {
        Double w = (Double)this.get("WEST");
        if (w != null) {
            return w;
        }
        return Double.NaN;
    }

    public double getXres() {
        Double xres = (Double)this.get("XRES");
        if (xres != null) {
            return xres;
        }
        return Double.NaN;
    }

    public double getYres() {
        Double yres = (Double)this.get("YRES");
        if (yres != null) {
            return yres;
        }
        return Double.NaN;
    }

    public double getWidth() {
        return this.getEast() - this.getWest();
    }

    public double getHeight() {
        return this.getNorth() - this.getSouth();
    }

    public Coordinate snapToNextHigherInRegionResolution(double x, double y) {
        double minx = this.getWest();
        double ewres = this.getXres();
        double xsnap = minx + Math.ceil((x - minx) / ewres) * ewres;
        double miny = this.getSouth();
        double nsres = this.getYres();
        double ysnap = miny + Math.ceil((y - miny) / nsres) * nsres;
        return new Coordinate(xsnap, ysnap);
    }

    public Envelope toEnvelope() {
        Envelope env = new Envelope(this.getWest(), this.getEast(), this.getSouth(), this.getNorth());
        return env;
    }

    public RegionMap toSubRegion(double n, double s, double w, double e) {
        double originalXres = this.getXres();
        double originalYres = this.getYres();
        double originalWest = this.getWest();
        double originalSouth = this.getSouth();
        double envWest = w;
        double deltaX = (envWest - originalWest) % originalXres;
        double newWest = envWest - deltaX;
        double envSouth = s;
        double deltaY = (envSouth - originalSouth) % originalYres;
        double newSouth = envSouth - deltaY;
        double newWidth = e - w;
        double deltaW = newWidth % originalXres;
        newWidth = newWidth - deltaW + originalXres;
        double newHeight = n - s;
        double deltaH = newHeight % originalYres;
        newHeight = newHeight - deltaH + originalYres;
        double newNorth = newSouth + newHeight;
        double newEast = newWest + newWidth;
        int rows = (int)(newHeight / originalYres);
        int cols = (int)(newWidth / originalXres);
        double newXres = newWidth / (double)cols;
        double newYres = newHeight / (double)rows;
        RegionMap regionMap = CoverageUtilities.makeRegionParamsMap(newNorth, newSouth, newWest, newEast, newXres, newYres, cols, rows);
        return regionMap;
    }

    public RegionMap toSubRegion(Envelope envelope) {
        double w = envelope.getMinX();
        double s = envelope.getMinY();
        double e = envelope.getMaxX();
        double n = envelope.getMaxY();
        return this.toSubRegion(n, s, w, e);
    }

    public String toStringJGT() {
        StringBuilder sb = new StringBuilder();
        sb.append("North = ").append(this.getNorth()).append("\n");
        sb.append("South = ").append(this.getSouth()).append("\n");
        sb.append("East = ").append(this.getEast()).append("\n");
        sb.append("West = ").append(this.getWest()).append("\n");
        sb.append("Rows = ").append(this.getRows()).append("\n");
        sb.append("Cols = ").append(this.getCols()).append("\n");
        sb.append("Xres = ").append(this.getXres()).append("\n");
        sb.append("Yres = ").append(this.getYres());
        return sb.toString();
    }
}

