/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.summary;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import java.text.MessageFormat;
import java.util.List;
import javax.media.jai.iterator.RandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.jgrasstools.gears.libs.exceptions.ModelsIOException;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Calculate zonal stats.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="zonalstats")
@Label(value="Raster Processing")
@Name(value="zonalstats")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsZonalStats
extends JGTModel {
    @Description(value="The raster map to process.")
    @In
    public GridCoverage2D inRaster = null;
    @Description(value="The polygons map on which to do the stats.")
    @In
    public SimpleFeatureCollection inVector = null;
    @Description(value="Percentage of minimum active cells to have a valid stat.")
    @In
    public double pPercentageThres = 20.0;
    @Description(value="Total meanvalue (also produced by this module) for the calculation of the mean absolute deviation.")
    @In
    public Double pTotalMean = null;
    @Description(value="The input polygons with the added stats values.")
    @Out
    public SimpleFeatureCollection outVector;
    double[] tm_usertm_tactivecells = new double[3];
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String AVG = "avg";
    public static final String VAR = "var";
    public static final String SDEV = "sdev";
    public static final String AVGABSDEV = "avgabsdev";
    public static final String ACTCELLS = "actcells";
    public static final String INVCELLS = "invcells";

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inVector, this.inRaster);
        boolean hasUserTotalMean = false;
        if (this.pTotalMean != null) {
            hasUserTotalMean = true;
            this.tm_usertm_tactivecells[1] = this.pTotalMean;
        }
        ReferencedEnvelope bounds = this.inVector.getBounds();
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        SimpleFeatureBuilder featureBuilder = OmsZonalStats.createFeatureBuilder(crs, hasUserTotalMean);
        this.outVector = new DefaultFeatureCollection();
        List<Geometry> geometriesList = FeatureUtilities.featureCollectionToGeometriesList(this.inVector, true, null);
        GridGeometry2D gridGeometry = this.inRaster.getGridGeometry();
        RandomIter readIter = CoverageUtilities.getRandomIterator(this.inRaster);
        this.pm.beginTask("Processing polygons...", geometriesList.size());
        for (Geometry geometry : geometriesList) {
            double[] polygonStats = OmsZonalStats.polygonStats(geometry, gridGeometry, readIter, hasUserTotalMean, this.tm_usertm_tactivecells, this.pPercentageThres, this.pm);
            if (polygonStats == null) continue;
            Object[] values = !hasUserTotalMean ? new Object[]{geometry, polygonStats[0], polygonStats[1], polygonStats[2], polygonStats[3], polygonStats[4], (int)polygonStats[5], (int)polygonStats[6]} : new Object[]{geometry, polygonStats[0], polygonStats[1], polygonStats[2], polygonStats[3], polygonStats[4], polygonStats[5], (int)polygonStats[6], (int)polygonStats[7]};
            featureBuilder.addAll(values);
            SimpleFeature feature = featureBuilder.buildFeature(null);
            ((DefaultFeatureCollection)this.outVector).add(feature);
            this.pm.worked(1);
        }
        this.pm.done();
        if (!hasUserTotalMean) {
            this.tm_usertm_tactivecells[0] = this.tm_usertm_tactivecells[0] / this.tm_usertm_tactivecells[2];
            this.pm.message("Total mean: " + this.tm_usertm_tactivecells[0]);
        }
    }

    public static double[] polygonStats(Geometry geometry, GridGeometry2D gridGeometry, RandomIter inIter, boolean hasUserTotalMean, double[] tm_utm_tac, double percentageThres, IJGTProgressMonitor monitor) throws Exception {
        double[] result;
        GeometryFactory gf = GeometryUtilities.gf();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int rows = gridRange.height;
        int cols = gridRange.width;
        int startX = gridRange.x;
        int startY = gridRange.y;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        double delta = xRes / 4.0;
        Envelope env = geometry.getEnvelopeInternal();
        env.expandBy(xRes, yRes);
        double geometryUpperBound = env.getMaxY();
        double envArea = env.getWidth() * env.getHeight();
        int maxCells = (int)Math.ceil(envArea / (xRes * yRes));
        int activeCellCount = 0;
        int passiveCellCount = 0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        MathTransform gridToCRS2 = gridGeometry.getGridToCRS();
        double[] values = new double[maxCells];
        LineString previousLine = null;
        Coordinate worldWestCoord = new Coordinate();
        Coordinate worldEastCoord = new Coordinate();
        for (int r = startY; r < startY + rows; ++r) {
            Coordinate gridWestCoord = new Coordinate((double)startX, (double)r);
            JTS.transform((Coordinate)gridWestCoord, (Coordinate)worldWestCoord, (MathTransform)gridToCRS2);
            if (geometryUpperBound < worldWestCoord.y) continue;
            Coordinate gridEastCoord = new Coordinate((double)(startX + cols - 1), (double)r);
            JTS.transform((Coordinate)gridEastCoord, (Coordinate)worldEastCoord, (MathTransform)gridToCRS2);
            LineString line = gf.createLineString(new Coordinate[]{worldWestCoord, worldEastCoord});
            if (previousLine != null && previousLine.equals((Geometry)line)) {
                previousLine = line;
                continue;
            }
            if (geometry.intersects((Geometry)line)) {
                Geometry internalLines = geometry.intersection((Geometry)line);
                int lineNums = internalLines.getNumGeometries();
                for (int l = 0; l < lineNums; ++l) {
                    Coordinate[] coords = internalLines.getGeometryN(l).getCoordinates();
                    if (coords.length == 2) {
                        for (int j = 0; j < coords.length; j += 2) {
                            DirectPosition2D endDP;
                            DirectPosition2D startDP;
                            Coordinate startC = new Coordinate(coords[j].x + delta, coords[j].y);
                            Coordinate endC = new Coordinate(coords[j + 1].x - delta, coords[j + 1].y);
                            if (startC.x < endC.x) {
                                startDP = new DirectPosition2D(startC.x, startC.x);
                                endDP = new DirectPosition2D(endC.x, endC.x);
                            } else {
                                startDP = new DirectPosition2D(endC.x, endC.x);
                                endDP = new DirectPosition2D(startC.x, startC.x);
                            }
                            GridCoordinates2D startGridCoord = gridGeometry.worldToGrid((DirectPosition)startDP);
                            GridCoordinates2D endGridCoord = gridGeometry.worldToGrid((DirectPosition)endDP);
                            for (int k = startGridCoord.x; k <= endGridCoord.x; ++k) {
                                double v = inIter.getSampleDouble(k, r, 0);
                                if (JGTConstants.isNovalue(v)) {
                                    ++passiveCellCount;
                                    continue;
                                }
                                min = Math.min(min, v);
                                max = Math.max(max, v);
                                values[activeCellCount] = v;
                                ++activeCellCount;
                                if (hasUserTotalMean) continue;
                                tm_utm_tac[0] = tm_utm_tac[0] + v;
                                tm_utm_tac[2] = tm_utm_tac[2] + 1.0;
                            }
                        }
                        continue;
                    }
                    if (coords.length == 1) {
                        String message = MessageFormat.format("Found a cusp in: {0}/{1}", coords[0].x, coords[0].y);
                        if (monitor != null) {
                            monitor.errorMessage(message);
                            continue;
                        }
                        throw new ModelsIOException(message, "ZonalStats");
                    }
                    throw new ModelsIOException(MessageFormat.format("Found intersection with more than 2 points in: {0}/{1}", coords[0].x, coords[0].y), "ZonalStats");
                }
            }
            previousLine = line;
        }
        int all = activeCellCount + passiveCellCount;
        double ratio = 100.0 * (double)activeCellCount / (double)all;
        if (ratio < percentageThres) {
            return null;
        }
        double mean = OmsZonalStats.mean(values, activeCellCount);
        double sdev = OmsZonalStats.standardDeviation(values, mean, activeCellCount);
        double var = OmsZonalStats.variance(values, mean, activeCellCount);
        if (hasUserTotalMean) {
            double meanAbsoluteDeviation = OmsZonalStats.meanAbsoluteDeviation(values, activeCellCount, tm_utm_tac[1]);
            result = new double[]{min, max, mean, var, sdev, meanAbsoluteDeviation, activeCellCount, passiveCellCount};
        } else {
            result = new double[]{min, max, mean, var, sdev, activeCellCount, passiveCellCount};
        }
        return result;
    }

    public static SimpleFeatureBuilder createFeatureBuilder(CoordinateReferenceSystem crs, boolean hasUserTotalMean) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("stats");
        b.setCRS(crs);
        b.add("the_geom", Polygon.class);
        b.add(MIN, Double.class);
        b.add(MAX, Double.class);
        b.add(AVG, Double.class);
        b.add(VAR, Double.class);
        b.add(SDEV, Double.class);
        if (hasUserTotalMean) {
            b.add(AVGABSDEV, Double.class);
        }
        b.add(ACTCELLS, Integer.class);
        b.add(INVCELLS, Integer.class);
        SimpleFeatureType type = b.buildFeatureType();
        return new SimpleFeatureBuilder(type);
    }

    private static double meanAbsoluteDeviation(double[] values, int count, double userTotalMean) {
        double mean = 0.0;
        for (int i = 0; i < count; ++i) {
            mean += Math.abs(values[i] - userTotalMean);
        }
        return mean / (double)count;
    }

    private static double mean(double[] values, int count) {
        double mean = 0.0;
        for (int i = 0; i < count; ++i) {
            mean += values[i];
        }
        return mean / (double)count;
    }

    private static double standardDeviation(double[] values, double mean, int count) {
        double sd = OmsZonalStats.variance(values, mean, count);
        sd = Math.sqrt(sd);
        return sd;
    }

    private static double variance(double[] values, double mean, int count) {
        double variance = 0.0;
        for (int i = 0; i < count; ++i) {
            variance += Math.pow(values[i] - mean, 2.0);
        }
        return variance /= (double)count;
    }

    protected void processCell(int readCol, int readRow, int writeCol, int writeRow, int readCols, int readRows, int writeCols, int writeRows) {
    }
}

