/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.interpolation2d.core;

import com.vividsolutions.jts.geom.Coordinate;
import javax.vecmath.GMatrix;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.jgrasstools.gears.modules.r.interpolation2d.core.ISurfaceInterpolator;

public class TPSInterpolator
implements ISurfaceInterpolator {
    private final double buffer;

    public TPSInterpolator(double buffer) {
        this.buffer = buffer;
    }

    @Override
    public double getBuffer() {
        return this.buffer;
    }

    @Override
    public double getValue(Coordinate[] controlPoints, Coordinate interpolated) {
        double value;
        int controlPointsNum = controlPoints.length;
        GeneralMatrix v = null;
        try {
            v = this.makeMatrix(controlPoints);
        }
        catch (Exception e) {
            return Double.NaN;
        }
        double a1 = v.getElement(v.getNumRow() - 3, 0);
        double a2 = v.getElement(v.getNumRow() - 2, 0);
        double a3 = v.getElement(v.getNumRow() - 1, 0);
        double sum = 0.0;
        for (int i = 0; i < controlPointsNum; ++i) {
            double dist = interpolated.distance(controlPoints[i]);
            sum += v.getElement(i, 0) * this.functionU(dist);
        }
        interpolated.z = value = a1 + a2 * interpolated.x + a3 * interpolated.y + sum;
        return value;
    }

    private GeneralMatrix makeMatrix(Coordinate[] controlPoints) {
        int pointsNum = controlPoints.length;
        GeneralMatrix L = new GeneralMatrix(pointsNum + 3, pointsNum + 3);
        this.fillKsubMatrix(controlPoints, L);
        this.fillPsubMatrix(controlPoints, L);
        this.fillOsubMatrix(controlPoints, L);
        L.invert();
        GeneralMatrix V = this.fillVMatrix(0, controlPoints);
        GeneralMatrix result = new GeneralMatrix(pointsNum + 3, 1);
        result.mul((GMatrix)L, (GMatrix)V);
        return result;
    }

    private double functionU(double distance) {
        if (distance == 0.0) {
            return 0.0;
        }
        return distance * distance * Math.log(distance);
    }

    private double calculateFunctionU(Coordinate p_i, Coordinate p_j) {
        double distance = p_i.distance(p_j);
        return this.functionU(distance);
    }

    private void fillKsubMatrix(Coordinate[] controlPoints, GeneralMatrix L) {
        double alfa = 0.0;
        int controlPointsNum = controlPoints.length;
        for (int i = 0; i < controlPointsNum; ++i) {
            for (int j = i + 1; j < controlPointsNum; ++j) {
                double u = this.calculateFunctionU(controlPoints[i], controlPoints[j]);
                L.setElement(i, j, u);
                L.setElement(j, i, u);
                alfa += u * 2.0;
            }
        }
        alfa /= (double)(controlPointsNum * controlPointsNum);
    }

    private void fillPsubMatrix(Coordinate[] controlPoints, GeneralMatrix L) {
        int controlPointsNum = controlPoints.length;
        for (int i = 0; i < controlPointsNum; ++i) {
            L.setElement(i, i, 0.0);
            L.setElement(i, controlPointsNum + 0, 1.0);
            L.setElement(i, controlPointsNum + 1, controlPoints[i].x);
            L.setElement(i, controlPointsNum + 2, controlPoints[i].y);
            L.setElement(controlPointsNum + 0, i, 1.0);
            L.setElement(controlPointsNum + 1, i, controlPoints[i].x);
            L.setElement(controlPointsNum + 2, i, controlPoints[i].y);
        }
    }

    private void fillOsubMatrix(Coordinate[] controlPoints, GeneralMatrix L) {
        int controlPointsNum;
        for (int i = controlPointsNum = controlPoints.length; i < controlPointsNum + 3; ++i) {
            for (int j = controlPointsNum; j < controlPointsNum + 3; ++j) {
                L.setElement(i, j, 0.0);
            }
        }
    }

    private GeneralMatrix fillVMatrix(int dim, Coordinate[] controlPoints) {
        int controlPointsNum = controlPoints.length;
        GeneralMatrix V = new GeneralMatrix(controlPointsNum + 3, 1);
        for (int i = 0; i < controlPointsNum; ++i) {
            V.setElement(i, 0, controlPoints[i].z);
        }
        V.setElement(V.getNumRow() - 3, 0, 0.0);
        V.setElement(V.getNumRow() - 2, 0, 0.0);
        V.setElement(V.getNumRow() - 1, 0, 0.0);
        return V;
    }
}

