/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Logger;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Initialize;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.Process;
import org.geotools.process.ProcessException;
import org.jgrasstools.gears.io.rasterreader.OmsRasterReader;
import org.jgrasstools.gears.io.rasterwriter.OmsRasterWriter;
import org.jgrasstools.gears.io.vectorreader.OmsVectorReader;
import org.jgrasstools.gears.io.vectorwriter.OmsVectorWriter;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.exceptions.ModelsUserCancelException;
import org.jgrasstools.gears.libs.modules.ModelsSupporter;
import org.jgrasstools.gears.libs.monitor.GeotoolsProgressMonitorAdapter;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;
import org.opengis.util.ProgressListener;

public class JGTModel
implements Process {
    private static boolean doLogging = false;
    @Description(en="The progress monitor.", it="The progress monitor.")
    @In
    public IJGTProgressMonitor pm = new LogProgressMonitor();
    public GeometryFactory gf = new GeometryFactory();
    @UI(value="iterator")
    public boolean doProcess = false;
    public boolean doReset = false;

    public static int getDefaultThreadsNum() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return availableProcessors;
    }

    protected boolean isCanceled(IJGTProgressMonitor pm) {
        if (pm.isCanceled()) {
            pm.done();
            return true;
        }
        return false;
    }

    public void checkCancel() {
        if (this.pm != null && this.pm.isCanceled()) {
            throw new ModelsUserCancelException();
        }
    }

    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) throws ProcessException {
        GeotoolsProgressMonitorAdapter pm = new GeotoolsProgressMonitorAdapter(monitor);
        input.put("pm", pm);
        ComponentAccess.setInputData(input, (Object)this, null);
        ComponentAccess.callAnnotated((Object)this, Initialize.class, (boolean)true);
        ComponentAccess.callAnnotated((Object)this, Execute.class, (boolean)false);
        ComponentAccess.callAnnotated((Object)this, Finalize.class, (boolean)true);
        ComponentAccess cA = new ComponentAccess((Object)this);
        Collection outputs = cA.outputs();
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        for (Access access : outputs) {
            try {
                String fieldName = access.getField().getName();
                Object fieldValue = access.getFieldValue();
                outputMap.put(fieldName, fieldValue);
            }
            catch (Exception e) {
                throw new ProcessException(e.getLocalizedMessage());
            }
        }
        return outputMap;
    }

    protected boolean concatOr(boolean ... statements) {
        boolean isTrue = statements[0];
        for (int i = 1; i < statements.length; ++i) {
            isTrue = isTrue || statements[i];
        }
        return isTrue;
    }

    protected void checkNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            throw new ModelsIllegalargumentException("Mandatory input argument is missing. Check your syntax...", this.getClass().getSimpleName(), this.pm);
        }
    }

    protected void checkFileExists(String ... existingFilePath) {
        StringBuilder sb = null;
        for (String filePath : existingFilePath) {
            File file = new File(filePath);
            if (file.exists()) continue;
            if (sb == null) {
                sb = new StringBuilder();
                sb.append("The following file doesn't seem to exist: ");
            }
            sb.append("\n\t").append(file.getAbsolutePath());
        }
        if (sb != null) {
            throw new ModelsIllegalargumentException(sb.toString(), this.getClass().getSimpleName(), this.pm);
        }
    }

    protected String checkWorkingFolderInPath(String filePath) {
        if (filePath.contains("@@@WORKINGFOLDER@@@")) {
            return null;
        }
        return filePath;
    }

    public GridCoverage2D getRaster(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        OmsRasterReader reader = new OmsRasterReader();
        reader.pm = this.pm;
        reader.file = source;
        reader.process();
        GridCoverage2D geodata = reader.outRaster;
        return geodata;
    }

    public SimpleFeatureCollection getVector(String source) throws Exception {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        OmsVectorReader reader = new OmsVectorReader();
        reader.pm = this.pm;
        reader.file = source;
        reader.process();
        SimpleFeatureCollection fc = reader.outVector;
        return fc;
    }

    public void dumpRaster(GridCoverage2D raster, String source) throws Exception {
        if (raster == null || source == null) {
            return;
        }
        OmsRasterWriter writer = new OmsRasterWriter();
        writer.pm = this.pm;
        writer.inRaster = raster;
        writer.file = source;
        writer.process();
    }

    public void dumpVector(SimpleFeatureCollection vector, String source) throws Exception {
        if (vector == null || source == null) {
            return;
        }
        OmsVectorWriter writer = new OmsVectorWriter();
        writer.pm = this.pm;
        writer.file = source;
        writer.inVector = vector;
        writer.process();
    }

    public void help() throws Exception {
        String help = ModelsSupporter.generateHelp(this);
        this.pm.message(help);
    }

    public void template() throws Exception {
        String help = ModelsSupporter.generateTemplate(this);
        this.pm.message(help);
    }

    static {
        if (!doLogging) {
            Handler[] handlers;
            Logger l0 = Logger.getLogger("");
            for (Handler handler : handlers = l0.getHandlers()) {
                l0.removeHandler(handler);
            }
        }
    }
}

