/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.adige;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.MemoryTable;
import org.jgrasstools.gears.io.adige.AdigeBoundaryCondition;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Utility class for writing the final boundary conditions of the model adige to an OMS formatted csv file.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Writing")
@Label(value="Generic Writer")
@Name(value="adigeboundcondwriter")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class AdigeBoundaryConditionWriter
extends JGTModel {
    @Description(value="The csv file to write to.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The table name.")
    @In
    public String tablename = "table";
    @Description(value="The list of boundary conditions to write.")
    @In
    public HashMap<Integer, AdigeBoundaryCondition> data;
    private MemoryTable memoryTable;
    private DateTimeFormatter formatter = JGTConstants.dateTimeFormatterYYYYMMDDHHMM;

    private void ensureOpen() throws IOException {
        if (this.memoryTable == null) {
            this.memoryTable = new MemoryTable();
            this.memoryTable.setName(this.tablename);
            this.memoryTable.getInfo().put("Created", new DateTime().toString(this.formatter));
        }
    }

    @Execute
    public void write() throws IOException {
        this.ensureOpen();
        String[] colNames = new String[]{"basinid", "discharge", "sub-discharge", "S1", "S2"};
        this.memoryTable.setColumns(colNames);
        Set<Map.Entry<Integer, AdigeBoundaryCondition>> entrySet = this.data.entrySet();
        for (Map.Entry<Integer, AdigeBoundaryCondition> entry : entrySet) {
            AdigeBoundaryCondition condition = entry.getValue();
            Object[] valuesRow = new Object[colNames.length];
            valuesRow[0] = condition.basinId;
            valuesRow[1] = condition.discharge;
            valuesRow[2] = condition.dischargeSub;
            valuesRow[3] = condition.S1;
            valuesRow[4] = condition.S2;
            this.memoryTable.addRow(valuesRow);
        }
    }

    @Finalize
    public void close() throws IOException {
        DataIO.print((CSTable)this.memoryTable, (PrintWriter)new PrintWriter(new File(this.file)));
    }
}

