/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.util.KeyIntMap;

public class LocalNameQualifiedNamesMap
extends KeyIntMap {
    private LocalNameQualifiedNamesMap _readOnlyMap;
    private int _index;
    private Entry[] _table;

    public LocalNameQualifiedNamesMap(int n, float f) {
        super(n, f);
        this._table = new Entry[this._capacity];
    }

    public LocalNameQualifiedNamesMap(int n) {
        this(n, 0.75f);
    }

    public LocalNameQualifiedNamesMap() {
        this(16, 0.75f);
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this._table.length; ++i) {
            this._table[i] = null;
        }
        this._size = 0;
        this._index = this._readOnlyMap != null ? this._readOnlyMap.getIndex() : 0;
    }

    @Override
    public final void setReadOnlyMap(KeyIntMap keyIntMap, boolean bl) {
        if (!(keyIntMap instanceof LocalNameQualifiedNamesMap)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{keyIntMap}));
        }
        this.setReadOnlyMap((LocalNameQualifiedNamesMap)keyIntMap, bl);
    }

    public final void setReadOnlyMap(LocalNameQualifiedNamesMap localNameQualifiedNamesMap, boolean bl) {
        this._readOnlyMap = localNameQualifiedNamesMap;
        if (this._readOnlyMap != null) {
            this._readOnlyMapSize = this._readOnlyMap.size();
            this._index = this._readOnlyMap.getIndex();
            if (bl) {
                this.clear();
            }
        } else {
            this._readOnlyMapSize = 0;
            this._index = 0;
        }
    }

    public final boolean isQNameFromReadOnlyMap(QualifiedName qualifiedName) {
        return this._readOnlyMap != null && qualifiedName.index <= this._readOnlyMap.getIndex();
    }

    public final int getNextIndex() {
        return this._index++;
    }

    public final int getIndex() {
        return this._index;
    }

    public final Entry obtainEntry(String string) {
        Entry entry;
        int n = LocalNameQualifiedNamesMap.hashHash(string.hashCode());
        if (this._readOnlyMap != null && (entry = this._readOnlyMap.getEntry(string, n)) != null) {
            return entry;
        }
        int n2 = LocalNameQualifiedNamesMap.indexFor(n, this._table.length);
        Entry entry2 = this._table[n2];
        while (entry2 != null) {
            if (entry2._hash == n && this.eq(string, entry2._key)) {
                return entry2;
            }
            entry2 = entry2._next;
        }
        return this.addEntry(string, n, n2);
    }

    public final Entry obtainDynamicEntry(String string) {
        int n = LocalNameQualifiedNamesMap.hashHash(string.hashCode());
        int n2 = LocalNameQualifiedNamesMap.indexFor(n, this._table.length);
        Entry entry = this._table[n2];
        while (entry != null) {
            if (entry._hash == n && this.eq(string, entry._key)) {
                return entry;
            }
            entry = entry._next;
        }
        return this.addEntry(string, n, n2);
    }

    private final Entry getEntry(String string, int n) {
        Entry entry;
        if (this._readOnlyMap != null && (entry = this._readOnlyMap.getEntry(string, n)) != null) {
            return entry;
        }
        int n2 = LocalNameQualifiedNamesMap.indexFor(n, this._table.length);
        Entry entry2 = this._table[n2];
        while (entry2 != null) {
            if (entry2._hash == n && this.eq(string, entry2._key)) {
                return entry2;
            }
            entry2 = entry2._next;
        }
        return null;
    }

    private final Entry addEntry(String string, int n, int n2) {
        Entry entry = this._table[n2];
        this._table[n2] = new Entry(string, n, entry);
        entry = this._table[n2];
        if (this._size++ >= this._threshold) {
            this.resize(2 * this._table.length);
        }
        return entry;
    }

    private final void resize(int n) {
        this._capacity = n;
        Entry[] entryArray = this._table;
        int n2 = entryArray.length;
        if (n2 == 0x100000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[this._capacity];
        this.transfer(entryArray2);
        this._table = entryArray2;
        this._threshold = (int)((float)this._capacity * this._loadFactor);
    }

    private final void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this._table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2._next;
                int n2 = LocalNameQualifiedNamesMap.indexFor(entry2._hash, n);
                entry2._next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    private final boolean eq(String string, String string2) {
        return string == string2 || string.equals(string2);
    }

    public static class Entry {
        final String _key;
        final int _hash;
        public QualifiedName[] _value;
        public int _valueIndex;
        Entry _next;

        public Entry(String string, int n, Entry entry) {
            this._key = string;
            this._hash = n;
            this._next = entry;
            this._value = new QualifiedName[1];
        }

        public void addQualifiedName(QualifiedName qualifiedName) {
            if (this._valueIndex < this._value.length) {
                this._value[this._valueIndex++] = qualifiedName;
            } else if (this._valueIndex == this._value.length) {
                QualifiedName[] qualifiedNameArray = new QualifiedName[this._valueIndex * 3 / 2 + 1];
                System.arraycopy(this._value, 0, qualifiedNameArray, 0, this._valueIndex);
                this._value = qualifiedNameArray;
                this._value[this._valueIndex++] = qualifiedName;
            }
        }
    }
}

