/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.algorithm;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class BooleanEncodingAlgorithm
extends BuiltInEncodingAlgorithm {
    private static final int[] BIT_TABLE = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    @Override
    public int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int n) {
        if (n < 5) {
            return 1;
        }
        int n2 = n / 8;
        return n2 == 0 ? 2 : 1 + n2;
    }

    @Override
    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        int n3 = this.getPrimtiveLengthFromOctetLength(n2, byArray[n]);
        boolean[] blArray = new boolean[n3];
        this.decodeFromBytesToBooleanArray(blArray, 0, n3, byArray, n, n2);
        return blArray;
    }

    @Override
    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        int n2 = n >> 4 & 0xFF;
        int n3 = 4;
        int n4 = 8;
        int n5 = 0;
        do {
            if ((n5 = inputStream.read()) == -1) {
                n4 -= n2;
            }
            while (n3 < n4) {
                arrayList.add((n & BIT_TABLE[n3++]) > 0);
            }
        } while ((n = n5) != -1);
        return this.generateArrayFromList(arrayList);
    }

    @Override
    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof boolean[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotBoolean"));
        }
        boolean[] blArray = (boolean[])object;
        int n = blArray.length;
        int n2 = (n + 4) % 8;
        int n3 = n2 == 0 ? 0 : 8 - n2;
        int n4 = 4;
        int n5 = n3 << 4;
        int n6 = 0;
        while (n6 < n) {
            if (blArray[n6++]) {
                n5 |= BIT_TABLE[n4];
            }
            if (++n4 != 8) continue;
            outputStream.write(n5);
            n5 = 0;
            n4 = 0;
        }
        if (n4 != 8) {
            outputStream.write(n5);
        }
    }

    @Override
    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return new boolean[0];
        }
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new BuiltInEncodingAlgorithm.WordListener(){

            @Override
            public void word(int n, int n2) {
                if (charBuffer.charAt(n) == 't') {
                    arrayList.add(Boolean.TRUE);
                } else {
                    arrayList.add(Boolean.FALSE);
                }
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    @Override
    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            return;
        }
        boolean[] blArray = (boolean[])object;
        if (blArray.length == 0) {
            return;
        }
        stringBuffer.ensureCapacity(blArray.length * 5);
        int n = blArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            if (blArray[i]) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append("false");
            }
            if (i == n) continue;
            stringBuffer.append(' ');
        }
    }

    public int getPrimtiveLengthFromOctetLength(int n, int n2) throws EncodingAlgorithmException {
        int n3 = n2 >> 4 & 0xFF;
        if (n == 1) {
            if (n3 > 3) {
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.unusedBits4"));
            }
            return 4 - n3;
        }
        if (n3 > 7) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.unusedBits8"));
        }
        return n * 8 - 4 - n3;
    }

    public final void decodeFromBytesToBooleanArray(boolean[] blArray, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = byArray[n3++] & 0xFF;
        int n6 = 4;
        int n7 = n + n2;
        while (n < n7) {
            if (n6 == 8) {
                n5 = byArray[n3++] & 0xFF;
                n6 = 0;
            }
            blArray[n++] = (n5 & BIT_TABLE[n6++]) > 0;
        }
    }

    @Override
    public void encodeToBytes(Object object, int n, int n2, byte[] byArray, int n3) {
        if (!(object instanceof boolean[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotBoolean"));
        }
        this.encodeToBytesFromBooleanArray((boolean[])object, n, n2, byArray, n3);
    }

    public void encodeToBytesFromBooleanArray(boolean[] blArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = (n2 + 4) % 8;
        int n5 = n4 == 0 ? 0 : 8 - n4;
        int n6 = 4;
        int n7 = n5 << 4;
        int n8 = n + n2;
        while (n < n8) {
            if (blArray[n++]) {
                n7 |= BIT_TABLE[n6];
            }
            if (++n6 != 8) continue;
            byArray[n3++] = (byte)n7;
            n7 = 0;
            n6 = 0;
        }
        if (n6 > 0) {
            byArray[n3] = (byte)n7;
        }
    }

    private boolean[] generateArrayFromList(List list) {
        boolean[] blArray = new boolean[list.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)list.get(i);
        }
        return blArray;
    }
}

