/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.reflect.opt;

import com.sun.xml.internal.bind.Util;
import com.sun.xml.internal.bind.v2.bytecode.ClassTailor;
import com.sun.xml.internal.bind.v2.runtime.RuntimeUtil;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.AccessorInjector;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.Bean;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.FieldAccessor_Byte;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.MethodAccessor_Byte;
import com.sun.xml.internal.bind.v2.runtime.reflect.opt.Ref;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class OptimizedAccessorFactory {
    private static final Logger logger = Util.getClassLogger();
    private static final String fieldTemplateName;
    private static final String methodTemplateName;

    private OptimizedAccessorFactory() {
    }

    public static final <B, V> Accessor<B, V> get(Method method, Method method2) {
        String string;
        if (method.getParameterTypes().length != 0) {
            return null;
        }
        Class<?>[] classArray = method2.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        if (classArray[0] != method.getReturnType()) {
            return null;
        }
        if (method2.getReturnType() != Void.TYPE) {
            return null;
        }
        if (method.getDeclaringClass() != method2.getDeclaringClass()) {
            return null;
        }
        if (Modifier.isPrivate(method.getModifiers()) || Modifier.isPrivate(method2.getModifiers())) {
            return null;
        }
        Class<?> clazz = classArray[0];
        String string2 = clazz.getName().replace('.', '_');
        if (clazz.isArray()) {
            string2 = "AOf_";
            string = clazz.getComponentType().getName().replace('.', '_');
            while (string.startsWith("[L")) {
                string = string.substring(2);
                string2 = string2 + "AOf_";
            }
            string2 = string2 + string;
        }
        string = ClassTailor.toVMClassName(method.getDeclaringClass()) + "$JaxbAccessorM_" + method.getName() + '_' + method2.getName() + '_' + string2;
        Class<?> clazz2 = clazz.isPrimitive() ? AccessorInjector.prepare(method.getDeclaringClass(), methodTemplateName + RuntimeUtil.primitiveToBox.get(clazz).getSimpleName(), string, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(method.getDeclaringClass()), "get_" + clazz.getName(), method.getName(), "set_" + clazz.getName(), method2.getName()) : AccessorInjector.prepare(method.getDeclaringClass(), methodTemplateName + "Ref", string, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(method.getDeclaringClass()), ClassTailor.toVMClassName(Ref.class), ClassTailor.toVMClassName(clazz), "()" + ClassTailor.toVMTypeName(Ref.class), "()" + ClassTailor.toVMTypeName(clazz), '(' + ClassTailor.toVMTypeName(Ref.class) + ")V", '(' + ClassTailor.toVMTypeName(clazz) + ")V", "get_ref", method.getName(), "set_ref", method2.getName());
        if (clazz2 == null) {
            return null;
        }
        Accessor<B, V> accessor = OptimizedAccessorFactory.instanciate(clazz2);
        if (accessor != null && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Using optimized Accessor for {0} and {1}", new Object[]{method, method2});
        }
        return accessor;
    }

    public static final <B, V> Accessor<B, V> get(Field field) {
        int n = field.getModifiers();
        if (Modifier.isPrivate(n) || Modifier.isFinal(n)) {
            return null;
        }
        String string = ClassTailor.toVMClassName(field.getDeclaringClass()) + "$JaxbAccessorF_" + field.getName();
        Class<?> clazz = field.getType().isPrimitive() ? AccessorInjector.prepare(field.getDeclaringClass(), fieldTemplateName + RuntimeUtil.primitiveToBox.get(field.getType()).getSimpleName(), string, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(field.getDeclaringClass()), "f_" + field.getType().getName(), field.getName()) : AccessorInjector.prepare(field.getDeclaringClass(), fieldTemplateName + "Ref", string, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(field.getDeclaringClass()), ClassTailor.toVMClassName(Ref.class), ClassTailor.toVMClassName(field.getType()), ClassTailor.toVMTypeName(Ref.class), ClassTailor.toVMTypeName(field.getType()), "f_ref", field.getName());
        if (clazz == null) {
            return null;
        }
        Accessor<B, V> accessor = OptimizedAccessorFactory.instanciate(clazz);
        if (accessor != null && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Using optimized Accessor for {0}", field);
        }
        return accessor;
    }

    private static <B, V> Accessor<B, V> instanciate(Class clazz) {
        try {
            return (Accessor)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.INFO, "failed to load an optimized Accessor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.INFO, "failed to load an optimized Accessor", illegalAccessException);
        }
        catch (SecurityException securityException) {
            logger.log(Level.INFO, "failed to load an optimized Accessor", securityException);
        }
        return null;
    }

    static {
        String string = FieldAccessor_Byte.class.getName();
        fieldTemplateName = string.substring(0, string.length() - "Byte".length()).replace('.', '/');
        string = MethodAccessor_Byte.class.getName();
        methodTemplateName = string.substring(0, string.length() - "Byte".length()).replace('.', '/');
    }
}

