/*
 * Decompiled with CFR 0.152.
 */
package jams.data;

import com.vividsolutions.jts.geom.Geometry;
import gnu.trove.map.hash.THashMap;
import jams.JAMS;
import jams.data.Attribute;
import jams.data.JAMSDouble;
import jams.data.JAMSFloat;
import jams.data.JAMSGeometry;
import jams.data.JAMSInteger;
import jams.data.JAMSLong;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class JAMSEntity
implements Attribute.Entity {
    private THashMap<String, Object> values = new THashMap();
    private long id = -1L;

    public void setFloat(String name, float attribute) {
        JAMSFloat v = (JAMSFloat)this.values.get((Object)name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put((Object)name, (Object)new JAMSFloat(attribute));
        }
    }

    public void setDouble(String name, double attribute) {
        JAMSDouble v = (JAMSDouble)this.values.get((Object)name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put((Object)name, (Object)new JAMSDouble(attribute));
        }
    }

    public void setInt(String name, int attribute) {
        JAMSInteger v = (JAMSInteger)this.values.get((Object)name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put((Object)name, (Object)new JAMSInteger(attribute));
        }
    }

    public void setLong(String name, long attribute) {
        JAMSLong v = (JAMSLong)this.values.get((Object)name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put((Object)name, (Object)new JAMSLong(attribute));
        }
    }

    public void setObject(String name, Object attribute) {
        this.values.put((Object)name, attribute);
    }

    public void setGeometry(String name, Geometry attribute) {
        JAMSGeometry v = (JAMSGeometry)this.values.get((Object)name);
        if (v != null) {
            v.setValue(attribute);
        } else {
            this.values.put((Object)name, (Object)new JAMSGeometry(attribute));
        }
    }

    public float getFloat(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey((Object)name)) {
            return ((JAMSFloat)this.values.get((Object)name)).getValue();
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(float)_not_found!"));
    }

    public double getDouble(String name) throws Attribute.Entity.NoSuchAttributeException {
        Object o = this.values.get((Object)name);
        if (o == null) {
            throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(double)_not_found!"));
        }
        return ((JAMSDouble)o).getValue();
    }

    public int getInt(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey((Object)name)) {
            return ((JAMSInteger)this.values.get((Object)name)).getValue();
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(int)_not_found!"));
    }

    public long getLong(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey((Object)name)) {
            return ((JAMSLong)this.values.get((Object)name)).getValue();
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(long)_not_found!"));
    }

    public Object getObject(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey((Object)name)) {
            return this.values.get((Object)name);
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(Object)_not_found!"));
    }

    public Geometry getGeometry(String name) throws Attribute.Entity.NoSuchAttributeException {
        if (this.values.containsKey((Object)name)) {
            return ((JAMSGeometry)this.values.get((Object)name)).getValue();
        }
        throw new Attribute.Entity.NoSuchAttributeException(JAMS.i18n("Attribute_") + name + JAMS.i18n("_(Geometry)_not_found!"));
    }

    public boolean existsAttribute(String name) {
        return this.values.containsKey((Object)name);
    }

    public Object[] getKeys() {
        return this.values.keySet().toArray(new Object[this.values.size()]);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public void setValue(String value) {
        StringTokenizer st1 = new StringTokenizer(value, "\t");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            String name = st2.nextToken().trim();
            String val = st2.nextToken().trim();
            try {
                JAMSDouble d = new JAMSDouble(Double.parseDouble(val));
                this.values.put((Object)name, (Object)d);
            }
            catch (NumberFormatException nfe) {
                System.out.println("\"" + val + "\" is not a valid double expression!");
                nfe.printStackTrace();
            }
        }
    }

    public void setValue(THashMap<String, Object> values) {
        this.values = values;
    }

    public void setValue(Attribute.Entity value) {
        this.setValue((THashMap<String, Object>)value.getValue());
        this.setId(value.getId());
    }

    public THashMap<String, Object> getValue() {
        return this.values;
    }

    public boolean removeValue(String name) {
        return this.values.remove((Object)name) != null;
    }

    public void removeValues() {
        this.values.clear();
    }

    public String getStringValue() {
        String result = "";
        String[] names = this.values.keySet().toArray(new String[this.values.size()]);
        if (names.length > 0) {
            result = result + names[0] + "=" + this.values.get((Object)names[0]).toString() + "f";
        }
        for (int i = 1; i < names.length; ++i) {
            result = result + "\t" + names[i] + "=" + this.values.get((Object)names[i]).toString() + "f";
        }
        return result;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        String result = "$ID = " + this.getId();
        if (this.values == null) {
            return result;
        }
        TreeSet orderedSet = new TreeSet(this.values.keySet());
        for (String key : orderedSet) {
            result = result + "\t" + key + "=" + this.values.get((Object)key);
        }
        return result;
    }
}

