/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2IntMap;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Long2IntOpenHashMap
extends AbstractLong2IntMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient long[] key;
    protected transient int[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Long2IntMap.FastEntrySet entries;
    protected volatile transient LongSet keys;
    protected volatile transient IntCollection values;

    public Long2IntOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new long[this.n];
        this.value = new int[this.n];
        this.used = new boolean[this.n];
    }

    public Long2IntOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Long2IntOpenHashMap() {
        this(16, 0.75f);
    }

    public Long2IntOpenHashMap(Map<? extends Long, ? extends Integer> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2IntOpenHashMap(Map<? extends Long, ? extends Integer> m) {
        this(m, 0.75f);
    }

    public Long2IntOpenHashMap(Long2IntMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Long2IntOpenHashMap(Long2IntMap m) {
        this(m, 0.75f);
    }

    public Long2IntOpenHashMap(long[] k, int[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2IntOpenHashMap(long[] k, int[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public int put(long k, int v) {
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                int oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Integer put(Long ok, Integer ov) {
        int v = ov;
        long k = ok;
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Integer oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public int add(long k, int incr) {
        return this.addTo(k, incr);
    }

    public int addTo(long k, int incr) {
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                int oldValue = this.value[pos];
                int n = pos;
                this.value[n] = this.value[n] + incr;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = this.defRetValue + incr;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(this.key[pos] ^ (long)this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public int remove(long k) {
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                int v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Integer remove(Object ok) {
        long k = (Long)ok;
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                int v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Integer get(Long ok) {
        long k = ok;
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public int get(long k) {
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(long k) {
        int pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(int v) {
        int[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Long2IntMap.FastEntrySet long2IntEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public LongSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public IntCollection values() {
        if (this.values == null) {
            this.values = new AbstractIntCollection(){

                @Override
                public IntIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Long2IntOpenHashMap.this.size;
                }

                @Override
                public boolean contains(int v) {
                    return Long2IntOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Long2IntOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        long[] key = this.key;
        int[] value = this.value;
        int mask = newN - 1;
        long[] newKey = new long[newN];
        int[] newValue = new int[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            long k = key[i];
            int pos = (int)HashCommon.murmurHash3(k ^ (long)mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Long2IntOpenHashMap clone() {
        Long2IntOpenHashMap c;
        try {
            c = (Long2IntOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (long[])this.key.clone();
        c.value = (int[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.long2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        long[] key = this.key;
        int[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeLong(key[e]);
            s.writeInt(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new long[this.n];
        long[] key = this.key;
        this.value = new int[this.n];
        int[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            long k = s.readLong();
            int v = s.readInt();
            pos = (int)HashCommon.murmurHash3(k ^ (long)this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int nextInt() {
            return Long2IntOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Integer next() {
            return Long2IntOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractLongSet {
        private KeySet() {
        }

        @Override
        public LongIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Long2IntOpenHashMap.this.size;
        }

        @Override
        public boolean contains(long k) {
            return Long2IntOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(long k) {
            int oldSize = Long2IntOpenHashMap.this.size;
            Long2IntOpenHashMap.this.remove(k);
            return Long2IntOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Long2IntOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements LongIterator {
        @Override
        public long nextLong() {
            return Long2IntOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Long next() {
            return Long2IntOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Long2IntMap.Entry>
    implements Long2IntMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Long2IntMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Long2IntMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            long k = (Long)e.getKey();
            int pos = (int)HashCommon.murmurHash3(k ^ (long)Long2IntOpenHashMap.this.mask) & Long2IntOpenHashMap.this.mask;
            while (Long2IntOpenHashMap.this.used[pos]) {
                if (Long2IntOpenHashMap.this.key[pos] == k) {
                    return Long2IntOpenHashMap.this.value[pos] == (Integer)e.getValue();
                }
                pos = pos + 1 & Long2IntOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            long k = (Long)e.getKey();
            int pos = (int)HashCommon.murmurHash3(k ^ (long)Long2IntOpenHashMap.this.mask) & Long2IntOpenHashMap.this.mask;
            while (Long2IntOpenHashMap.this.used[pos]) {
                if (Long2IntOpenHashMap.this.key[pos] == k) {
                    Long2IntOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Long2IntOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Long2IntOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Long2IntOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Long2IntMap.Entry> {
        final AbstractLong2IntMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractLong2IntMap.BasicEntry(0L, 0);
        }

        @Override
        public AbstractLong2IntMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Long2IntOpenHashMap.this.key[e];
            this.entry.value = Long2IntOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Long2IntMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Long2IntMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        LongArrayList wrapped;

        private MapIterator() {
            this.pos = Long2IntOpenHashMap.this.n;
            this.last = -1;
            this.c = Long2IntOpenHashMap.this.size;
            boolean[] used = Long2IntOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                long k = this.wrapped.getLong(-this.pos - 2);
                int pos = (int)HashCommon.murmurHash3(k ^ (long)Long2IntOpenHashMap.this.mask) & Long2IntOpenHashMap.this.mask;
                while (Long2IntOpenHashMap.this.used[pos]) {
                    if (Long2IntOpenHashMap.this.key[pos] == k) {
                        return pos;
                    }
                    pos = pos + 1 & Long2IntOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Long2IntOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Long2IntOpenHashMap.this.mask;
                while (Long2IntOpenHashMap.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Long2IntOpenHashMap.this.key[pos] ^ (long)Long2IntOpenHashMap.this.mask) & Long2IntOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Long2IntOpenHashMap.this.mask;
                }
                if (!Long2IntOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new LongArrayList();
                    }
                    this.wrapped.add(Long2IntOpenHashMap.this.key[pos]);
                }
                Long2IntOpenHashMap.this.key[last] = Long2IntOpenHashMap.this.key[pos];
                Long2IntOpenHashMap.this.value[last] = Long2IntOpenHashMap.this.value[pos];
            }
            Long2IntOpenHashMap.this.used[last] = false;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Long2IntOpenHashMap.this.remove(this.wrapped.getLong(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Long2IntOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Long2IntMap.Entry,
    Map.Entry<Long, Integer> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Long getKey() {
            return Long2IntOpenHashMap.this.key[this.index];
        }

        @Override
        public long getLongKey() {
            return Long2IntOpenHashMap.this.key[this.index];
        }

        @Override
        public Integer getValue() {
            return Long2IntOpenHashMap.this.value[this.index];
        }

        @Override
        public int getIntValue() {
            return Long2IntOpenHashMap.this.value[this.index];
        }

        @Override
        public int setValue(int v) {
            int oldValue = Long2IntOpenHashMap.this.value[this.index];
            Long2IntOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Integer setValue(Integer v) {
            return this.setValue((int)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Long2IntOpenHashMap.this.key[this.index] == (Long)e.getKey() && Long2IntOpenHashMap.this.value[this.index] == (Integer)e.getValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.long2int(Long2IntOpenHashMap.this.key[this.index]) ^ Long2IntOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Long2IntOpenHashMap.this.key[this.index] + "=>" + Long2IntOpenHashMap.this.value[this.index];
        }
    }
}

