/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.ForwardLineOfOwnTroops;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LineOfContact
extends ForwardLineOfOwnTroops {
    protected Path path2 = this.createPath();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-GLC--------");
    }

    public LineOfContact(String string) {
        super(string);
    }

    @Override
    public void moveTo(Position position) {
        Position position2 = this.path.getReferencePosition();
        Position position3 = this.path2.getReferencePosition();
        Position position4 = position2 != null && position3 != null ? position3.subtract(position2) : Position.ZERO;
        super.moveTo(position);
        this.path2.moveTo(position.add(position4));
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        super.doRenderGraphic(drawContext);
        this.path2.render(drawContext);
    }

    @Override
    protected String getGraphicLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mustShowHostileIndicator()) {
            stringBuilder.append("ENY");
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    protected void generateIntermediatePositions(DrawContext drawContext, Iterable<? extends Position> iterable) {
        Globe globe = drawContext.getGlobe();
        boolean bl = false;
        double d = this.getWaveLength();
        if (d == 0.0) {
            d = this.computeDefaultWavelength(iterable, globe);
            bl = true;
        }
        ArrayList<Position> arrayList = new ArrayList<Position>();
        ArrayList<Position> arrayList2 = new ArrayList<Position>();
        this.generateParallelLines(iterable.iterator(), arrayList, arrayList2, d / 2.0, globe);
        if (bl) {
            d = this.computeDefaultWavelength(arrayList, globe);
        }
        double d2 = d / 2.0;
        ForwardLineOfOwnTroops.PositionIterator positionIterator = new ForwardLineOfOwnTroops.PositionIterator(arrayList, d, globe);
        this.computedPositions = this.generateWavePositions(positionIterator, d2 / globe.getRadius(), false);
        this.path.setPositions(this.computedPositions);
        if (bl) {
            d = this.computeDefaultWavelength(arrayList2, globe);
        }
        d2 = d / 2.0;
        positionIterator = new ForwardLineOfOwnTroops.PositionIterator(arrayList2, d, globe);
        this.path2.setPositions(this.generateWavePositions(positionIterator, d2 / globe.getRadius(), true));
    }

    public void generateParallelLines(Iterator<? extends Position> iterator, List<Position> list, List<Position> list2, double d, Globe globe) {
        Position position = iterator.next();
        Position position2 = iterator.next();
        Vec4 vec4 = globe.computePointFromLocation(position2);
        Vec4 vec42 = globe.computePointFromLocation(position);
        this.generateParallelPoints(vec42, null, vec4, list, list2, d, globe);
        while (iterator.hasNext()) {
            position2 = iterator.next();
            Vec4 vec43 = vec42;
            vec42 = vec4;
            vec4 = globe.computePointFromLocation(position2);
            this.generateParallelPoints(vec42, vec43, vec4, list, list2, d, globe);
        }
        this.generateParallelPoints(vec4, vec42, null, list, list2, d, globe);
    }

    protected void generateParallelPoints(Vec4 vec4, Vec4 vec42, Vec4 vec43, List<Position> list, List<Position> list2, double d, Globe globe) {
        double d2;
        Object object;
        Vec4 vec44;
        Vec4 vec45;
        if (vec4 == null || vec42 == null && vec43 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null || list2 == null) {
            String string = Logging.getMessage("nullValue.PositionListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec46 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec47 = vec42 != null ? vec42.subtract3(vec4) : vec4.subtract3(vec43);
        Vec4 vec48 = vec47.cross3(vec46);
        if (vec43 != null && vec42 != null && !Vec4.areColinear(vec42, vec4, vec43)) {
            vec45 = vec43.subtract3(vec4);
            vec44 = vec45.normalize3().add3(vec47.normalize3());
            double d3 = vec48.dot3(vec44 = vec44.normalize3());
            if (d3 < 0.0) {
                vec44 = vec44.multiply3(-1.0);
            }
            d2 = !Angle.ZERO.equals(object = vec47.angleBetween3(vec44)) ? d / ((Angle)object).sin() : d;
        } else {
            vec44 = vec48.normalize3();
            d2 = d;
        }
        vec44 = vec44.multiply3(d2);
        vec45 = vec4.add3(vec44);
        Vec4 vec49 = vec4.subtract3(vec44);
        Position position = globe.computePositionFromPoint(vec49);
        object = globe.computePositionFromPoint(vec45);
        list.add(position);
        list2.add((Position)object);
    }
}

