/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.retrieve.RetrievalFuture;
import gov.nasa.worldwind.retrieve.RetrievalService;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import java.net.SocketTimeoutException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLHandshakeException;

public final class BasicRetrievalService
extends WWObjectImpl
implements RetrievalService,
Thread.UncaughtExceptionHandler {
    private static final int DEFAULT_QUEUE_SIZE = 100;
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final long DEFAULT_STALE_REQUEST_LIMIT = 30000L;
    private static final int DEFAULT_TIME_PRIORITY_GRANULARITY = 500;
    private static final String RUNNING_THREAD_NAME_PREFIX = Logging.getMessage("BasicRetrievalService.RunningThreadNamePrefix");
    private static final String IDLE_THREAD_NAME_PREFIX = Logging.getMessage("BasicRetrievalService.IdleThreadNamePrefix");
    private RetrievalExecutor executor;
    private ConcurrentLinkedQueue<RetrievalTask> activeTasks;
    private int queueSize;
    protected RetrievalService.SSLExceptionListener sslExceptionListener;

    @Override
    public RetrievalService.SSLExceptionListener getSSLExceptionListener() {
        return this.sslExceptionListener;
    }

    @Override
    public void setSSLExceptionListener(RetrievalService.SSLExceptionListener sSLExceptionListener) {
        this.sslExceptionListener = sSLExceptionListener;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Logging.logger().fine(Logging.getMessage("BasicRetrievalService.UncaughtExceptionDuringRetrieval", thread.getName()));
    }

    public BasicRetrievalService() {
        Integer n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.RetrievalPoolSize", 5);
        this.queueSize = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.RetrievalQueueSize", 100);
        this.executor = new RetrievalExecutor(n, this.queueSize);
        this.activeTasks = new ConcurrentLinkedQueue();
    }

    @Override
    public void shutdown(boolean bl) {
        if (bl) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
        this.activeTasks.clear();
    }

    @Override
    public RetrievalFuture runRetriever(Retriever retriever) {
        if (retriever == null) {
            String string = Logging.getMessage("nullValue.RetrieverIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (retriever.getName() == null) {
            String string = Logging.getMessage("nullValue.RetrieverNameIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        return this.runRetriever(retriever, Long.MAX_VALUE - System.currentTimeMillis());
    }

    @Override
    public synchronized RetrievalFuture runRetriever(Retriever retriever, double d) {
        if (retriever == null) {
            String string = Logging.getMessage("nullValue.RetrieverIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (retriever.getName() == null) {
            String string = Logging.getMessage("nullValue.RetrieverNameIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isAvailable()) {
            Logging.logger().finer(Logging.getMessage("BasicRetrievalService.ResourceRejected", retriever.getName()));
        }
        RetrievalTask retrievalTask = new RetrievalTask(retriever, d);
        retriever.setSubmitTime(System.currentTimeMillis());
        if (this.activeTasks.contains(retrievalTask) || this.executor.getQueue().contains(retrievalTask)) {
            return null;
        }
        this.executor.execute(retrievalTask);
        return retrievalTask;
    }

    @Override
    public void setRetrieverPoolSize(int n) {
        if (n < 1) {
            String string = Logging.getMessage("BasicRetrievalService.RetrieverPoolSizeIsLessThanOne");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.executor.setCorePoolSize(n);
        this.executor.setMaximumPoolSize(n);
    }

    @Override
    public int getRetrieverPoolSize() {
        return this.executor.getCorePoolSize();
    }

    private boolean hasRetrievers() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        int n = Thread.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (!threadArray[i].getName().startsWith(RUNNING_THREAD_NAME_PREFIX)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasActiveTasks() {
        return this.hasRetrievers();
    }

    @Override
    public boolean isAvailable() {
        return this.executor.getQueue().size() < this.queueSize;
    }

    @Override
    public int getNumRetrieversPending() {
        return this.activeTasks.size() + this.executor.getQueue().size();
    }

    @Override
    public boolean contains(Retriever retriever) {
        if (retriever == null) {
            String string = Logging.getMessage("nullValue.RetrieverIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        RetrievalTask retrievalTask = new RetrievalTask(retriever, 0.0);
        return this.activeTasks.contains(retrievalTask) || this.executor.getQueue().contains(retrievalTask);
    }

    public double getProgress() {
        Object object;
        int n = 0;
        int n2 = 0;
        for (RetrievalTask runnable : this.activeTasks) {
            if (runnable.isDone()) continue;
            object = runnable.getRetriever();
            try {
                double retriever = object.getContentLength();
                if (!(retriever > 0.0)) continue;
                n = (int)((double)n + retriever);
                n2 += object.getContentLengthRead();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.FINE, Logging.getMessage("BasicRetrievalService.ExceptionRetrievingContentSizes", object.getName() != null ? object.getName() : ""), exception);
            }
        }
        for (Runnable runnable : this.executor.getQueue()) {
            object = (RetrievalTask)runnable;
            Retriever retriever = ((RetrievalTask)object).getRetriever();
            try {
                double d = retriever.getContentLength();
                if (!(d > 0.0)) continue;
                n = (int)((double)n + d);
                n2 += retriever.getContentLengthRead();
            }
            catch (Exception exception) {
                String string = Logging.getMessage("BasicRetrievalService.ExceptionRetrievingContentSizes") + (retriever.getName() != null ? retriever.getName() : "");
                Logging.logger().log(Level.FINE, string, exception);
            }
        }
        double d = n < 1 ? 0.0 : Math.min(100.0, 100.0 * (double)n2 / (double)n);
        return d;
    }

    private class RetrievalExecutor
    extends ThreadPoolExecutor {
        private static final long THREAD_TIMEOUT = 2L;
        private long staleRequestLimit;

        private RetrievalExecutor(int n, int n2) {
            super(n, n, 2L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(n2), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setPriority(1);
                    thread.setUncaughtExceptionHandler(BasicRetrievalService.this);
                    return thread;
                }
            }, new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    Logging.logger().finer(Logging.getMessage("BasicRetrievalService.ResourceRejected", ((RetrievalTask)runnable).getRetriever().getName()));
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
            this.staleRequestLimit = Configuration.getLongValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 30000L);
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            long l;
            if (thread == null) {
                String string = Logging.getMessage("nullValue.ThreadIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (runnable == null) {
                String string = Logging.getMessage("nullValue.RunnableIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            RetrievalTask retrievalTask = (RetrievalTask)runnable;
            retrievalTask.retriever.setBeginTime(System.currentTimeMillis());
            long l2 = l = retrievalTask.retriever.getStaleRequestLimit() >= 0 ? (long)retrievalTask.retriever.getStaleRequestLimit() : this.staleRequestLimit;
            if (retrievalTask.retriever.getBeginTime() - retrievalTask.retriever.getSubmitTime() > l) {
                Logging.logger().finer(Logging.getMessage("BasicRetrievalService.CancellingTooOldRetrieval", retrievalTask.getRetriever().getName()));
                retrievalTask.cancel(true);
            }
            if (BasicRetrievalService.this.activeTasks.contains(retrievalTask)) {
                Logging.logger().finer(Logging.getMessage("BasicRetrievalService.CancellingDuplicateRetrieval", retrievalTask.getRetriever().getName()));
                retrievalTask.cancel(true);
            }
            BasicRetrievalService.this.activeTasks.add(retrievalTask);
            thread.setName(RUNNING_THREAD_NAME_PREFIX + retrievalTask.getRetriever().getName());
            thread.setPriority(1);
            thread.setUncaughtExceptionHandler(BasicRetrievalService.this);
            super.beforeExecute(thread, runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            if (runnable == null) {
                String string = Logging.getMessage("nullValue.RunnableIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            super.afterExecute(runnable, throwable);
            RetrievalTask retrievalTask = (RetrievalTask)runnable;
            BasicRetrievalService.this.activeTasks.remove(retrievalTask);
            retrievalTask.retriever.setEndTime(System.currentTimeMillis());
            try {
                if (throwable != null) {
                    Logging.logger().log(Level.FINE, Logging.getMessage("BasicRetrievalService.ExceptionDuringRetrieval", retrievalTask.getRetriever().getName()), throwable);
                }
                retrievalTask.get();
            }
            catch (ExecutionException executionException) {
                String string = Logging.getMessage("BasicRetrievalService.ExecutionExceptionDuringRetrieval", retrievalTask.getRetriever().getName());
                if (executionException.getCause() instanceof SocketTimeoutException) {
                    Logging.logger().fine(string + " " + executionException.getCause().getLocalizedMessage());
                } else if (executionException.getCause() instanceof SSLHandshakeException) {
                    if (BasicRetrievalService.this.sslExceptionListener != null) {
                        BasicRetrievalService.this.sslExceptionListener.onException(executionException.getCause(), retrievalTask.getRetriever().getName());
                    } else {
                        Logging.logger().fine(string + " " + executionException.getCause().getLocalizedMessage());
                    }
                } else {
                    Logging.logger().log(Level.FINE, string, executionException);
                }
            }
            catch (InterruptedException interruptedException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("BasicRetrievalService.RetrievalInterrupted", retrievalTask.getRetriever().getName()), interruptedException);
            }
            catch (CancellationException cancellationException) {
                Logging.logger().fine(Logging.getMessage("BasicRetrievalService.RetrievalCancelled", retrievalTask.getRetriever().getName()));
            }
            finally {
                Thread.currentThread().setName(IDLE_THREAD_NAME_PREFIX);
            }
        }
    }

    private static class RetrievalTask
    extends FutureTask<Retriever>
    implements RetrievalFuture,
    Comparable<RetrievalTask> {
        private Retriever retriever;
        private double priority;

        private RetrievalTask(Retriever retriever, double d) {
            super(retriever);
            this.retriever = retriever;
            this.priority = d;
        }

        public double getPriority() {
            return this.priority;
        }

        @Override
        public Retriever getRetriever() {
            return this.retriever;
        }

        @Override
        public void run() {
            if (this.isDone() || this.isCancelled()) {
                return;
            }
            super.run();
        }

        @Override
        public int compareTo(RetrievalTask retrievalTask) {
            long l;
            long l2;
            long l3;
            if (retrievalTask == null) {
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().fine(string);
                throw new IllegalArgumentException(string);
            }
            if (this.priority > 0.0 && retrievalTask.priority > 0.0 && ((l3 = (l2 = System.currentTimeMillis()) - this.retriever.getSubmitTime()) - (l = l2 - retrievalTask.retriever.getSubmitTime())) / 500L != 0L) {
                return l3 < l ? -1 : 1;
            }
            return this.priority == retrievalTask.priority ? 0 : (this.priority < retrievalTask.priority ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RetrievalTask retrievalTask = (RetrievalTask)object;
            return this.retriever.equals(retrievalTask.retriever);
        }

        public int hashCode() {
            return this.retriever.getName().hashCode();
        }
    }
}

