/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.jogamp.opengl.util.awt.TextRenderer;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Font;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TextRendererCache
implements Disposable {
    protected ConcurrentHashMap<Object, TextRenderer> textRendererMap = new ConcurrentHashMap();

    @Override
    public void dispose() {
        this.disposeAll();
        this.textRendererMap.clear();
    }

    public int getNumObjects() {
        return this.textRendererMap.size();
    }

    public TextRenderer get(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.textRendererMap.get(object);
    }

    public void put(Object object, TextRenderer textRenderer) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TextRenderer textRenderer2 = this.textRendererMap.put(object, textRenderer);
        if (textRenderer2 != null) {
            this.dispose(textRenderer2);
        }
    }

    public void remove(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TextRenderer textRenderer = this.textRendererMap.remove(object);
        if (textRenderer != null) {
            this.dispose(textRenderer);
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.textRendererMap.containsKey(object);
    }

    public void clear() {
        this.disposeAll();
        this.textRendererMap.clear();
    }

    protected void dispose(TextRenderer textRenderer) {
        if (textRenderer != null) {
            textRenderer.dispose();
        }
    }

    protected void disposeAll() {
        for (Map.Entry<Object, TextRenderer> entry : this.textRendererMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.dispose(entry.getValue());
        }
    }

    public static class CacheKey {
        private final Font font;
        private final boolean antialiased;
        private final boolean useFractionalMetrics;
        private final boolean mipmap;

        public CacheKey(Font font, boolean bl, boolean bl2, boolean bl3) {
            if (font == null) {
                String string = Logging.getMessage("nullValue.FontIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.font = font;
            this.antialiased = bl;
            this.useFractionalMetrics = bl2;
            this.mipmap = bl3;
        }

        public final Font getFont() {
            return this.font;
        }

        public final boolean isAntialiased() {
            return this.antialiased;
        }

        public final boolean isUseFractionalMetrics() {
            return this.useFractionalMetrics;
        }

        public final boolean isMipmap() {
            return this.mipmap;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            return this.antialiased == cacheKey.antialiased && this.useFractionalMetrics == cacheKey.useFractionalMetrics && this.mipmap == cacheKey.mipmap && this.font.equals(cacheKey.font);
        }

        public int hashCode() {
            int n = this.font.hashCode();
            n = 31 * n + (this.antialiased ? 1 : 0);
            n = 31 * n + (this.useFractionalMetrics ? 1 : 0);
            n = 31 * n + (this.mipmap ? 1 : 0);
            return n;
        }
    }
}

