/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurfacePolyline
extends AbstractSurfaceShape
implements Exportable {
    protected boolean closed;
    protected Iterable<? extends LatLon> locations;

    public SurfacePolyline() {
    }

    public SurfacePolyline(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfacePolyline(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.locations = iterable;
    }

    public SurfacePolyline(ShapeAttributes shapeAttributes, Iterable<? extends LatLon> iterable) {
        super(shapeAttributes);
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.locations = iterable;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
        this.onShapeChanged();
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        return this.getLocations();
    }

    public Iterable<? extends LatLon> getLocations() {
        return this.locations;
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.locations = iterable;
        this.onShapeChanged();
    }

    @Override
    public Position getReferencePosition() {
        if (this.locations == null) {
            return null;
        }
        Iterator<? extends LatLon> iterator = this.locations.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return new Position(iterator.next(), 0.0);
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.locations == null) {
            return null;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        double d = this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext);
        this.generateIntermediateLocations(this.locations, d, this.isClosed(), arrayList);
        if (arrayList.size() < 2) {
            return null;
        }
        ArrayList<List<LatLon>> arrayList2 = new ArrayList<List<LatLon>>();
        arrayList2.add(arrayList);
        return arrayList2;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (this.locations == null) {
            return;
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (LatLon latLon : this.locations) {
            Angle angle = LatLon.greatCircleAzimuth(position, latLon);
            Angle angle2 = LatLon.greatCircleDistance(position, latLon);
            arrayList.add(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
        }
        this.setLocations(arrayList);
    }

    @Override
    protected void drawInterior(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
    }

    @Override
    protected boolean canContainPole() {
        return this.isClosed();
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        Iterable<? extends LatLon> iterable = this.getLocations();
        if (iterable != null) {
            restorableSupport.addStateValueAsLatLonList(stateObject, "locationList", iterable);
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "closed", this.isClosed());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        super.doRestoreState(restorableSupport, stateObject);
        List<LatLon> list = restorableSupport.getStateValueAsLatLonList(stateObject, "locationList");
        if (list != null) {
            this.setLocations(list);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "closed")) != null) {
            this.setClosed(bl);
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        List<LatLon> list = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        if (list != null) {
            this.setLocations(list);
        }
    }

    @Override
    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        String string3 = (String)this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string4 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string4 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string4);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        ShapeAttributes shapeAttributes = this.getAttributes();
        ShapeAttributes shapeAttributes2 = this.getHighlightAttributes();
        if (shapeAttributes != null || shapeAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "normal", shapeAttributes);
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "highlight", shapeAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("LineString");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("0");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("tessellate");
        xMLStreamWriter.writeCharacters("1");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("coordinates");
        for (LatLon latLon : this.getLocations()) {
            xMLStreamWriter.writeCharacters(Double.toString(latLon.getLongitude().getDegrees()));
            xMLStreamWriter.writeCharacters(",");
            xMLStreamWriter.writeCharacters(Double.toString(latLon.getLatitude().getDegrees()));
            xMLStreamWriter.writeCharacters(" ");
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

