/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Point;
import java.awt.Rectangle;

public class ScreenRelativeAnnotation
extends ScreenAnnotation {
    private static Point DUMMY_POINT = new Point();
    private double xFraction;
    private double yFraction;
    private int xMargin = 5;
    private int yMargin = 5;
    private boolean keepFullyVisible = true;

    public ScreenRelativeAnnotation(String string, double d, double d2) {
        super(string, DUMMY_POINT);
        this.init(d, d2);
    }

    private void init(double d, double d2) {
        this.xFraction = d;
        this.yFraction = d2;
    }

    public boolean isKeepFullyVisible() {
        return this.keepFullyVisible;
    }

    public void setKeepFullyVisible(boolean bl) {
        this.keepFullyVisible = bl;
    }

    public double getXFraction() {
        return this.xFraction;
    }

    public void setXFraction(double d) {
        this.xFraction = d;
    }

    public double getYFraction() {
        return this.yFraction;
    }

    public void setYFraction(double d) {
        this.yFraction = d;
    }

    public int getXMargin() {
        return this.xMargin;
    }

    public void setXMargin(int n) {
        this.xMargin = n;
    }

    public int getYMargin() {
        return this.yMargin;
    }

    public void setYMargin(int n) {
        this.yMargin = n;
    }

    @Override
    protected Point getScreenPoint(DrawContext drawContext) {
        Rectangle rectangle = drawContext.getView().getViewport();
        double d = rectangle.getX() + this.xFraction * rectangle.getWidth();
        double d2 = rectangle.getY() + this.yFraction * rectangle.getHeight();
        Point point = this.computeSize(drawContext);
        double[] dArray = this.computeOffset(drawContext);
        if (this.keepFullyVisible) {
            double d3 = d - (double)(point.x / 2) + dArray[0];
            double d4 = d2 + dArray[1];
            double d5 = (double)rectangle.x + rectangle.getWidth() - (d3 + (double)point.x + (double)this.xMargin);
            double d6 = (double)rectangle.y + rectangle.getHeight() - (d4 + (double)point.y + (double)this.yMargin);
            if (d5 < 0.0) {
                d += d5;
            }
            if (d3 < (double)(rectangle.x + this.xMargin)) {
                d = rectangle.x + this.xMargin + point.x / 2;
            }
            if (d6 < 0.0) {
                d2 += d6;
            }
            if (d4 < (double)(rectangle.y + this.yMargin)) {
                d2 = rectangle.y + this.yMargin;
            }
        }
        Point point2 = new Point((int)d, (int)d2);
        super.setScreenPoint(point2);
        return point2;
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = null;
        String string = super.getRestorableState();
        if (string != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        restorableSupport.addStateValueAsDouble("xFraction", this.getXFraction());
        restorableSupport.addStateValueAsDouble("yFraction", this.getYFraction());
        restorableSupport.addStateValueAsInteger("xMargin", this.getXMargin());
        restorableSupport.addStateValueAsInteger("yMargin", this.getYMargin());
        restorableSupport.addStateValueAsBoolean("keepFullyVisible", this.isKeepFullyVisible());
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        Boolean bl;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            super.restoreState(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        Double d = restorableSupport.getStateValueAsDouble("xFraction");
        if (d != null) {
            this.setXFraction(d);
        }
        Double d2 = restorableSupport.getStateValueAsDouble("yFraction");
        if (d != null) {
            this.setYFraction(d2);
        }
        Integer n = restorableSupport.getStateValueAsInteger("xMargin");
        if (d != null) {
            this.setXMargin(n);
        }
        Integer n2 = restorableSupport.getStateValueAsInteger("yMargin");
        if (d != null) {
            this.setYMargin(n2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("keepFullyVisible")) != null) {
            this.setKeepFullyVisible(bl);
        }
    }
}

