/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.Declutterable;
import gov.nasa.worldwind.render.DeclutteringTextRenderer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.util.Logging;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;

public class DeclutterableText
implements Declutterable {
    protected GeographicText text;
    protected Vec4 point;
    protected double eyeDistance;
    protected DeclutteringTextRenderer textRenderer;
    protected boolean enableDecluttering = true;
    protected Rectangle2D textBounds;
    protected Font boundsFont;

    DeclutterableText(GeographicText geographicText, Vec4 vec4, double d, DeclutteringTextRenderer declutteringTextRenderer) {
        this.text = geographicText;
        this.point = vec4;
        this.eyeDistance = d;
        this.textRenderer = declutteringTextRenderer;
    }

    @Override
    public boolean isEnableDecluttering() {
        return this.enableDecluttering;
    }

    @Override
    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    public GeographicText getText() {
        return this.text;
    }

    public Vec4 getPoint() {
        return this.point;
    }

    @Override
    public Rectangle2D getBounds(DrawContext drawContext) {
        Font font = this.getText().getFont();
        if (font == null) {
            font = this.textRenderer.getDefaultFont();
        }
        if (this.textBounds != null && this.boundsFont == font) {
            return this.textBounds;
        }
        try {
            this.textBounds = this.textRenderer.computeTextBounds(drawContext, this);
            this.boundsFont = font;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
        }
        return this.textBounds;
    }

    @Override
    public void render(DrawContext drawContext) {
        try {
            if (this.getBounds(drawContext) == null) {
                return;
            }
            this.textRenderer.drawText(drawContext, this, 1.0, 1.0);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRenderingText", exception);
        }
    }

    @Override
    public void pick(DrawContext drawContext, Point point) {
    }
}

