/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLLineString;
import gov.nasa.worldwind.ogc.kml.KMLLineStyle;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLPolyStyle;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;

public class KMLLineStringPlacemarkImpl
extends Path
implements KMLRenderable {
    protected final KMLAbstractFeature parent;
    protected boolean highlightAttributesResolved = false;
    protected boolean normalAttributesResolved = false;

    public KMLLineStringPlacemarkImpl(KMLTraversalContext kMLTraversalContext, KMLPlacemark kMLPlacemark, KMLAbstractGeometry kMLAbstractGeometry) {
        super(((KMLLineString)kMLAbstractGeometry).getCoordinates());
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLPlacemark == null) {
            String string = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.parent = kMLPlacemark;
        KMLLineString kMLLineString = (KMLLineString)kMLAbstractGeometry;
        if (kMLLineString.isExtrude()) {
            this.setExtrude(true);
        }
        if (kMLLineString.getTessellate() != null && kMLLineString.getTessellate().booleanValue()) {
            this.setFollowTerrain(true);
        }
        this.setAltitudeMode(1);
        String string = kMLLineString.getAltitudeMode();
        if (!WWUtil.isEmpty(string)) {
            if ("clampToGround".equals(string)) {
                this.setAltitudeMode(1);
            } else if ("relativeToGround".equals(string)) {
                this.setAltitudeMode(2);
            } else if ("absolute".equals(string)) {
                this.setAltitudeMode(0);
            }
        }
        if (this.getAltitudeMode() == 1 && this.isFollowTerrain()) {
            this.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        } else {
            this.setPathType("gov.nasa.worldwind.avkey.Linear");
        }
        if (kMLPlacemark.getName() != null) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", kMLPlacemark.getName());
        }
        if (kMLPlacemark.getDescription() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Description", kMLPlacemark.getDescription());
        }
        if (kMLPlacemark.getSnippetText() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", kMLPlacemark.getSnippetText());
        }
        this.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        ShapeAttributes shapeAttributes;
        if (this.isHighlighted()) {
            ShapeAttributes shapeAttributes2;
            if (!this.highlightAttributesResolved && ((shapeAttributes2 = this.getHighlightAttributes()) == null || shapeAttributes2.isUnresolved()) && (shapeAttributes2 = this.makeAttributesCurrent("highlight")) != null) {
                this.setHighlightAttributes(shapeAttributes2);
                if (!shapeAttributes2.isUnresolved()) {
                    this.highlightAttributesResolved = true;
                }
            }
        } else if (!this.normalAttributesResolved && ((shapeAttributes = this.getAttributes()) == null || shapeAttributes.isUnresolved()) && (shapeAttributes = this.makeAttributesCurrent("normal")) != null) {
            this.setAttributes(shapeAttributes);
            if (!shapeAttributes.isUnresolved()) {
                this.normalAttributesResolved = true;
            }
        }
        this.render(drawContext);
    }

    @Override
    protected PickedObject createPickedObject(int n) {
        PickedObject pickedObject = super.createPickedObject(n);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
        return pickedObject;
    }

    protected ShapeAttributes makeAttributesCurrent(String string) {
        ShapeAttributes shapeAttributes = this.getInitialAttributes(this.isHighlighted() ? "highlight" : "normal");
        KMLAbstractSubStyle kMLAbstractSubStyle = this.parent.getSubStyle(new KMLLineStyle(null), string);
        if (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle)) {
            KMLUtil.assembleLineAttributes(shapeAttributes, (KMLLineStyle)kMLAbstractSubStyle);
            if (kMLAbstractSubStyle.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                shapeAttributes.setUnresolved(true);
            }
        }
        KMLAbstractSubStyle kMLAbstractSubStyle2 = this.parent.getSubStyle(new KMLPolyStyle(null), string);
        if (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle)) {
            KMLUtil.assembleInteriorAttributes(shapeAttributes, (KMLPolyStyle)kMLAbstractSubStyle2);
            if (kMLAbstractSubStyle2.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                shapeAttributes.setUnresolved(true);
            }
            shapeAttributes.setDrawInterior(((KMLPolyStyle)kMLAbstractSubStyle2).isFill());
            if (this.isExtrude()) {
                shapeAttributes.setDrawOutline(((KMLPolyStyle)kMLAbstractSubStyle2).isOutline());
            }
        }
        return shapeAttributes;
    }

    protected ShapeAttributes getInitialAttributes(String string) {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        if ("highlight".equals(string)) {
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setInteriorMaterial(Material.PINK);
        } else {
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
        }
        return basicShapeAttributes;
    }

    @Override
    public void onMessage(Message message) {
        super.onMessage(message);
        if ("KMLAbstractObject.StyleChanged".equals(message.getName())) {
            this.normalAttributesResolved = false;
            this.highlightAttributesResolved = false;
            if (this.getAttributes() != null) {
                this.getAttributes().setUnresolved(true);
            }
            if (this.getHighlightAttributes() != null) {
                this.getHighlightAttributes().setUnresolved(true);
            }
        }
    }
}

