/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaAsset;
import gov.nasa.worldwind.ogc.collada.ColladaParserContext;
import gov.nasa.worldwind.ogc.collada.ColladaResourceResolver;
import gov.nasa.worldwind.ogc.collada.ColladaScene;
import gov.nasa.worldwind.ogc.collada.ColladaUnit;
import gov.nasa.worldwind.ogc.collada.impl.ColladaRenderable;
import gov.nasa.worldwind.ogc.collada.impl.ColladaTraversalContext;
import gov.nasa.worldwind.ogc.collada.io.ColladaDoc;
import gov.nasa.worldwind.ogc.collada.io.ColladaFile;
import gov.nasa.worldwind.ogc.collada.io.ColladaInputStream;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.util.xml.XMLEventParserContextFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ColladaRoot
extends ColladaAbstractObject
implements ColladaRenderable,
Highlightable {
    protected ColladaDoc colladaDoc;
    protected XMLEventReader eventReader;
    protected InputStream eventStream;
    protected ColladaParserContext parserContext;
    protected Position position;
    protected int altitudeMode = 1;
    protected Angle heading;
    protected Angle pitch;
    protected Angle roll;
    protected Vec4 modelScale;
    protected boolean sceneFetched = false;
    protected ColladaScene scene;
    protected boolean scaleFetched = false;
    protected double scale;
    protected boolean highlighted;
    protected Matrix matrix;
    protected ColladaResourceResolver resourceResolver;

    public ColladaRoot(ColladaDoc colladaDoc) throws IOException {
        super("http://www.collada.org/2005/11/COLLADASchema");
        if (colladaDoc == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.colladaDoc = colladaDoc;
        this.initialize();
    }

    public ColladaRoot(File file) throws IOException {
        super("http://www.collada.org/2005/11/COLLADASchema");
        if (file == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.colladaDoc = new ColladaFile(file);
        this.initialize();
    }

    public ColladaRoot(URL uRL) throws IOException {
        super("http://www.collada.org/2005/11/COLLADASchema");
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        URLConnection uRLConnection = uRL.openConnection();
        this.colladaDoc = new ColladaInputStream(uRLConnection.getInputStream(), WWIO.makeURI(uRL));
        this.initialize();
    }

    public ColladaRoot(InputStream inputStream) throws IOException {
        super("http://www.collada.org/2005/11/COLLADASchema");
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.colladaDoc = new ColladaInputStream(inputStream, null);
        this.initialize();
    }

    public static ColladaRoot create(Object object) throws IOException {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof File) {
            return new ColladaRoot((File)object);
        }
        if (object instanceof URL) {
            return new ColladaRoot((URL)object);
        }
        if (object instanceof String) {
            File file = new File((String)object);
            if (file.exists()) {
                return new ColladaRoot(file);
            }
            URL uRL = WWIO.makeURL(object);
            if (uRL != null) {
                return new ColladaRoot(uRL);
            }
        } else if (object instanceof InputStream) {
            return new ColladaRoot((InputStream)object);
        }
        return null;
    }

    public static ColladaRoot createAndParse(Object object) throws IOException, XMLStreamException {
        ColladaRoot colladaRoot = ColladaRoot.create(object);
        if (colladaRoot == null) {
            String string = Logging.getMessage("generic.UnrecognizedSourceTypeOrUnavailableSource", object.toString());
            throw new IllegalArgumentException(string);
        }
        colladaRoot.parse(new Object[0]);
        return colladaRoot;
    }

    protected void initialize() throws IOException {
        this.eventStream = new BufferedInputStream(this.getColladaDoc().getInputStream());
        this.eventReader = this.createReader(this.eventStream);
        if (this.eventReader == null) {
            throw new WWRuntimeException(Logging.getMessage("XML.UnableToOpenDocument", this.getColladaDoc()));
        }
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected ColladaDoc getColladaDoc() {
        return this.colladaDoc;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
    }

    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        this.heading = angle;
        this.reset();
    }

    public Angle getPitch() {
        return this.pitch;
    }

    public void setPitch(Angle angle) {
        this.pitch = angle;
        this.reset();
    }

    public Angle getRoll() {
        return this.roll;
    }

    public void setRoll(Angle angle) {
        this.roll = angle;
        this.reset();
    }

    public Vec4 getModelScale() {
        return this.modelScale;
    }

    public void setModelScale(Vec4 vec4) {
        this.modelScale = vec4;
        this.reset();
    }

    public ColladaResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(ColladaResourceResolver colladaResourceResolver) {
        this.resourceResolver = colladaResourceResolver;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public Object resolveReference(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Object object;
            String string3;
            String[] stringArray = string.split("#");
            String string4 = stringArray[0];
            String string5 = string3 = stringArray.length > 1 ? stringArray[1] : null;
            if (WWUtil.isEmpty(string4) && !WWUtil.isEmpty(string3)) {
                return this.getItemByID(string3);
            }
            String string6 = this.getSupportFilePath(string4);
            if (string6 == null) {
                string6 = string4;
            }
            if ((object = WorldWind.getSessionCache().get(string6)) != null && object instanceof ColladaRoot) {
                return string3 != null ? ((ColladaRoot)object).getItemByID(string3) : object;
            }
            URL uRL = WWIO.makeURL(string6);
            if (uRL == null) {
                object = this.resolveLocalReference(string6, string3);
            }
            if (object == null) {
                object = this.resolveRemoteReference(string6, string3);
            }
            if (object != null) {
                return object;
            }
            return this.getItemByID(string);
        }
        catch (Exception exception) {
            String string7 = Logging.getMessage("generic.UnableToResolveReference", string);
            Logging.logger().warning(string7);
            return null;
        }
    }

    protected Object resolveLocalReference(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            if (!WWIO.isContentType(file, "model/collada+xml")) {
                return file.toURI().toString();
            }
            ColladaRoot colladaRoot = ColladaRoot.createAndParse(file);
            WorldWind.getSessionCache().put(string, colladaRoot);
            if (string2 != null) {
                return colladaRoot.getItemByID(string2);
            }
            return colladaRoot;
        }
        catch (Exception exception) {
            String string4 = Logging.getMessage("generic.UnableToResolveReference", string + "/" + string2);
            Logging.logger().warning(string4);
            return null;
        }
    }

    public Object resolveRemoteReference(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            Object object;
            URL uRL = WorldWind.getDataFileStore().requestFile(string);
            if (uRL == null) {
                return null;
            }
            String string4 = WorldWind.getDataFileStore().getContentType(string);
            if (string4 == null && !WWUtil.isEmpty(object = WWIO.getSuffix(string.split(";")[0]))) {
                string4 = WWIO.makeMimeTypeForSuffix((String)object);
            }
            if (!this.canParseContentType(string4)) {
                return uRL;
            }
            object = this.parseCachedColladaFile(uRL, string);
            WorldWind.getSessionCache().put(string, object);
            if (string2 != null) {
                return ((ColladaRoot)object).getItemByID(string2);
            }
            return object;
        }
        catch (Exception exception) {
            String string5 = Logging.getMessage("generic.UnableToResolveReference", string + "/" + string2);
            Logging.logger().warning(string5);
            return null;
        }
    }

    protected boolean canParseContentType(String string) {
        return "model/collada+xml".equals(string) || "text/plain".equals(string) || "text/xml".equals(string);
    }

    protected ColladaRoot parseCachedColladaFile(URL uRL, String string) throws IOException, XMLStreamException {
        InputStream inputStream = uRL.openStream();
        ColladaInputStream colladaInputStream = new ColladaInputStream(inputStream, WWIO.makeURI(string));
        try {
            ColladaRoot colladaRoot = new ColladaRoot(colladaInputStream);
            colladaRoot.parse(new Object[0]);
            return colladaRoot;
        }
        catch (XMLStreamException xMLStreamException) {
            inputStream.close();
            throw xMLStreamException;
        }
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object, true);
    }

    protected ColladaParserContext createParserContext(XMLEventReader xMLEventReader) {
        ColladaParserContext colladaParserContext = (ColladaParserContext)XMLEventParserContextFactory.createParserContext("model/collada+xml", this.getNamespaceURI());
        if (colladaParserContext == null) {
            String[] stringArray = new String[]{"model/collada+xml"};
            XMLEventParserContextFactory.addParserContext(stringArray, new ColladaParserContext(this.getNamespaceURI()));
            colladaParserContext = (ColladaParserContext)XMLEventParserContextFactory.createParserContext("model/collada+xml", this.getNamespaceURI());
        }
        colladaParserContext.setEventReader(xMLEventReader);
        return colladaParserContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColladaRoot parse(Object ... objectArray) throws XMLStreamException {
        ColladaParserContext colladaParserContext = this.parserContext;
        try {
            XMLEvent xMLEvent = colladaParserContext.nextEvent();
            while (colladaParserContext.hasNext()) {
                if (xMLEvent != null && xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().getLocalPart().equals("COLLADA")) {
                    super.parse(colladaParserContext, xMLEvent, objectArray);
                    ColladaRoot colladaRoot = this;
                    return colladaRoot;
                }
                xMLEvent = colladaParserContext.nextEvent();
            }
        }
        finally {
            colladaParserContext.getEventReader().close();
            this.closeEventStream();
        }
        return null;
    }

    protected void closeEventStream() {
        try {
            this.eventStream.close();
            this.eventStream = null;
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionClosingXmlEventReader");
            Logging.logger().warning(string);
        }
    }

    public ColladaScene getScene() {
        if (!this.sceneFetched) {
            this.scene = (ColladaScene)this.getField("scene");
            this.sceneFetched = true;
        }
        return this.scene;
    }

    public ColladaAsset getAsset() {
        return (ColladaAsset)this.getField("asset");
    }

    @Override
    public Box getLocalExtent(ColladaTraversalContext colladaTraversalContext) {
        if (colladaTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ColladaScene colladaScene = this.getScene();
        return colladaScene != null ? colladaScene.getLocalExtent(colladaTraversalContext) : null;
    }

    @Override
    public void preRender(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        colladaTraversalContext.multiplyMatrix(this.getMatrix());
        ColladaScene colladaScene = this.getScene();
        if (colladaScene != null) {
            colladaScene.preRender(colladaTraversalContext, drawContext);
        }
    }

    @Override
    public void render(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        colladaTraversalContext.multiplyMatrix(this.getMatrix());
        ColladaScene colladaScene = this.getScene();
        if (colladaScene != null) {
            colladaScene.render(colladaTraversalContext, drawContext);
        }
    }

    protected Matrix getMatrix() {
        if (this.matrix != null) {
            return this.matrix;
        }
        Matrix matrix = Matrix.IDENTITY;
        if (this.heading != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ(Angle.POS360.subtract(this.heading)));
        }
        if (this.pitch != null) {
            matrix = matrix.multiply(Matrix.fromRotationX(this.pitch));
        }
        if (this.roll != null) {
            matrix = matrix.multiply(Matrix.fromRotationY(this.roll));
        }
        double d = this.getScale();
        matrix = matrix.multiply(Matrix.fromScale(d));
        if (this.modelScale != null) {
            matrix = matrix.multiply(Matrix.fromScale(this.modelScale));
        }
        this.matrix = matrix;
        return matrix;
    }

    protected double getScale() {
        if (!this.scaleFetched) {
            this.scale = this.computeScale();
            this.scaleFetched = true;
        }
        return this.scale;
    }

    protected double computeScale() {
        ColladaUnit colladaUnit;
        Double d = null;
        ColladaAsset colladaAsset = this.getAsset();
        if (colladaAsset != null && (colladaUnit = colladaAsset.getUnit()) != null) {
            d = colladaUnit.getMeter();
        }
        return d != null ? d : 1.0;
    }

    protected void reset() {
        this.matrix = null;
    }

    protected XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public Object getItemByID(String string) {
        return string != null ? this.getParserContext().getIdTable().get(string) : null;
    }

    public String getSupportFilePath(String string) throws IOException {
        String string2 = null;
        ColladaResourceResolver colladaResourceResolver = this.getResourceResolver();
        if (colladaResourceResolver != null) {
            string2 = colladaResourceResolver.resolveFilePath(string);
        }
        if (string2 == null) {
            string2 = this.getColladaDoc().getSupportFilePath(string);
        }
        return string2;
    }
}

