/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.ogc.OGCRequestDescription;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringSetXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public abstract class OGCCapabilityInformation
extends AbstractXMLEventParser {
    protected QName REQUEST;
    protected QName EXCEPTION;
    protected QName FORMAT;
    protected QName EXTENDED_CAPABILITIES;
    protected QName USER_DEFINED_SYMBOLIZATION;
    protected Set<String> exceptionFormats = new HashSet<String>();
    protected Set<OGCRequestDescription> requestDescriptions = new HashSet<OGCRequestDescription>();
    protected Map<String, String> userDefinedSymbolization;

    protected abstract boolean isRequestName(XMLEventParserContext var1, QName var2);

    public OGCCapabilityInformation(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.REQUEST = new QName(this.getNamespaceURI(), "Request");
        this.EXCEPTION = new QName(this.getNamespaceURI(), "Exception");
        this.FORMAT = new QName(this.getNamespaceURI(), "Format");
        this.EXTENDED_CAPABILITIES = new QName(this.getNamespaceURI(), "ExtendedCapabilities");
        this.USER_DEFINED_SYMBOLIZATION = new QName(this.getNamespaceURI(), "UserDefinedSymbolization");
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        AbstractXMLEventParser abstractXMLEventParser = null;
        if (this.isRequestName(xMLEventParserContext, xMLEvent.asStartElement().getName())) {
            abstractXMLEventParser = new OGCRequestDescription(this.getNamespaceURI());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.EXCEPTION)) {
            abstractXMLEventParser = new StringSetXMLEventParser(this.getNamespaceURI(), this.FORMAT);
        }
        return xMLEventParserContext.allocate(xMLEvent, abstractXMLEventParser);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.EXCEPTION)) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof StringSetXMLEventParser) {
                this.setExceptionFormats(((StringSetXMLEventParser)object).getStrings());
            }
        } else if (xMLEvent.isStartElement() && this.isRequestName(xMLEventParserContext, xMLEvent.asStartElement().getName())) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OGCRequestDescription) {
                this.requestDescriptions.add((OGCRequestDescription)object);
            }
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.USER_DEFINED_SYMBOLIZATION)) {
            this.parseUserDefinedSymbolization(xMLEvent);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.EXTENDED_CAPABILITIES)) {
            this.parseExtendedCapabilities(xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void parseExtendedCapabilities(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
        if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null) {
            this.setExtendedCapabilities(object);
        }
    }

    protected void setExtendedCapabilities(Object object) {
    }

    protected void parseUserDefinedSymbolization(XMLEvent xMLEvent) throws XMLStreamException {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            this.addUserDefinedSymbolization(attribute.getName().getLocalPart(), attribute.getValue());
        }
    }

    public Set<String> getExceptionFormats() {
        if (this.exceptionFormats != null) {
            return this.exceptionFormats;
        }
        return Collections.emptySet();
    }

    protected void setExceptionFormats(Set<String> set) {
        this.exceptionFormats = set;
    }

    public Set<OGCRequestDescription> getRequestDescriptions() {
        return this.requestDescriptions;
    }

    protected void setRequestDescriptions(Set<OGCRequestDescription> set) {
        this.requestDescriptions = set;
    }

    public Map<String, String> getUserDefinedSymbolization() {
        if (this.userDefinedSymbolization != null) {
            return this.userDefinedSymbolization;
        }
        return Collections.emptyMap();
    }

    protected void setUserDefinedSymbolization(Map<String, String> map) {
        this.userDefinedSymbolization = map;
    }

    protected void addUserDefinedSymbolization(String string, String string2) {
        if (this.userDefinedSymbolization == null) {
            this.userDefinedSymbolization = new HashMap<String, String>();
        }
        this.userDefinedSymbolization.put(string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : this.getExceptionFormats()) {
            stringBuilder.append("Exception format: ").append(object).append("\n");
        }
        for (OGCRequestDescription oGCRequestDescription : this.getRequestDescriptions()) {
            stringBuilder.append(oGCRequestDescription);
        }
        for (Map.Entry entry : this.getUserDefinedSymbolization().entrySet()) {
            stringBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
        }
        return stringBuilder.toString();
    }
}

