/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.layers.rpf.wizard.FileChooserPanel;
import gov.nasa.worldwind.layers.rpf.wizard.RPFWizardUtil;
import gov.nasa.worldwind.util.wizard.DefaultPanelDescriptor;
import gov.nasa.worldwind.util.wizard.Wizard;
import gov.nasa.worldwind.util.wizard.WizardModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;

public class FileChooserPanelDescriptor
extends DefaultPanelDescriptor {
    private FileChooserPanel panelComponent = new FileChooserPanel();
    public static final String IDENTIFIER = "gov.nasa.worldwind.rpf.wizard.FileChooserPanel";

    public FileChooserPanelDescriptor() {
        this.panelComponent.addPropertyChangeListener(new PropertyEvents());
        this.setPanelIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panelComponent);
    }

    @Override
    public Object getBackPanelDescriptor() {
        return null;
    }

    @Override
    public Object getNextPanelDescriptor() {
        String string = !RPFWizardUtil.isFileListCurrent(this.getWizardModel()) ? "gov.nasa.worldwind.rpf.wizard.FileSearchPanel" : "gov.nasa.worldwind.rpf.wizard.DataChooserPanel";
        return string;
    }

    @Override
    public void aboutToDisplayPanel() {
        this.panelComponent.setTitle(RPFWizardUtil.makeLarger("Choose Folder to Search"));
        this.panelComponent.setDescription("<html><br>Folder to search...</html>");
        this.setNextButtonAccordingToSelectedFile();
    }

    private void setNextButtonAccordingToSelectedFile() {
        Wizard wizard = this.getWizard();
        if (wizard != null) {
            File file = RPFWizardUtil.getSelectedFile(wizard.getModel());
            wizard.setNextButtonEnabled(file != null && file.exists());
            wizard.giveFocusToNextButton();
        }
    }

    private void selectedFileChanged(Object object) {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null && object != null && object instanceof File) {
            RPFWizardUtil.setSelectedFile(wizardModel, (File)object);
        }
        this.setNextButtonAccordingToSelectedFile();
    }

    private class PropertyEvents
    implements PropertyChangeListener {
        private PropertyEvents() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null && (string = propertyChangeEvent.getPropertyName()).equals("selectedFile")) {
                FileChooserPanelDescriptor.this.selectedFileChanged(propertyChangeEvent.getNewValue());
            }
        }
    }
}

