/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.coords.UTMCoordConverter;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;

public class UTMCoord {
    private final Angle latitude;
    private final Angle longitude;
    private final String hemisphere;
    private final int zone;
    private final double easting;
    private final double northing;
    private Angle centralMeridian;

    public static UTMCoord fromLatLon(Angle angle, Angle angle2) {
        return UTMCoord.fromLatLon(angle, angle2, (Globe)null);
    }

    public static UTMCoord fromLatLon(Angle angle, Angle angle2, Globe globe) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        UTMCoordConverter uTMCoordConverter = new UTMCoordConverter(globe);
        long l = uTMCoordConverter.convertGeodeticToUTM(angle.radians, angle2.radians);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new UTMCoord(angle, angle2, uTMCoordConverter.getZone(), uTMCoordConverter.getHemisphere(), uTMCoordConverter.getEasting(), uTMCoordConverter.getNorthing(), Angle.fromRadians(uTMCoordConverter.getCentralMeridian()));
    }

    public static UTMCoord fromLatLon(Angle angle, Angle angle2, String string) {
        UTMCoordConverter uTMCoordConverter;
        if (angle == null || angle2 == null) {
            String string2 = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!WWUtil.isEmpty(string) && string.equals("NAD27")) {
            uTMCoordConverter = new UTMCoordConverter(6378206.4, 0.0033900753040885176);
            LatLon latLon = UTMCoordConverter.convertWGS84ToNAD27(angle, angle2);
            angle = latLon.getLatitude();
            angle2 = latLon.getLongitude();
        } else {
            uTMCoordConverter = new UTMCoordConverter(6378137.0, 0.0033528106647474805);
        }
        long l = uTMCoordConverter.convertGeodeticToUTM(angle.radians, angle2.radians);
        if (l != 0L) {
            String string3 = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return new UTMCoord(angle, angle2, uTMCoordConverter.getZone(), uTMCoordConverter.getHemisphere(), uTMCoordConverter.getEasting(), uTMCoordConverter.getNorthing(), Angle.fromRadians(uTMCoordConverter.getCentralMeridian()));
    }

    public static UTMCoord fromUTM(int n, String string, double d, double d2) {
        return UTMCoord.fromUTM(n, string, d, d2, null);
    }

    public static UTMCoord fromUTM(int n, String string, double d, double d2, Globe globe) {
        UTMCoordConverter uTMCoordConverter = new UTMCoordConverter(globe);
        long l = uTMCoordConverter.convertUTMToGeodetic(n, string, d, d2);
        if (l != 0L) {
            String string2 = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return new UTMCoord(Angle.fromRadians(uTMCoordConverter.getLatitude()), Angle.fromRadians(uTMCoordConverter.getLongitude()), n, string, d, d2, Angle.fromRadians(uTMCoordConverter.getCentralMeridian()));
    }

    public static LatLon locationFromUTMCoord(int n, String string, double d, double d2, Globe globe) {
        UTMCoord uTMCoord = UTMCoord.fromUTM(n, string, d, d2, globe);
        return new LatLon(uTMCoord.getLatitude(), uTMCoord.getLongitude());
    }

    public UTMCoord(Angle angle, Angle angle2, int n, String string, double d, double d2) {
        this(angle, angle2, n, string, d, d2, Angle.fromDegreesLongitude(0.0));
    }

    public UTMCoord(Angle angle, Angle angle2, int n, String string, double d, double d2, Angle angle3) {
        if (angle == null || angle2 == null) {
            String string2 = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.hemisphere = string;
        this.zone = n;
        this.easting = d;
        this.northing = d2;
        this.centralMeridian = angle3;
    }

    public Angle getCentralMeridian() {
        return this.centralMeridian;
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public int getZone() {
        return this.zone;
    }

    public String getHemisphere() {
        return this.hemisphere;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.zone);
        stringBuilder.append(" ").append("gov.nasa.worldwind.avkey.North".equals(this.hemisphere) ? "N" : "S");
        stringBuilder.append(" ").append(this.easting).append("E");
        stringBuilder.append(" ").append(this.northing).append("N");
        return stringBuilder.toString();
    }
}

