/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Quaternion;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;

public class Vec4 {
    public static final Vec4 INFINITY = new Vec4(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
    public static final Vec4 ZERO = new Vec4(0.0, 0.0, 0.0, 1.0);
    public static final Vec4 ONE = new Vec4(1.0, 1.0, 1.0, 1.0);
    public static final Vec4 UNIT_X = new Vec4(1.0, 0.0, 0.0, 0.0);
    public static final Vec4 UNIT_NEGATIVE_X = new Vec4(-1.0, 0.0, 0.0, 0.0);
    public static final Vec4 UNIT_Y = new Vec4(0.0, 1.0, 0.0, 0.0);
    public static final Vec4 UNIT_NEGATIVE_Y = new Vec4(0.0, -1.0, 0.0, 0.0);
    public static final Vec4 UNIT_Z = new Vec4(0.0, 0.0, 1.0, 0.0);
    public static final Vec4 UNIT_NEGATIVE_Z = new Vec4(0.0, 0.0, -1.0, 0.0);
    public static final Vec4 UNIT_W = new Vec4(0.0, 0.0, 0.0, 1.0);
    public static final Vec4 UNIT_NEGATIVE_W = new Vec4(0.0, 0.0, 0.0, -1.0);
    public final double x;
    public final double y;
    public final double z;
    public final double w;
    private static final double DEFAULT_W = 1.0;
    private int hashCode;

    public Vec4(double d) {
        this(d, d, d);
    }

    public Vec4(double d, double d2) {
        this(d, d2, 0.0, 1.0);
    }

    public Vec4(double d, double d2, double d3) {
        this(d, d2, d3, 1.0);
    }

    public Vec4(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Vec4 vec4 = (Vec4)object;
        return this.x == vec4.x && this.y == vec4.y && this.z == vec4.z && this.w == vec4.w;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            long l = Double.doubleToLongBits(this.x);
            int n = (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.y);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.z);
            n = 29 * n + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.w);
            this.hashCode = n = 29 * n + (int)(l ^ l >>> 32);
        }
        return this.hashCode;
    }

    public static Vec4 fromDoubleArray(double[] dArray, int n, int n2) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.OffsetIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.LengthIsInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 == 1) {
            return new Vec4(dArray[n], 0.0);
        }
        if (n2 == 2) {
            return new Vec4(dArray[n], dArray[n + 1]);
        }
        if (n2 == 3) {
            return new Vec4(dArray[n], dArray[n + 1], dArray[n + 2]);
        }
        return new Vec4(dArray[n], dArray[n + 1], dArray[n + 2], dArray[n + 3]);
    }

    public static Vec4 fromFloatArray(float[] fArray, int n, int n2) {
        if (fArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.OffsetIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.LengthIsInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 == 2) {
            return new Vec4(fArray[n], fArray[n + 1], 0.0);
        }
        if (n2 == 3) {
            return new Vec4(fArray[n], fArray[n + 1], fArray[n + 2]);
        }
        return new Vec4(fArray[n], fArray[n + 1], fArray[n + 2], fArray[n + 3]);
    }

    public static Vec4 fromArray2(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.fromDoubleArray(dArray, n, 2);
    }

    public static Vec4 fromArray3(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.fromDoubleArray(dArray, n, 3);
    }

    public static Vec4 fromArray4(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.fromDoubleArray(dArray, n, 4);
    }

    public final double[] toDoubleArray(double[] dArray, int n, int n2) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.OffsetIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.LengthIsInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", dArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        dArray[n] = this.x;
        if (n2 > 1) {
            dArray[n + 1] = this.y;
        }
        if (n2 > 2) {
            dArray[n + 2] = this.z;
        }
        if (n2 > 3) {
            dArray[n + 3] = this.w;
        }
        return dArray;
    }

    public final float[] toFloatArray(float[] fArray, int n, int n2) {
        if (fArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            String string = Logging.getMessage("generic.OffsetIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.LengthIsInvalid", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", fArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        fArray[n] = (float)this.x;
        fArray[n + 1] = (float)this.y;
        if (n2 > 2) {
            fArray[n + 2] = (float)this.z;
        }
        if (n2 > 3) {
            fArray[n + 3] = (float)this.w;
        }
        return fArray;
    }

    public final double[] toArray2(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.toDoubleArray(dArray, n, 2);
    }

    public final double[] toArray3(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.toDoubleArray(dArray, n, 3);
    }

    public final double[] toArray4(double[] dArray, int n) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.toDoubleArray(dArray, n, 4);
    }

    public Vec4 toHomogeneousPoint3() {
        if (this.w == 1.0) {
            return this;
        }
        return new Vec4(this.x, this.y, this.z, 1.0);
    }

    public Vec4 toHomogeneousDirection3() {
        if (this.w == 0.0) {
            return this;
        }
        return new Vec4(this.x, this.y, this.z, 0.0);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.x).append(", ");
        stringBuilder.append(this.y).append(", ");
        stringBuilder.append(this.z).append(", ");
        stringBuilder.append(this.w);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public final double w() {
        return this.w;
    }

    public static Vec4 fromLine3(Vec4 vec4, double d, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(vec4.x + vec42.x * d, vec4.y + vec42.y * d, vec4.z + vec42.z * d);
    }

    public final Vec4 add3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(this.x + vec4.x, this.y + vec4.y, this.z + vec4.z, this.w);
    }

    public final Vec4 add3(double d, double d2, double d3) {
        return new Vec4(this.x + d, this.y + d2, this.z + d3, this.w);
    }

    public final Vec4 subtract3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(this.x - vec4.x, this.y - vec4.y, this.z - vec4.z, this.w);
    }

    public final Vec4 subtract3(double d, double d2, double d3) {
        return new Vec4(this.x - d, this.y - d2, this.z - d3, this.w);
    }

    public final Vec4 multiply3(double d) {
        return new Vec4(this.x * d, this.y * d, this.z * d, this.w);
    }

    public final Vec4 multiply3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(this.x * vec4.x, this.y * vec4.y, this.z * vec4.z, this.w);
    }

    public final Vec4 divide3(double d) {
        if (d == 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(this.x / d, this.y / d, this.z / d, this.w);
    }

    public final Vec4 divide3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(this.x / vec4.x, this.y / vec4.y, this.z / vec4.z, this.w);
    }

    public final Vec4 getNegative3() {
        return new Vec4(0.0 - this.x, 0.0 - this.y, 0.0 - this.z, this.w);
    }

    public final Vec4 getAbs3() {
        return new Vec4(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public final double getLength3() {
        return Math.sqrt(this.getLengthSquared3());
    }

    public final double getLengthSquared3() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final Vec4 normalize3() {
        double d = this.getLength3();
        if (d == 0.0) {
            return this;
        }
        return new Vec4(this.x / d, this.y / d, this.z / d);
    }

    public final double distanceTo2(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = vec4.x - this.x;
        double d2 = vec4.y - this.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public final double distanceTo3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Math.sqrt(this.distanceToSquared3(vec4));
    }

    public final double distanceToSquared3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 0.0;
        double d2 = this.x - vec4.x;
        d += d2 * d2;
        d2 = this.y - vec4.y;
        d += d2 * d2;
        d2 = this.z - vec4.z;
        return d += d2 * d2;
    }

    public final double dot3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.x * vec4.x + this.y * vec4.y + this.z * vec4.z;
    }

    public final double dot4(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.x * vec4.x + this.y * vec4.y + this.z * vec4.z + this.w * vec4.w;
    }

    public final double dotSelf3() {
        return this.dot3(this);
    }

    public final double dotSelf4() {
        return this.dot4(this);
    }

    public final Vec4 cross3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(this.y * vec4.z - this.z * vec4.y, this.z * vec4.x - this.x * vec4.z, this.x * vec4.y - this.y * vec4.x);
    }

    public final Angle angleBetween3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.dot3(vec4);
        double d2 = this.getLength3() * vec4.getLength3();
        if (d2 != 0.0 && d2 != 1.0) {
            d /= d2;
        }
        if (d < -1.0) {
            d = -1.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        return Angle.fromRadians(Math.acos(d));
    }

    public static Angle axisAngle(Vec4 vec4, Vec4 vec42, Vec4[] vec4Array) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = vec4.normalize3();
        Vec4 vec44 = vec42.normalize3();
        Angle angle = Angle.fromRadians(Math.acos(vec44.x * vec43.x + vec44.y * vec43.y + vec44.z * vec43.z));
        double d = vec44.y * vec43.z - vec44.z * vec43.y;
        double d2 = vec44.z * vec43.x - vec44.x * vec43.z;
        double d3 = vec44.x * vec43.y - vec44.y * vec43.x;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        vec4Array[0] = new Vec4(d / d4, d2 / d4, d3 / d4);
        return angle;
    }

    public final Vec4 projectOnto3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.dot3(vec4);
        double d2 = vec4.getLength3();
        if (d2 != 0.0 && d2 != 1.0) {
            d /= d2 * d2;
        }
        return vec4.multiply3(d);
    }

    public final Vec4 perpendicularTo3(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.subtract3(this.projectOnto3(vec4));
    }

    public Vec4[] perpendicularVectors() {
        Vec4 vec4 = this;
        Vec4 vec42 = vec4.x <= vec4.y && vec4.x <= vec4.z ? UNIT_X : (vec4.y <= vec4.x && vec4.y <= vec4.z ? UNIT_Y : UNIT_Z);
        Vec4 vec43 = vec4.cross3(vec42).normalize3();
        Vec4 vec44 = vec4.cross3(vec43).normalize3();
        return new Vec4[]{vec43, vec44};
    }

    public final Vec4 transformBy3(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(matrix.m11 * this.x + matrix.m12 * this.y + matrix.m13 * this.z, matrix.m21 * this.x + matrix.m22 * this.y + matrix.m23 * this.z, matrix.m31 * this.x + matrix.m32 * this.y + matrix.m33 * this.z);
    }

    public final Vec4 transformBy3(Quaternion quaternion) {
        if (quaternion == null) {
            String string = Logging.getMessage("nullValue.QuaternionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Quaternion quaternion2 = new Quaternion(this.x, this.y, this.z, 0.0);
        quaternion2 = quaternion.multiply(quaternion2);
        quaternion2 = quaternion2.multiply(quaternion.getInverse());
        return new Vec4(quaternion2.x, quaternion2.y, quaternion2.z, 0.0);
    }

    public final Vec4 transformBy4(Matrix matrix) {
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(matrix.m11 * this.x + matrix.m12 * this.y + matrix.m13 * this.z + matrix.m14 * this.w, matrix.m21 * this.x + matrix.m22 * this.y + matrix.m23 * this.z + matrix.m24 * this.w, matrix.m31 * this.x + matrix.m32 * this.y + matrix.m33 * this.z + matrix.m34 * this.w, matrix.m41 * this.x + matrix.m42 * this.y + matrix.m43 * this.z + matrix.m44 * this.w);
    }

    public static Vec4 min3(Vec4 vec4, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(vec4.x < vec42.x ? vec4.x : vec42.x, vec4.y < vec42.y ? vec4.y : vec42.y, vec4.z < vec42.z ? vec4.z : vec42.z);
    }

    public static Vec4 max3(Vec4 vec4, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(vec4.x > vec42.x ? vec4.x : vec42.x, vec4.y > vec42.y ? vec4.y : vec42.y, vec4.z > vec42.z ? vec4.z : vec42.z);
    }

    public static Vec4 clamp3(Vec4 vec4, double d, double d2) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new Vec4(vec4.x < d ? d : (vec4.x > d2 ? d2 : vec4.x), vec4.y < d ? d : (vec4.y > d2 ? d2 : vec4.y), vec4.z < d ? d : (vec4.z > d2 ? d2 : vec4.z));
    }

    public static Vec4 mix3(double d, Vec4 vec4, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            return vec4;
        }
        if (d > 1.0) {
            return vec42;
        }
        double d2 = 1.0 - d;
        return new Vec4(vec4.x * d2 + vec42.x * d, vec4.y * d2 + vec42.y * d, vec4.z * d2 + vec42.z * d);
    }

    public static Vec4 computeAveragePoint(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (Vec4 vec4 : iterable) {
            if (vec4 == null) continue;
            ++n;
            d += vec4.x;
            d2 += vec4.y;
            d3 += vec4.z;
            d4 += vec4.w;
        }
        if (n == 0) {
            return null;
        }
        return new Vec4(d / (double)n, d2 / (double)n, d3 / (double)n, d4 / (double)n);
    }

    public static Vec4 computeAveragePoint3(BufferWrapper bufferWrapper, int n) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.CoordinatesAreNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3) {
            String string = Logging.getMessage("generic.StrideIsInvalid");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i <= bufferWrapper.length() - n; i += n) {
            ++n2;
            d += bufferWrapper.getDouble(i);
            d2 += bufferWrapper.getDouble(i + 1);
            d3 += bufferWrapper.getDouble(i + 2);
        }
        if (n2 == 0) {
            return null;
        }
        return new Vec4(d / (double)n2, d2 / (double)n2, d3 / (double)n2);
    }

    public static double getAverageDistance(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 0.0;
        int n = 0;
        for (Vec4 vec4 : iterable) {
            for (Vec4 vec42 : iterable) {
                if (vec4 == vec42) continue;
                double d2 = vec4.distanceTo3(vec42);
                d += d2;
                ++n;
            }
        }
        return n == 0 ? 0.0 : d / (double)n;
    }

    public static Vec4[] computeExtrema(Vec4[] vec4Array) {
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.PointsArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array.length == 0) {
            return null;
        }
        double d = vec4Array[0].x;
        double d2 = vec4Array[0].y;
        double d3 = vec4Array[0].z;
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        for (int i = 1; i < vec4Array.length; ++i) {
            double d7 = vec4Array[i].x;
            if (d7 > d4) {
                d4 = d7;
            } else if (d7 < d) {
                d = d7;
            }
            double d8 = vec4Array[i].y;
            if (d8 > d5) {
                d5 = d8;
            } else if (d8 < d2) {
                d2 = d8;
            }
            double d9 = vec4Array[i].z;
            if (d9 > d6) {
                d6 = d9;
                continue;
            }
            if (!(d9 < d3)) continue;
            d3 = d9;
        }
        return new Vec4[]{new Vec4(d, d2, d3), new Vec4(d4, d5, d6)};
    }

    public static Vec4[] computeExtrema(BufferWrapper bufferWrapper) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferWrapper.getBackingBuffer().position() > bufferWrapper.getBackingBuffer().limit() - 3) {
            return null;
        }
        double d = bufferWrapper.getDouble(0);
        double d2 = bufferWrapper.getDouble(1);
        double d3 = bufferWrapper.getDouble(2);
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        for (int i = 1; i < bufferWrapper.length() / 3; ++i) {
            double d7 = bufferWrapper.getDouble(i * 3);
            if (d7 > d4) {
                d4 = d7;
            } else if (d7 < d) {
                d = d7;
            }
            double d8 = bufferWrapper.getDouble(i * 3 + 1);
            if (d8 > d5) {
                d5 = d8;
            } else if (d8 < d2) {
                d2 = d8;
            }
            double d9 = bufferWrapper.getDouble(i * 3 + 2);
            if (d9 > d6) {
                d6 = d9;
                continue;
            }
            if (!(d9 < d3)) continue;
            d3 = d9;
        }
        return new Vec4[]{new Vec4(d, d2, d3), new Vec4(d4, d5, d6)};
    }

    public static boolean areColinear(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44;
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec45 = vec42.subtract3(vec4).normalize3();
        return Math.abs(vec45.dot3(vec44 = vec43.subtract3(vec42).normalize3())) > 0.999;
    }
}

