/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public final class Line {
    private final Vec4 origin;
    private final Vec4 direction;

    public static Line fromSegment(Vec4 vec4, Vec4 vec42) {
        return new Line(vec4, new Vec4(vec42.x - vec4.x, vec42.y - vec4.y, vec42.z - vec4.z, 0.0));
    }

    public Line(Vec4 vec4, Vec4 vec42) {
        String string = null;
        if (vec4 == null) {
            string = "nullValue.OriginIsNull";
        } else if (vec42 == null) {
            string = "nullValue.DirectionIsNull";
        } else if (vec42.getLength3() <= 0.0) {
            string = "Geom.Line.DirectionIsZeroVector";
        }
        if (string != null) {
            string = Logging.getMessage(string);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.origin = vec4;
        this.direction = vec42;
    }

    public final Vec4 getDirection() {
        return this.direction;
    }

    public final Vec4 getOrigin() {
        return this.origin;
    }

    public final Vec4 getPointAt(double d) {
        return Vec4.fromLine3(this.origin, d, this.direction);
    }

    public final double selfDot() {
        return this.origin.dot3(this.direction);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Line line = (Line)object;
        if (!this.direction.equals(line.direction)) {
            return false;
        }
        return line.origin.equals(this.origin);
    }

    public final int hashCode() {
        int n = this.origin.hashCode();
        n = 29 * n + this.direction.hashCode();
        return n;
    }

    public String toString() {
        return "Origin: " + this.origin + ", Direction: " + this.direction;
    }

    public final Vec4 nearestPointTo(Vec4 vec4) {
        Vec4 vec42 = vec4.subtract3(this.origin);
        double d = vec42.dot3(this.direction);
        double d2 = this.direction.dot3(this.direction);
        return this.origin.add3(this.direction.multiply3(d / d2));
    }

    public final double distanceTo(Vec4 vec4) {
        return vec4.distanceTo3(this.nearestPointTo(vec4));
    }

    public static Vec4 nearestPointOnSegment(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec43.subtract3(vec4);
        double d = vec45.dot3(vec44);
        double d2 = vec44.dot3(vec44);
        if (d <= 0.0) {
            return vec4;
        }
        if (d2 <= d) {
            return vec42;
        }
        return vec4.add3(vec44.multiply3(d / d2));
    }

    public static double distanceToSegment(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        Vec4 vec44 = Line.nearestPointOnSegment(vec4, vec42, vec43);
        return vec43.distanceTo3(vec44);
    }

    public static Vec4[] clipToFrustum(Vec4 vec4, Vec4 vec42, Frustum frustum) {
        return Line.clipToFrustum(vec4, vec42, frustum, 1);
    }

    private static Vec4[] clipToFrustum(Vec4 vec4, Vec4 vec42, Frustum frustum, int n) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (frustum.contains(vec4) && frustum.contains(vec42)) {
            return new Vec4[]{vec4, vec42};
        }
        Vec4[] vec4Array = new Vec4[]{vec4, vec42};
        for (Plane plane : frustum.getAllPlanes()) {
            if (plane.onSameSide(vec4Array[0], vec4Array[1]) < 0) {
                return null;
            }
            Vec4[] vec4Array2 = plane.clip(vec4Array[0], vec4Array[1]);
            if (vec4Array2 == null) continue;
            vec4Array = vec4Array2;
        }
        if (frustum.contains(vec4) || frustum.contains(vec42)) {
            return vec4Array;
        }
        if (n > 0) {
            return Line.clipToFrustum(vec4Array[0], vec4Array[1], frustum, --n);
        }
        return vec4Array;
    }

    public boolean isPointBehindLineOrigin(Vec4 vec4) {
        double d = vec4.subtract3(this.getOrigin()).dot3(this.getDirection());
        return d < 0.0;
    }

    public Vec4 nearestIntersectionPoint(Intersection[] intersectionArray) {
        Vec4 vec4 = null;
        double d = Double.MAX_VALUE;
        for (Intersection intersection : intersectionArray) {
            double d2;
            if (this.isPointBehindLineOrigin(intersection.getIntersectionPoint()) || !((d2 = intersection.getIntersectionPoint().distanceTo3(this.getOrigin())) < d)) continue;
            vec4 = intersection.getIntersectionPoint();
            d = d2;
        }
        return vec4;
    }
}

