/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLUquadric;

public class Cylinder
implements Extent,
Renderable {
    protected final Vec4 bottomCenter;
    protected final Vec4 topCenter;
    protected final Vec4 axisUnitDirection;
    protected final double cylinderRadius;
    protected final double cylinderHeight;

    public Cylinder(Vec4 vec4, Vec4 vec42, double d) {
        if (vec4 == null || vec42 == null || vec4.equals(vec42)) {
            String string = Logging.getMessage(vec4 == null || vec42 == null ? "nullValue.EndPointIsNull" : "generic.EndPointsCoincident");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.Cylinder.RadiusIsZeroOrNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bottomCenter = vec4.toHomogeneousPoint3();
        this.topCenter = vec42.toHomogeneousPoint3();
        this.cylinderHeight = this.bottomCenter.distanceTo3(this.topCenter);
        this.cylinderRadius = d;
        this.axisUnitDirection = this.topCenter.subtract3(this.bottomCenter).normalize3();
    }

    public Cylinder(Vec4 vec4, Vec4 vec42, double d, Vec4 vec43) {
        if (vec4 == null || vec42 == null || vec4.equals(vec42)) {
            String string = Logging.getMessage(vec4 == null || vec42 == null ? "nullValue.EndPointIsNull" : "generic.EndPointsCoincident");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Geom.Cylinder.RadiusIsZeroOrNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.bottomCenter = vec4.toHomogeneousPoint3();
        this.topCenter = vec42.toHomogeneousPoint3();
        this.cylinderHeight = this.bottomCenter.distanceTo3(this.topCenter);
        this.cylinderRadius = d;
        this.axisUnitDirection = vec43;
    }

    public Vec4 getAxisUnitDirection() {
        return this.axisUnitDirection;
    }

    public Vec4 getBottomCenter() {
        return this.bottomCenter;
    }

    public Vec4 getTopCenter() {
        return this.topCenter;
    }

    public double getCylinderRadius() {
        return this.cylinderRadius;
    }

    public double getCylinderHeight() {
        return this.cylinderHeight;
    }

    @Override
    public Vec4 getCenter() {
        Vec4 vec4 = this.bottomCenter;
        Vec4 vec42 = this.topCenter;
        return new Vec4((vec4.x + vec42.x) / 2.0, (vec4.y + vec42.y) / 2.0, (vec4.z + vec42.z) / 2.0);
    }

    @Override
    public double getDiameter() {
        return 2.0 * this.getRadius();
    }

    @Override
    public double getRadius() {
        double d = this.bottomCenter.distanceTo3(this.topCenter) / 2.0;
        return Math.sqrt(d * d + this.cylinderRadius * this.cylinderRadius);
    }

    public double getVolume() {
        return Math.PI * this.cylinderRadius * this.cylinderRadius * this.cylinderHeight;
    }

    public static Cylinder computeBoundingCylinder(Iterable<? extends Vec4> iterable) {
        Vec4 vec45;
        double d;
        Object object;
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = WWMath.computePrincipalAxes(iterable);
        if (vec4Array == null) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec42 = vec4Array[0];
        Vec4 vec43 = vec4Array[1];
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        double d2 = Double.MAX_VALUE;
        double d3 = -d2;
        Object object2 = iterable.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            d = ((Vec4)object).dot3(vec42);
            arrayList.add(((Vec4)object).subtract3(vec42.multiply3(((Vec4)object).dot3(vec42))));
            if (d < d2) {
                d2 = d;
            }
            if (!(d > d3)) continue;
            d3 = d;
        }
        object = object2 = (Vec4)arrayList.get(0);
        d = Double.MAX_VALUE;
        double d4 = -d;
        for (Vec4 vec44 : arrayList) {
            double d5 = vec44.dot3(vec43);
            if (d5 < d) {
                object2 = vec44;
                d = d5;
            }
            if (!(d5 > d4)) continue;
            object = vec44;
            d4 = d5;
        }
        Object object3 = ((Vec4)object2).add3((Vec4)object).divide3(2.0);
        double d6 = ((Vec4)object3).distanceTo3((Vec4)object2);
        for (Vec4 vec45 : arrayList) {
            Vec4 vec46 = vec45.subtract3((Vec4)object3);
            double d7 = vec46.getLength3();
            if (!(d7 > d6)) continue;
            Vec4 vec47 = ((Vec4)object3).subtract3(vec46.normalize3().multiply3(d6));
            object3 = vec47.add3(vec45).divide3(2.0);
            d6 = d7;
        }
        Vec4 vec48 = ((Vec4)object3).add3(vec42.multiply3(d2));
        vec45 = ((Vec4)object3).add3(vec42.multiply3(d3));
        if (d6 == 0.0) {
            d6 = 1.0;
        }
        if (vec48.equals(vec45)) {
            vec45 = vec48.add3(new Vec4(1.0, 0.0, 0.0));
        }
        return new Cylinder(vec48, vec45, d6);
    }

    @Override
    public Intersection[] intersect(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        if (!this.intcyl(line.getOrigin(), line.getDirection(), this.bottomCenter, this.axisUnitDirection, this.cylinderRadius, dArray)) {
            return null;
        }
        if (!this.clipcyl(line.getOrigin(), line.getDirection(), this.bottomCenter, this.topCenter, this.axisUnitDirection, dArray)) {
            return null;
        }
        if (!Double.isInfinite(dArray[0]) && !Double.isInfinite(dArray[1]) && dArray[0] >= 0.0 && dArray[1] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(dArray[0]), false), new Intersection(line.getPointAt(dArray[1]), false)};
        }
        if (!Double.isInfinite(dArray[0]) && dArray[0] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(dArray[0]), false)};
        }
        if (!Double.isInfinite(dArray[1]) && dArray[1] >= 0.0) {
            return new Intersection[]{new Intersection(line.getPointAt(dArray[1]), false)};
        }
        return null;
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.intersect(line) != null;
    }

    protected boolean intcyl(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, double d, double[] dArray) {
        boolean bl;
        Vec4 vec45 = vec4.subtract3(vec43);
        Vec4 vec46 = vec42.cross3(vec44);
        double d2 = vec46.getLength3();
        if (d2 == 0.0) {
            double d3 = vec45.dot3(vec44);
            Vec4 vec47 = vec45.subtract3(vec44.multiply3(d3));
            d3 = vec47.getLength3();
            dArray[0] = Double.NEGATIVE_INFINITY;
            dArray[1] = Double.POSITIVE_INFINITY;
            return d3 <= d;
        }
        double d4 = Math.abs(vec45.dot3(vec46 = vec46.normalize3()));
        boolean bl2 = bl = d4 <= d;
        if (bl) {
            Vec4 vec48 = vec45.cross3(vec44);
            double d5 = -vec48.dot3(vec46) / d2;
            vec48 = vec46.cross3(vec44);
            vec48 = vec48.normalize3();
            double d6 = Math.abs(Math.sqrt(d * d - d4 * d4) / vec42.dot3(vec48));
            dArray[0] = d5 - d6;
            dArray[1] = d5 + d6;
        }
        return bl;
    }

    protected boolean clipcyl(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, Vec4 vec45, double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = vec45.dot3(vec42);
        double d4 = vec45.dot3(vec4) - vec45.dot3(vec43);
        double d5 = vec45.dot3(vec4) - vec45.dot3(vec44);
        if (d3 == 0.0) {
            if (d4 <= 0.0) {
                return false;
            }
            if (d5 >= 0.0) {
                return false;
            }
        } else {
            double d6 = -d4 / d3;
            double d7 = -d5 / d3;
            if (d3 >= 0.0) {
                if (d6 > d2) {
                    return false;
                }
                if (d7 < d) {
                    return false;
                }
                if (d6 > d && d6 < d2) {
                    d = d6;
                }
                if (d7 > d && d7 < d2) {
                    d2 = d7;
                }
            } else {
                if (d6 < d) {
                    return false;
                }
                if (d7 > d2) {
                    return false;
                }
                if (d6 > d && d6 < d2) {
                    d2 = d6;
                }
                if (d7 > d && d7 < d2) {
                    d = d7;
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
        return d < d2;
    }

    protected double intersects(Plane plane, double d) {
        boolean bl;
        double d2 = plane.dot(this.bottomCenter);
        boolean bl2 = d2 <= -d;
        double d3 = plane.dot(this.topCenter);
        boolean bl3 = bl = d3 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return 0.0;
        }
        return 1.0;
    }

    protected double intersectsAt(Plane plane, double d, Vec4[] vec4Array) {
        boolean bl;
        double d2 = plane.dot(vec4Array[0]);
        boolean bl2 = d2 <= -d;
        double d3 = plane.dot(vec4Array[1]);
        boolean bl3 = bl = d3 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return 0.0;
        }
        double d4 = (d + d2) / plane.getNormal().dot3(vec4Array[0].subtract3(vec4Array[1]));
        Vec4 vec4 = vec4Array[0].add3(vec4Array[1].subtract3(vec4Array[0]).multiply3(d4));
        if (bl2) {
            vec4Array[0] = vec4;
        } else {
            vec4Array[1] = vec4;
        }
        return d4;
    }

    @Override
    public double getEffectiveRadius(Plane plane) {
        if (plane == null) {
            return 0.0;
        }
        double d = plane.getNormal().dot3(this.axisUnitDirection);
        double d2 = 1.0 - d * d;
        if (d2 <= 0.0) {
            return 0.0;
        }
        return this.cylinderRadius * Math.sqrt(d2);
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(plane);
        return this.intersects(plane, d) >= 0.0;
    }

    @Override
    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = new Vec4[]{this.bottomCenter, this.topCenter};
        double d = this.getEffectiveRadius(frustum.getNear());
        double d2 = this.intersectsAt(frustum.getNear(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d2 = this.intersectsAt(frustum.getFar(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getLeft());
        d2 = this.intersectsAt(frustum.getLeft(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getRight());
        d2 = this.intersectsAt(frustum.getRight(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getTop());
        d2 = this.intersectsAt(frustum.getTop(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius(frustum.getBottom());
        d2 = this.intersectsAt(frustum.getBottom(), d, vec4Array);
        return d2 >= 0.0;
    }

    @Override
    public double getProjectedArea(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWMath.computeSphereProjectedArea(view, this.getCenter(), this.getRadius());
    }

    public static Cylinder computeVerticalBoundingCylinder(Globe globe, double d, Sector sector) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = globe.getMinAndMaxElevations(sector);
        return Cylinder.computeVerticalBoundingCylinder(globe, d, sector, dArray[0], dArray[1]);
    }

    public static Cylinder computeVerticalBoundingCylinder(Globe globe, double d, Sector sector, double d2, double d3) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d4 = d2 * d;
        double d5 = d3 * d;
        if (d4 == d5) {
            d5 = d4 + 1.0;
        }
        if (sector.getDeltaLatDegrees() >= 180.0 || sector.getDeltaLonDegrees() >= 180.0) {
            return Cylinder.computeVerticalBoundsFromSectorLatitudeRange(globe, sector, d4, d5);
        }
        return Cylinder.computeVerticalBoundsFromSectorQuadrilateral(globe, sector, d4, d5);
    }

    protected static Cylinder computeVerticalBoundsFromSectorLatitudeRange(Globe globe, Sector sector, double d, double d2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = Vec4.ZERO;
        Vec4 vec42 = Vec4.UNIT_Y;
        double d3 = globe.getEquatorialRadius() + d2;
        Vec4 vec43 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
        double d4 = vec43.subtract3(vec4).dot3(vec42);
        vec43 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2);
        double d5 = vec43.subtract3(vec4).dot3(vec42);
        Vec4 vec44 = vec42.multiply3(d4).add3(vec4);
        Vec4 vec45 = vec42.multiply3(d5).add3(vec4);
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        if (vec44.equals(vec45)) {
            vec45 = vec44.add3(new Vec4(1.0, 0.0, 0.0));
        }
        return new Cylinder(vec44, vec45, d3);
    }

    protected static Cylinder computeVerticalBoundsFromSectorQuadrilateral(Globe globe, Sector sector, double d, double d2) {
        Vec4 vec4;
        Vec4 vec42;
        Vec4 vec43;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (Math.abs(sector.getMinLatitude().degrees) <= Math.abs(sector.getMaxLatitude().degrees)) {
            vec43 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d2);
            vec42 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
            vec4 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2);
        } else {
            vec43 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2);
            vec42 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2);
            vec4 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
        }
        Vec4[] vec4Array = new Vec4[1];
        Vec4[] vec4Array2 = new Vec4[1];
        double[] dArray = new double[1];
        if (!WWMath.computeCircleThroughPoints(vec43, vec42, vec4, vec4Array, vec4Array2, dArray)) {
            return Cylinder.computeVerticalBoundsFromSectorVertices(globe, sector, d, d2);
        }
        Vec4 vec44 = vec4Array[0];
        Vec4 vec45 = vec4Array2[0];
        double d3 = dArray[0];
        Vec4 vec46 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d);
        double d4 = vec46.subtract3(vec44).dot3(vec45);
        vec46 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d);
        d4 = Math.min(d4, vec46.subtract3(vec44).dot3(vec45));
        LatLon latLon = sector.getCentroid();
        vec46 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2);
        double d5 = vec46.subtract3(vec44).dot3(vec45);
        Vec4 vec47 = vec45.multiply3(d4).add3(vec44);
        Vec4 vec48 = vec45.multiply3(d5).add3(vec44);
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        if (vec47.equals(vec48)) {
            vec48 = vec47.add3(new Vec4(1.0, 0.0, 0.0));
        }
        return new Cylinder(vec47, vec48, d3);
    }

    protected static Cylinder computeVerticalBoundsFromSectorVertices(Globe globe, Sector sector, double d, double d2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        Vec4 vec4 = globe.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2);
        Vec4 vec42 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec43 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d);
        Vec4 vec44 = globe.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d);
        Vec4 vec45 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d);
        Vec4 vec46 = globe.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d);
        double d3 = vec43.subtract3(vec4).dot3(vec42);
        d3 = Math.min(d3, vec44.subtract3(vec4).dot3(vec42));
        d3 = Math.min(d3, vec45.subtract3(vec4).dot3(vec42));
        d3 = Math.min(d3, vec46.subtract3(vec4).dot3(vec42));
        Vec4 vec47 = vec42.multiply3(d3).add3(vec4);
        double d4 = vec4.distanceTo3(vec43);
        d4 = Math.max(d4, vec4.distanceTo3(vec44));
        d4 = Math.max(d4, vec4.distanceTo3(vec45));
        if ((d4 = Math.max(d4, vec4.distanceTo3(vec46))) == 0.0) {
            d4 = 1.0;
        }
        if (vec47.equals(vec4)) {
            vec4 = vec47.add3(new Vec4(1.0, 0.0, 0.0));
        }
        return new Cylinder(vec47, vec4, d4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 1.0E-6;
        Vec4 vec4 = this.axisUnitDirection.cross3(Vec4.UNIT_Y).getLength3() <= d ? Vec4.UNIT_NEGATIVE_Z : Vec4.UNIT_Y;
        Matrix matrix = Matrix.fromModelLookAt(this.bottomCenter, this.topCenter, vec4);
        double[] dArray = new double[16];
        matrix.toArray(dArray, 0, false);
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 12545);
        try {
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
            gL2.glEnable(2929);
            gL2.glDepthFunc(515);
            gL2.glColor4f(1.0f, 1.0f, 1.0f, 0.4f);
            gL2.glBegin(1);
            gL2.glVertex3d(this.bottomCenter.x, this.bottomCenter.y, this.bottomCenter.z);
            gL2.glVertex3d(this.topCenter.x, this.topCenter.y, this.topCenter.z);
            gL2.glEnd();
            gL2.glDepthFunc(516);
            gL2.glColor4f(1.0f, 0.0f, 1.0f, 0.4f);
            gL2.glBegin(1);
            gL2.glVertex3d(this.bottomCenter.x, this.bottomCenter.y, this.bottomCenter.z);
            gL2.glVertex3d(this.topCenter.x, this.topCenter.y, this.topCenter.z);
            gL2.glEnd();
            oGLStackHandler.pushModelview(gL2);
            gL2.glMultMatrixd(dArray, 0);
            GLUquadric gLUquadric = drawContext.getGLU().gluNewQuadric();
            drawContext.getGLU().gluQuadricDrawStyle(gLUquadric, 100011);
            gL2.glDepthFunc(515);
            gL2.glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
            drawContext.getGLU().gluCylinder(gLUquadric, this.cylinderRadius, this.cylinderRadius, this.cylinderHeight, 30, 30);
            gL2.glDepthFunc(516);
            gL2.glColor4f(1.0f, 0.0f, 1.0f, 0.4f);
            drawContext.getGLU().gluCylinder(gLUquadric, this.cylinderRadius, this.cylinderRadius, this.cylinderHeight, 30, 30);
            drawContext.getGLU().gluDeleteQuadric(gLUquadric);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Cylinder)) {
            return false;
        }
        Cylinder cylinder = (Cylinder)object;
        if (Double.compare(cylinder.cylinderHeight, this.cylinderHeight) != 0) {
            return false;
        }
        if (Double.compare(cylinder.cylinderRadius, this.cylinderRadius) != 0) {
            return false;
        }
        if (this.axisUnitDirection != null ? !this.axisUnitDirection.equals(cylinder.axisUnitDirection) : cylinder.axisUnitDirection != null) {
            return false;
        }
        if (this.bottomCenter != null ? !this.bottomCenter.equals(cylinder.bottomCenter) : cylinder.bottomCenter != null) {
            return false;
        }
        return !(this.topCenter != null ? !this.topCenter.equals(cylinder.topCenter) : cylinder.topCenter != null);
    }

    public int hashCode() {
        int n = this.bottomCenter != null ? this.bottomCenter.hashCode() : 0;
        n = 31 * n + (this.topCenter != null ? this.topCenter.hashCode() : 0);
        n = 31 * n + (this.axisUnitDirection != null ? this.axisUnitDirection.hashCode() : 0);
        long l = this.cylinderRadius != 0.0 ? Double.doubleToLongBits(this.cylinderRadius) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.cylinderHeight != 0.0 ? Double.doubleToLongBits(this.cylinderHeight) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        return this.cylinderRadius + ", " + this.bottomCenter.toString() + ", " + this.topCenter.toString() + ", " + this.axisUnitDirection.toString();
    }
}

