/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClassFactory;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClassSchema;
import gov.nasa.worldwind.formats.vpf.VPFFeatureFactory;
import gov.nasa.worldwind.formats.vpf.VPFRelation;
import gov.nasa.worldwind.formats.vpf.VPFSymbol;
import gov.nasa.worldwind.formats.vpf.VPFSymbolFactory;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Collection;

public class VPFBasicFeatureClassFactory
implements VPFFeatureClassFactory {
    @Override
    public VPFFeatureClass createFromSchema(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        if (vPFCoverage == null) {
            String string = Logging.getMessage("nullValue.CoverageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vPFFeatureClassSchema == null) {
            String string = Logging.getMessage("nullValue.SchemaIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            return this.doCreateFromSchema(vPFCoverage, vPFFeatureClassSchema);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionWhileReading", vPFCoverage.getFilePath() + File.separator + vPFFeatureClassSchema.getClassName());
            throw new WWRuntimeException(string, exception);
        }
    }

    protected VPFFeatureClass doCreateFromSchema(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) throws IOException {
        VPFFeatureClass vPFFeatureClass = this.doCreateFeatureClass(vPFCoverage, vPFFeatureClassSchema);
        if (vPFFeatureClass != null) {
            return vPFFeatureClass;
        }
        vPFFeatureClass = this.doCreateFromFeatureType(vPFCoverage, vPFFeatureClassSchema);
        this.initFeatureClass(vPFFeatureClass);
        return vPFFeatureClass;
    }

    protected VPFFeatureClass doCreateFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return null;
    }

    protected VPFFeatureClass doCreateFromFeatureType(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        switch (vPFFeatureClassSchema.getType()) {
            case POINT: {
                return this.createPointFeatureClass(vPFCoverage, vPFFeatureClassSchema);
            }
            case LINE: {
                return this.createLineFeatureClass(vPFCoverage, vPFFeatureClassSchema);
            }
            case AREA: {
                return this.createAreaFeatureClass(vPFCoverage, vPFFeatureClassSchema);
            }
            case TEXT: {
                return this.createTextFeatureClass(vPFCoverage, vPFFeatureClassSchema);
            }
            case COMPLEX: {
                return this.createComplexFeatureClass(vPFCoverage, vPFFeatureClassSchema);
            }
        }
        return this.createUnknownFeatureClass(vPFCoverage, vPFFeatureClassSchema);
    }

    protected void initFeatureClass(VPFFeatureClass vPFFeatureClass) {
        VPFRelation[] vPFRelationArray = vPFFeatureClass.getCoverage().getFeatureClassRelations(vPFFeatureClass.getClassName());
        if (vPFRelationArray != null) {
            vPFFeatureClass.setRelations(vPFRelationArray);
        }
    }

    protected VPFFeatureClass createPointFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return new VPFFeatureClass(vPFCoverage, vPFFeatureClassSchema, this.getJoinTableName(vPFCoverage, vPFFeatureClassSchema, ".pjt"), this.getPointFeaturePrimitiveTable(vPFCoverage, vPFFeatureClassSchema)){

            @Override
            public Collection<? extends VPFFeature> createFeatures(VPFFeatureFactory vPFFeatureFactory) {
                return vPFFeatureFactory.createPointFeatures(this);
            }

            @Override
            public Collection<? extends VPFSymbol> createFeatureSymbols(VPFSymbolFactory vPFSymbolFactory) {
                return vPFSymbolFactory.createPointSymbols(this);
            }
        };
    }

    protected VPFFeatureClass createLineFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return new VPFFeatureClass(vPFCoverage, vPFFeatureClassSchema, this.getJoinTableName(vPFCoverage, vPFFeatureClassSchema, ".ljt"), "edg"){

            @Override
            public Collection<? extends VPFFeature> createFeatures(VPFFeatureFactory vPFFeatureFactory) {
                return vPFFeatureFactory.createLineFeatures(this);
            }

            @Override
            public Collection<? extends VPFSymbol> createFeatureSymbols(VPFSymbolFactory vPFSymbolFactory) {
                return vPFSymbolFactory.createLineSymbols(this);
            }
        };
    }

    protected VPFFeatureClass createAreaFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return new VPFFeatureClass(vPFCoverage, vPFFeatureClassSchema, this.getJoinTableName(vPFCoverage, vPFFeatureClassSchema, ".ajt"), "fac"){

            @Override
            public Collection<? extends VPFFeature> createFeatures(VPFFeatureFactory vPFFeatureFactory) {
                return vPFFeatureFactory.createAreaFeatures(this);
            }

            @Override
            public Collection<? extends VPFSymbol> createFeatureSymbols(VPFSymbolFactory vPFSymbolFactory) {
                return vPFSymbolFactory.createAreaSymbols(this);
            }
        };
    }

    protected VPFFeatureClass createTextFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return new VPFFeatureClass(vPFCoverage, vPFFeatureClassSchema, this.getJoinTableName(vPFCoverage, vPFFeatureClassSchema, ".tjt"), "txt"){

            @Override
            public Collection<? extends VPFFeature> createFeatures(VPFFeatureFactory vPFFeatureFactory) {
                return vPFFeatureFactory.createTextFeatures(this);
            }

            @Override
            public Collection<? extends VPFSymbol> createFeatureSymbols(VPFSymbolFactory vPFSymbolFactory) {
                return vPFSymbolFactory.createTextSymbols(this);
            }
        };
    }

    protected VPFFeatureClass createComplexFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return new VPFFeatureClass(vPFCoverage, vPFFeatureClassSchema, this.getJoinTableName(vPFCoverage, vPFFeatureClassSchema, ".tjt"), null){

            @Override
            public Collection<? extends VPFFeature> createFeatures(VPFFeatureFactory vPFFeatureFactory) {
                return vPFFeatureFactory.createComplexFeatures(this);
            }

            @Override
            public Collection<? extends VPFSymbol> createFeatureSymbols(VPFSymbolFactory vPFSymbolFactory) {
                return vPFSymbolFactory.createComplexSymbols(this);
            }
        };
    }

    protected VPFFeatureClass createUnknownFeatureClass(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        return new VPFFeatureClass(vPFCoverage, vPFFeatureClassSchema, null, null);
    }

    protected String getJoinTableName(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(vPFFeatureClassSchema.getClassName());
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        File file = new File(vPFCoverage.getFilePath(), string2);
        return file.exists() ? string2 : null;
    }

    protected String getPointFeaturePrimitiveTable(VPFCoverage vPFCoverage, VPFFeatureClassSchema vPFFeatureClassSchema) {
        String string = null;
        VPFRelation[] vPFRelationArray = vPFCoverage.getFeatureClassRelations(vPFFeatureClassSchema.getClassName());
        if (vPFRelationArray != null) {
            for (VPFRelation vPFRelation : vPFRelationArray) {
                if (vPFRelation.getTable2().equalsIgnoreCase("nod")) {
                    string = "nod";
                } else if (vPFRelation.getTable2().equalsIgnoreCase("end")) {
                    string = "end";
                } else if (vPFRelation.getTable2().equalsIgnoreCase("cnd")) {
                    string = "cnd";
                }
                if (string != null) break;
            }
        }
        return string;
    }
}

