/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.formats.gpx.ElementParser;
import gov.nasa.worldwind.formats.gpx.GpxTrackSegment;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GpxTrack
extends ElementParser
implements Track {
    private String name;
    private int numPoints = -1;
    private List<TrackSegment> segments = new ArrayList<TrackSegment>();

    public GpxTrack(String string, String string2, String string3, Attributes attributes) {
        super("trk");
    }

    @Override
    public List<TrackSegment> getSegments() {
        return this.segments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumPoints() {
        if (this.segments == null) {
            return 0;
        }
        if (this.numPoints >= 0) {
            return this.numPoints;
        }
        this.numPoints = 0;
        for (TrackSegment trackSegment : this.segments) {
            for (TrackPoint trackPoint : trackSegment.getPoints()) {
                ++this.numPoints;
            }
        }
        return this.numPoints;
    }

    @Override
    public void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string3 == null) {
            String string5 = Logging.getMessage("nullValue.QNameIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string == null) {
            String string6 = Logging.getMessage("nullValue.URIIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (attributes == null) {
            String string7 = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (string2.equalsIgnoreCase("trkSeg")) {
            this.currentElement = new GpxTrackSegment(string, string2, string3, attributes);
            this.segments.add((TrackSegment)((Object)this.currentElement));
        }
    }

    @Override
    public void doEndElement(String string, String string2, String string3) throws SAXException {
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2.equalsIgnoreCase("name")) {
            this.name = this.currentCharacters;
        }
    }
}

