/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.GDALDataRaster;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.gdal.GDALUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class GDALDataRasterReader
extends AbstractDataRasterReader {
    protected static final String[] mimeTypes = new String[]{"image/jp2", "image/jpeg2000", "image/jpeg2000-image", "image/x-jpeg2000-image", "image/x-mrsid-image", "image/jpeg", "image/png", "image/bmp", "image/tif"};
    protected static final String[] suffixes = new String[]{"jp2", "sid", "ntf", "nitf", "JP2", "SID", "NTF", "NITF", "jpg", "jpe", "jpeg", "png", "bmp", "TIF", "TIFF", "GTIF", "GTIFF", "tif", "tiff", "gtif", "gtiff", "dt0", "dt1", "dt2", "asc", "adf", "dem"};

    public GDALDataRasterReader() {
        super("GDAL-based Data Raster Reader", mimeTypes, suffixes);
    }

    @Override
    public boolean canRead(Object object, AVList aVList) {
        return this.doCanRead(object, aVList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        if (WWUtil.isEmpty(object)) {
            return false;
        }
        if (null == aVList) {
            File file = WWIO.getFileForLocalAddress(object);
            if (null == file) {
                return false;
            }
            return GDALUtils.canOpen(file);
        }
        boolean bl = false;
        GDALDataRaster gDALDataRaster = null;
        try {
            gDALDataRaster = new GDALDataRaster(object, true);
            aVList.setValues(gDALDataRaster.getMetadata());
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        finally {
            if (null != gDALDataRaster) {
                gDALDataRaster.dispose();
                gDALDataRaster = null;
            }
        }
        return bl;
    }

    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        DataRaster[] dataRasterArray;
        GDALDataRaster gDALDataRaster = this.readDataRaster(object, false);
        if (null != gDALDataRaster && null != aVList) {
            aVList.setValues(gDALDataRaster.getMetadata());
            WWUtil.copyValues(aVList, gDALDataRaster, new String[]{"gov.nasa.worldwind.avKey.Sector"}, false);
        }
        if (null == gDALDataRaster) {
            dataRasterArray = null;
        } else {
            DataRaster[] dataRasterArray2 = new DataRaster[1];
            dataRasterArray = dataRasterArray2;
            dataRasterArray2[0] = gDALDataRaster;
        }
        return dataRasterArray;
    }

    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        GDALDataRaster gDALDataRaster = this.readDataRaster(object, true);
        if (null != gDALDataRaster && null != aVList) {
            aVList.setValues(gDALDataRaster.getMetadata());
            WWUtil.copyValues(aVList, gDALDataRaster, new String[]{"gov.nasa.worldwind.avKey.Sector"}, false);
            gDALDataRaster.dispose();
        }
    }

    protected GDALDataRaster readDataRaster(Object object, boolean bl) throws IOException {
        if (null == object) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            GDALDataRaster gDALDataRaster = new GDALDataRaster(object, bl);
            if (null == gDALDataRaster) {
                String string = Logging.getMessage("generic.CannotOpenFile", GDALUtils.getErrorMessage());
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            return gDALDataRaster;
        }
        catch (WWRuntimeException wWRuntimeException) {
            throw wWRuntimeException;
        }
        catch (Throwable throwable) {
            String string = Logging.getMessage("generic.CannotOpenFile", GDALUtils.getErrorMessage());
            Logging.logger().log(Level.SEVERE, string, throwable);
            throw new WWRuntimeException(throwable);
        }
    }
}

