/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.view;

import gov.nasa.worldwind.layers.Layer;
import jams.worldwind.handler.LayerListItemTransferHandler;
import jams.worldwind.ui.model.LayerListModel;
import jams.worldwind.ui.renderer.LayerListRenderer;
import jams.worldwind.ui.view.GlobeView;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DropMode;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerListView
extends JDialog
implements PropertyChangeListener,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(LayerListView.class);
    private JScrollPane scrollPane;
    private JList layers;
    private LayerListModel layerModel = new LayerListModel();
    private int indexToRemove;

    public LayerListView(Frame parent) {
        super(parent, "Layers");
        this.layers = new JList<Layer>(this.layerModel);
        this.layers.setDragEnabled(true);
        this.layers.setSelectionMode(0);
        this.layers.setDropMode(DropMode.INSERT);
        this.layers.setTransferHandler(new LayerListItemTransferHandler(this.layerModel));
        this.setDefaultCloseOperation(1);
        this.setLayout(new GridLayout(1, 1));
        this.scrollPane = new JScrollPane(this.layers);
        this.scrollPane.setBorder(new TitledBorder("Available Layers"));
        this.layers.setCellRenderer(new LayerListRenderer());
        this.layers.setSelectionMode(0);
        this.layers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                Layer item = (Layer)list.getModel().getElementAt(index);
                if (SwingUtilities.isLeftMouseButton(event)) {
                    item.setEnabled(!item.isEnabled());
                    Layer l = GlobeView.getInstance().getModel().getLayers().getLayerByName(item.getName());
                    if (l != null) {
                        l.setEnabled(item.isEnabled());
                    } else {
                        logger.error("Clicked layer not found at WorldWind model!");
                    }
                    GlobeView.getInstance().getPCS().firePropertyChange("jams.worldwind.events.LayerChanged", null, null);
                    list.repaint(list.getCellBounds(index, index));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JList list = (JList)e.getSource();
                    JPopupMenu popup = LayerListView.this.createPopupMenu();
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    LayerListView.this.indexToRemove = list.locationToIndex(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JPopupMenu popup = LayerListView.this.createPopupMenu();
                JList list = (JList)e.getSource();
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    LayerListView.this.indexToRemove = list.locationToIndex(e.getPoint());
                }
            }
        });
        this.add(this.scrollPane);
        this.setSize(200, 600);
        this.indexToRemove = -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer item = (Layer)this.layers.getModel().getElementAt(this.indexToRemove);
        GlobeView.getInstance().getModel().getLayers().remove(item);
        GlobeView.getInstance().getPCS().firePropertyChange("jams.worldwind.events.LayerRemoved", null, null);
        GlobeView.getInstance().getPCS().firePropertyChange("jams.worldwind.events.LayerChanged", null, null);
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Remove");
        menuItem.addActionListener(this);
        popup.add(menuItem);
        return popup;
    }

    public void updateLayerListView() {
        this.layerModel.update();
    }

    public void updateModel() {
        this.layerModel.updateWorldWind();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("jams.worldwind.events.LayerChanged")) {
            this.updateLayerListView();
            this.updateModel();
            this.layers.repaint();
        }
    }
}

