/*
 * Decompiled with CFR 0.152.
 */
package jams.worldwind.ui.view;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.shapefile.DBaseRecord;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygons;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwindx.examples.util.HighlightController;
import gov.nasa.worldwindx.examples.util.ScreenSelector;
import gov.nasa.worldwindx.examples.util.ScreenShotAction;
import jams.JAMS;
import jams.JAMSLogging;
import jams.data.JAMSCalendar;
import jams.tools.JAMSTools;
import jams.workspace.stores.ShapeFileDataStore;
import jams.worldwind.data.DataTransfer3D;
import jams.worldwind.data.RandomNumbers;
import jams.worldwind.data.shapefile.JamsShapeAttributes;
import jams.worldwind.data.shapefile.JamsShapefileLoader;
import jams.worldwind.handler.SelectionHighlightController;
import jams.worldwind.ui.ColorRamp;
import jams.worldwind.ui.view.IntervallSettingsView;
import jams.worldwind.ui.view.LayerListView;
import jams.worldwind.ui.view.ShapeAttributeView;
import jams.worldwind.ui.view.ShapefileAttributesView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.Year;

public class GlobeView
implements PropertyChangeListener,
MessageListener {
    private static GlobeView instance;
    private static final Logger logger;
    private final WorldWindowGLCanvas window;
    private final Model model;
    private final StatusBar statusBar;
    private PropertyChangeSupport pcs;
    private JFrame theFrame;
    private JMenuBar theMenuBar;
    private JToolBar theToolBar;
    private LayerListView theLayerView;
    private IntervallSettingsView intervallView;
    private ScreenSelector theScreenSelector;
    private ShapefileAttributesView shapefileAttributesView;
    private SelectionHighlightController theSelectionHighlightController;
    private HighlightController highlightController;
    SelectListener selectListener;
    private JPanel topPanel;
    private JSlider internalOpacitySlider;
    private JSlider outlineOpacitySlider;
    private JSlider exaggSlider;
    private JSlider timeSeriesSlider;
    private JLabel timeSeriesSliderLabel;
    private JComboBox<String> activeLayerComboBox;
    private DisabledItemsComboBox attributesComboBox;
    private JToggleButton selectObjectsToggleButton;
    private JButton showAttributeTableButton;
    private JButton classifyButton;
    private JTextField delayEdit;
    private Timer playTimer;
    private ActionListener playTaskPerformer;
    private DataTransfer3D data;
    private List<Double> intervall;
    private ColorRamp colorRamp;
    private List[] intervallCollection;
    private ColorRamp[] colorRampCollection;
    private int lastClassifiedIndex = -1;
    private Map<SurfacePolygons, ShapeAttributeView> attributeDlgs = new HashMap<SurfacePolygons, ShapeAttributeView>();

    public static synchronized GlobeView getInstance() {
        if (instance == null) {
            instance = new GlobeView();
            instance.internalStart();
            GlobeView.instance.theFrame.addWindowListener(new WindowListener(){

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    LayerList list = instance.getModel().getLayers();
                    list.remove(list.size() - 1);
                    instance = null;
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowOpened(WindowEvent e) {
                }
            });
            GlobeView.instance.theFrame.setDefaultCloseOperation(2);
            GlobeView.instance.theFrame.setSize(1024, 800);
            GlobeView.instance.theFrame.setLocationRelativeTo(null);
        }
        return instance;
    }

    private GlobeView() {
        this.window = new WorldWindowGLCanvas();
        this.model = (Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName");
        this.window.setModel(this.model);
        this.statusBar = new StatusBar();
        this.statusBar.setEventSource((WorldWindow)this.window);
    }

    private void fillAttributesComboBox(int selectedIndex) {
        ItemListener[] listeners;
        for (ItemListener il : listeners = this.attributesComboBox.getItemListeners()) {
            this.attributesComboBox.removeItemListener(il);
        }
        this.attributesComboBox.removeAllItems();
        String[] attributes = this.data.getSortedAttributes();
        if (attributes != null) {
            int i = 0;
            for (String s : attributes) {
                if (this.intervallCollection == null || this.colorRampCollection == null || this.intervallCollection[i] == null || this.colorRampCollection[i] == null) {
                    this.attributesComboBox.addItem(s, true);
                } else {
                    this.attributesComboBox.addItem(s);
                }
                ++i;
            }
            this.attributesComboBox.setSelectedIndex(selectedIndex);
        }
        for (ItemListener il : listeners) {
            this.attributesComboBox.addItemListener(il);
        }
    }

    public WorldWindow getWorldWindow() {
        return this.window;
    }

    public Model getModel() {
        return this.model;
    }

    public View getView() {
        return this.window.getView();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void internalStart() {
        this.pcs = new PropertyChangeSupport(this);
        this.getPCS().addPropertyChangeListener(this);
        this.theScreenSelector = new ScreenSelector(this.getWorldWindow());
        this.theScreenSelector.addMessageListener((MessageListener)this);
        this.highlightController = new HighlightController(this.getWorldWindow(), (Object)"gov.nasa.worldwind.SelectEvent.Rollover");
        this.theFrame = new JFrame("JAMS WorldWind");
        this.theFrame.setIconImages(JAMSTools.getJAMSIcons());
        this.theFrame.setLayout(new BorderLayout());
        this.theFrame.setDefaultCloseOperation(2);
        this.theFrame.add((Component)this.getWorldWindow(), "Center");
        this.theFrame.add((Component)this.getStatusBar(), "Last");
        this.theFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (GlobeView.this.shapefileAttributesView != null) {
                    GlobeView.this.shapefileAttributesView.dispose();
                    GlobeView.this.shapefileAttributesView = null;
                }
                if (GlobeView.this.theLayerView != null) {
                    GlobeView.this.theLayerView.dispose();
                    GlobeView.this.theLayerView = null;
                }
                if (GlobeView.this.intervallView != null) {
                    GlobeView.this.intervallView.dispose();
                    GlobeView.this.intervallView = null;
                }
                if (GlobeView.this.intervallCollection != null) {
                    GlobeView.access$402(GlobeView.this, null);
                }
                if (GlobeView.this.colorRampCollection != null) {
                    GlobeView.access$502(GlobeView.this, null);
                }
                GlobeView.this.removeListener();
            }
        });
        this.getPCS().addPropertyChangeListener(this.shapefileAttributesView);
        this.createListener();
        this.getWorldWindow().addSelectListener(this.selectListener);
        this.buildToolBar();
        this.buildMenu();
        this.fixMacOSX();
        this.setKeyboardShortcuts();
    }

    private void createListener() {
        this.selectListener = new SelectListener(){
            protected Object lastObject;

            public void selected(SelectEvent event) {
                if (!event.isLeftClick()) {
                    return;
                }
                Object o = event.getTopObject();
                if (o != null && o instanceof SurfacePolygons) {
                    Layer l;
                    SurfacePolygons s = (SurfacePolygons)o;
                    s.setHighlighted(true);
                    if (GlobeView.this.shapefileAttributesView != null && GlobeView.this.shapefileAttributesView.isVisible()) {
                        GlobeView.this.shapefileAttributesView.scrollToObject(o);
                    }
                    if ((l = GlobeView.this.getModel().getLayers().getLayerByName(GlobeView.this.activeLayerComboBox.getSelectedItem().toString())).getClass().equals(RenderableLayer.class)) {
                        DataTransfer3D dataTransfer = (DataTransfer3D)l.getValue("jams.worldwind.events.DataTransfer3DAppend");
                        Integer timeIndex = GlobeView.this.timeSeriesSlider.getValue();
                        JAMSCalendar date = dataTransfer.getSortedTimeSteps()[timeIndex];
                        String[][] values = GlobeView.this.getEntityData(s, date, dataTransfer);
                        ShapeAttributeView dlg = (ShapeAttributeView)GlobeView.this.attributeDlgs.get(s);
                        if (dlg != null && dlg.isFocusable()) {
                            dlg.setDataTransfer(dataTransfer);
                            dlg.setData(values);
                            dlg.setVisible(true);
                            dlg.toFront();
                        } else {
                            dlg = new ShapeAttributeView((Frame)GlobeView.this.theFrame, "Entity " + values[0][1] + ": Information", values, dataTransfer);
                            dlg.setPreferredSize(new Dimension(250, 300));
                            dlg.pack();
                            GlobeView.this.attributeDlgs.put(s, dlg);
                            dlg.setVisible(true);
                        }
                    }
                }
            }
        };
    }

    private String[][] getEntityData(SurfacePolygons s, JAMSCalendar date, DataTransfer3D dataTransfer) {
        String column = dataTransfer.getKeyColumn();
        JamsShapeAttributes sattr = (JamsShapeAttributes)s.getAttributes();
        DBaseRecord dbrec = sattr.getShapeFileRecord().getAttributes();
        String idString = dbrec.getValue(column).toString();
        Set c = dbrec.getEntries();
        String[][] values = new String[dataTransfer.getSortedAttributes().length + c.size() + 2][2];
        values[0][0] = "ID";
        values[0][1] = idString;
        values[1][0] = "time";
        values[1][1] = date.toString();
        int i = 2;
        for (String attribute : dataTransfer.getSortedAttributes()) {
            double dataValue = dataTransfer.getValue(idString, attribute, date);
            values[i][0] = attribute;
            values[i][1] = Double.toString(dataValue);
            ++i;
        }
        for (Map.Entry e : c) {
            values[i][0] = (String)e.getKey();
            values[i][1] = String.valueOf(e.getValue());
            ++i;
        }
        return values;
    }

    private void updateDlgs() {
        Layer l = this.getModel().getLayers().getLayerByName(this.activeLayerComboBox.getSelectedItem().toString());
        if (l.getClass().equals(RenderableLayer.class)) {
            DataTransfer3D dataTransfer = (DataTransfer3D)l.getValue("jams.worldwind.events.DataTransfer3DAppend");
            Integer timeIndex = this.timeSeriesSlider.getValue();
            JAMSCalendar date = dataTransfer.getSortedTimeSteps()[timeIndex];
            for (SurfacePolygons s : this.attributeDlgs.keySet()) {
                String[][] values = this.getEntityData(s, date, dataTransfer);
                ShapeAttributeView dlg = this.attributeDlgs.get(s);
                if (dlg == null || !dlg.isFocusable()) continue;
                dlg.setData(values);
            }
        }
    }

    private void removeListener() {
        this.getWorldWindow().removeSelectListener(this.selectListener);
    }

    public boolean addJAMSExplorerData(DataTransfer3D d) {
        this.data = d;
        this.intervallCollection = null;
        this.colorRampCollection = null;
        this.timeSeriesSlider.setEnabled(false);
        this.timeSeriesSlider.setValue(0);
        this.attributesComboBox.setEnabled(false);
        this.classifyButton.setEnabled(false);
        if (this.intervallView != null) {
            this.intervallView.dispose();
            this.intervallView = null;
        }
        try {
            this.addData(d.getShapeFileDataStore());
        }
        catch (WWRuntimeException wwrte) {
            JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(GlobeView.class.getName()));
            Logger.getLogger(GlobeView.class.getName()).log(Level.WARNING, "Cannot open Shapefile \"" + d.getShapeFileDataStore().getShapeFile().getAbsolutePath() + "\" due to unknown projection. Please correct!", wwrte);
            JAMSLogging.unregisterLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)Logger.getLogger(GlobeView.class.getName()));
            return false;
        }
        return true;
    }

    private void addData(ShapeFileDataStore shp) {
        File file = shp.getShapeFile();
        if (!this.isShapefileAlreadyOpened(file)) {
            this.addShapefile(file);
        } else {
            String layerName = file.getName() + " (" + file.getAbsolutePath() + ")";
            if (this.data != null) {
                Layer l = this.getModel().getLayers().getLayerByName(layerName);
                l.setValue("jams.worldwind.events.DataTransfer3DAppend", (Object)this.data);
            }
            this.intervallCollection = new List[this.data.getSortedAttributes().length];
            this.colorRampCollection = new ColorRamp[this.data.getSortedAttributes().length];
            this.activeLayerComboBox.setSelectedIndex(0);
            this.activeLayerComboBox.setSelectedItem(layerName);
        }
    }

    private void setKeyboardShortcuts() {
        JRootPane c = this.theFrame.getRootPane();
        InputMap im = c.getInputMap(2);
        ActionMap am = c.getActionMap();
        im.put(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "VK_M");
        am.put("VK_M", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GlobeView.this.topPanel.isVisible()) {
                    GlobeView.this.topPanel.setVisible(false);
                } else {
                    GlobeView.this.topPanel.setVisible(true);
                }
                GlobeView.this.theFrame.revalidate();
            }
        });
    }

    private void buildToolBar() {
        ImageIcon smallIcon = new ImageIcon(GlobeView.class.getResource("/jams/worldwind/ressources/16x16/draw-rectangle-2.png"));
        this.selectObjectsToggleButton = new JToggleButton(smallIcon);
        this.selectObjectsToggleButton.setToolTipText("SELECT OBJECTS");
        this.selectObjectsToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JToggleButton)e.getSource()).isSelected()) {
                    GlobeView.this.theScreenSelector.enable();
                } else {
                    GlobeView.this.theScreenSelector.disable();
                }
            }
        });
        smallIcon = new ImageIcon(GlobeView.class.getResource("/jams/worldwind/ressources/16x16/table-link.png"));
        this.showAttributeTableButton = new JButton(smallIcon);
        this.showAttributeTableButton.setEnabled(false);
        this.showAttributeTableButton.setToolTipText("Show Attribute Table");
        this.showAttributeTableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Layer l;
                List screenselectorList = GlobeView.this.theScreenSelector.getSelectedObjects();
                String layerName = (String)GlobeView.this.activeLayerComboBox.getSelectedItem();
                GlobeView.this.theScreenSelector.disable();
                GlobeView.this.selectObjectsToggleButton.setEnabled(false);
                if (GlobeView.this.shapefileAttributesView == null) {
                    GlobeView.this.shapefileAttributesView = new ShapefileAttributesView("Attributes");
                }
                if (!screenselectorList.isEmpty()) {
                    GlobeView.this.shapefileAttributesView.fillTableWithObjects(screenselectorList);
                    GlobeView.this.shapefileAttributesView.show(true);
                    GlobeView.this.theFrame.toFront();
                } else if (layerName != null && (l = GlobeView.this.getModel().getLayers().getLayerByName(layerName)).getClass().equals(RenderableLayer.class)) {
                    ArrayList<Renderable> list = new ArrayList<Renderable>(((RenderableLayer)l).getNumRenderables());
                    for (Renderable r : ((RenderableLayer)l).getRenderables()) {
                        list.add(r);
                    }
                    GlobeView.this.shapefileAttributesView.fillTableWithObjects(list);
                    GlobeView.this.shapefileAttributesView.show(true);
                    GlobeView.this.theFrame.toFront();
                }
            }
        });
        this.activeLayerComboBox = new JComboBox();
        this.activeLayerComboBox.setSelectedIndex(-1);
        this.activeLayerComboBox.setName("ACTIVE_LAYER_COMBOBOX");
        this.activeLayerComboBox.setBorder(new TitledBorder("Active Layer"));
        this.activeLayerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GlobeView.this.activeLayerComboBoxItemStateChanged(e);
            }
        });
        this.fillComboBox();
        this.internalOpacitySlider = new JSlider(0, 100);
        this.outlineOpacitySlider = new JSlider(0, 100);
        this.internalOpacitySlider.setPaintTicks(false);
        this.outlineOpacitySlider.setPaintTicks(false);
        this.internalOpacitySlider.setPaintLabels(false);
        this.outlineOpacitySlider.setPaintLabels(false);
        this.internalOpacitySlider.setEnabled(false);
        this.outlineOpacitySlider.setEnabled(false);
        this.internalOpacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlobeView.this.internalOpacitySliderStateChanged(e);
            }
        });
        this.outlineOpacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlobeView.this.outlineSliderStateChanged(e);
            }
        });
        this.exaggSlider = new JSlider(0, 60);
        this.exaggSlider.setPaintTicks(false);
        this.exaggSlider.setPaintLabels(false);
        this.exaggSlider.setEnabled(true);
        this.exaggSlider.setValue((int)this.getWorldWindow().getSceneController().getVerticalExaggeration() * 10);
        this.exaggSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double value = ((JSlider)e.getSource()).getValue();
                GlobeView.this.getWorldWindow().getSceneController().setVerticalExaggeration(value / 10.0);
            }
        });
        JPanel sliderPanel1 = new JPanel();
        sliderPanel1.setLayout(new GridLayout(3, 1));
        sliderPanel1.setBorder(new TitledBorder("Opacity & Exaggeration"));
        sliderPanel1.setPreferredSize(new Dimension(100, 50));
        sliderPanel1.add(this.internalOpacitySlider);
        sliderPanel1.add(this.outlineOpacitySlider);
        sliderPanel1.add(this.exaggSlider);
        JPanel sliderPanel2 = new JPanel();
        sliderPanel2.setLayout(new GridLayout(2, 1));
        sliderPanel2.setBorder(new TitledBorder("Time Steps"));
        this.timeSeriesSlider = new JSlider();
        this.timeSeriesSlider.setName("TIME_SERIES_SLIDER");
        this.timeSeriesSlider.setEnabled(false);
        this.timeSeriesSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GlobeView.this.timeSeriesSliderStateChanged(e);
            }
        });
        this.timeSeriesSliderLabel = new JLabel("No Data", 0);
        this.timeSeriesSliderLabel.setEnabled(true);
        JButton playButton = new JButton(">");
        JButton pauseButton = new JButton("||");
        this.delayEdit = new JTextField("100");
        this.delayEdit.setToolTipText(JAMS.i18n((String)"Time_in_milliseconds"));
        this.delayEdit.setPreferredSize(new Dimension((int)this.delayEdit.getPreferredSize().getWidth() * 3, (int)this.delayEdit.getPreferredSize().getHeight()));
        JPanel playPanel = new JPanel();
        playPanel.add(playButton);
        playPanel.add(this.delayEdit);
        playPanel.add(pauseButton);
        playPanel.add(this.timeSeriesSliderLabel);
        this.playTaskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (GlobeView.this.timeSeriesSlider.getValue() < GlobeView.this.timeSeriesSlider.getMaximum()) {
                            GlobeView.this.timeSeriesSlider.setValue(GlobeView.this.timeSeriesSlider.getValue() + 1);
                        } else {
                            GlobeView.this.timeSeriesSlider.setValue(GlobeView.this.timeSeriesSlider.getMinimum());
                        }
                    }
                });
            }
        };
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GlobeView.this.playTimer != null) {
                    GlobeView.this.playTimer.stop();
                }
                int time = 0;
                try {
                    time = Integer.parseInt(GlobeView.this.delayEdit.getText());
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                GlobeView.this.playTimer = new Timer(time, GlobeView.this.playTaskPerformer);
                GlobeView.this.playTimer.start();
            }
        });
        pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobeView.this.playTimer.stop();
            }
        });
        sliderPanel2.add(this.timeSeriesSlider);
        sliderPanel2.add(playPanel);
        this.topPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.topPanel.setLayout(gbl);
        this.topPanel.setVisible(true);
        JPanel classifierPanel = new JPanel();
        classifierPanel.setLayout(new GridLayout(2, 1));
        classifierPanel.setBorder(new TitledBorder("Spatial Data"));
        this.attributesComboBox = new DisabledItemsComboBox();
        this.attributesComboBox.setEnabled(false);
        this.attributesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GlobeView.this.attributesComboBoxItemStateChanged(e);
            }
        });
        this.classifyButton = new JButton("Classify");
        this.classifyButton.setEnabled(false);
        this.classifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobeView.this.classifyButtonActionPerformed(e);
            }
        });
        classifierPanel.add(this.attributesComboBox);
        classifierPanel.add(this.classifyButton);
        this.addComponent(this.topPanel, gbl, this.selectObjectsToggleButton, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.topPanel, gbl, this.showAttributeTableButton, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.topPanel, gbl, this.activeLayerComboBox, 0, 1, 2, 1, 1.0, 0.0);
        this.addComponent(this.topPanel, gbl, classifierPanel, 2, 0, 2, 2, 1.0, 0.0);
        this.addComponent(this.topPanel, gbl, sliderPanel1, 4, 0, 2, 2, 1.0, 0.0);
        this.addComponent(this.topPanel, gbl, sliderPanel2, 6, 0, 2, 2, 1.0, 0.0);
        this.theFrame.add((Component)this.topPanel, "North");
    }

    private TimeSeries createTimeData() {
        int maxNumbers = 11;
        TimeSeries timeData = new TimeSeries((Comparable)((Object)"TEST PRECIPITATION"));
        for (int i = 0; i < maxNumbers; ++i) {
            RandomNumbers rn = new RandomNumbers(0.0, 100.0, maxNumbers);
            Double value = rn.getDoubleValues().get(i);
            timeData.add((RegularTimePeriod)new Year(2000 + i), (Number)value);
        }
        return timeData;
    }

    private void addComponent(Container container, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        container.add(c);
    }

    private void buildMenu() {
        this.theMenuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem openShapefile = new JMenuItem("Open Shapefile...");
        KeyStroke stroke = KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        openShapefile.setAccelerator(stroke);
        openShapefile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobeView.this.openShapefileActionlistener(e);
            }
        });
        JMenuItem saveScreenshot = new JMenuItem("Save Screenshot...");
        saveScreenshot.addActionListener((ActionListener)new ScreenShotAction(this.getWorldWindow()));
        stroke = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        saveScreenshot.setAccelerator(stroke);
        JMenuItem jMenuItemExit = new JMenuItem("Exit");
        stroke = KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        jMenuItemExit.setAccelerator(stroke);
        jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobeView.this.exitActionListener(e);
            }
        });
        fileMenu.add(openShapefile);
        fileMenu.add(saveScreenshot);
        fileMenu.addSeparator();
        fileMenu.add(jMenuItemExit);
        JMenu viewMenu = new JMenu("View");
        JMenu controls = new JMenu("View Controls");
        controls.add(new JCheckBoxMenuItem());
        JMenuItem listLayers = new JMenuItem("Show Layers");
        stroke = KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        listLayers.setAccelerator(stroke);
        listLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobeView.this.showLayersActionListener(e);
            }
        });
        viewMenu.add(listLayers);
        this.theMenuBar.add(fileMenu);
        this.theMenuBar.add(viewMenu);
        this.theFrame.setJMenuBar(this.theMenuBar);
    }

    private void fillComboBox() {
        this.activeLayerComboBox.removeAllItems();
        LayerList layers = this.getWorldWindow().getModel().getLayers();
        int index = 0;
        for (int i = 0; i < layers.size(); ++i) {
            this.activeLayerComboBox.insertItemAt(((Layer)layers.get(i)).getName(), index);
            ++index;
        }
        this.activeLayerComboBox.setPreferredSize(new Dimension(100, 45));
        this.activeLayerComboBox.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (GlobeView.this.activeLayerComboBox.getSelectedIndex() > -1) {
                    GlobeView.this.activeLayerComboBox.setToolTipText(GlobeView.this.activeLayerComboBox.getSelectedItem().toString());
                }
            }
        });
    }

    private void openShapefileActionlistener(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("ESRI Shapefile", "shp");
        fc.setFileFilter(filter);
        switch (fc.showOpenDialog(this.theFrame)) {
            case 0: {
                File file = fc.getSelectedFile();
                if (this.isShapefileAlreadyOpened(file)) {
                    if (!this.reloadShapefile(file)) break;
                    this.addShapefile(file);
                    break;
                }
                this.addShapefile(file);
                break;
            }
        }
    }

    private void exitActionListener(ActionEvent e) {
        for (Frame frame : JFrame.getFrames()) {
            if (!frame.isActive()) continue;
            WindowEvent windowClosing = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowClosing);
        }
    }

    private void showLayersActionListener(ActionEvent e) {
        if (this.theLayerView == null) {
            this.theLayerView = new LayerListView(this.theFrame);
            this.theLayerView.setLocationRelativeTo(this.theFrame);
        }
        this.theLayerView.setVisible(true);
    }

    public double computeZoomForExtent(Sector sector) {
        Angle delta = sector.getDeltaLat();
        if (sector.getDeltaLon().compareTo(delta) > 0) {
            delta = sector.getDeltaLon();
        }
        double arcLength = delta.radians * 6378137.0;
        double fieldOfView = Configuration.getDoubleValue((String)"gov.nasa.worldwind.avkey.FieldOfView", (Double)45.0);
        double ret = arcLength / Math.tan(fieldOfView / 2.0);
        return ret;
    }

    public void zoomToSector(Sector sector) {
        this.getWorldWindow().getView().stopAnimations();
        double zoom = this.computeZoomForExtent(sector);
        Position p = new Position(sector.getCentroid(), zoom);
        this.getWorldWindow().getView().goTo(p, zoom);
    }

    public void addShapefile(File f) {
        String layerName = f.getName() + " (" + f.getAbsolutePath() + ")";
        Shapefile shp = new Shapefile((Object)f);
        List layers = new JamsShapefileLoader().createLayersFromShapefile(shp);
        int i = 0;
        for (Layer layer : layers) {
            layer.setEnabled(true);
            if (this.data != null) {
                layer.setValue("jams.worldwind.events.DataTransfer3DAppend", (Object)this.data);
            }
            layer.setValue("jams.worldwind.events.BoundingBoxOfShapefile", (Object)shp.getBoundingRectangle());
            if (i == 0) {
                layer.setName(layerName);
            } else {
                layer.setName(layerName + "_" + i);
            }
            ++i;
            this.getModel().getLayers().add(layer);
        }
        this.getPCS().firePropertyChange("jams.worldwind.events.LayerAdded", null, null);
        this.getPCS().firePropertyChange("jams.worldwind.events.LayerChanged", null, null);
        this.activeLayerComboBox.setSelectedIndex(this.activeLayerComboBox.getItemCount() - 1);
        this.outlineOpacitySlider.setValue(20);
    }

    public void removeShapefile(File f) {
        String layerName = f.getName() + " (" + f.getAbsolutePath() + ")";
        Layer layer = this.getWorldWindow().getModel().getLayers().getLayerByName(layerName);
        if (layer != null) {
            logger.info("Layer removed...");
            this.getModel().getLayers().remove(layer);
        }
        this.getPCS().firePropertyChange("jams.worldwind.events.LayerChanged", null, null);
    }

    private boolean isShapefileAlreadyOpened(File f) {
        String layerName = f.getName() + " (" + f.getAbsolutePath() + ")";
        logger.info("Shapefile: " + layerName);
        Layer l = this.getWorldWindow().getModel().getLayers().getLayerByName(layerName);
        return l != null;
    }

    private boolean reloadShapefile(File f) {
        String layerName = f.getName() + " (" + f.getAbsolutePath() + ")";
        Layer layer = this.getWorldWindow().getModel().getLayers().getLayerByName(layerName);
        int result = JOptionPane.showConfirmDialog(null, "Shapefile already loaded, reload?", "Shapefile exists", 0, 3);
        if (result == 1) {
            return false;
        }
        if (result == 0) {
            this.getWorldWindow().getModel().getLayers().remove(layer);
        }
        return true;
    }

    public void show() {
        this.theFrame.setVisible(true);
    }

    public void toTop() {
        this.theFrame.toFront();
        this.theFrame.repaint();
    }

    private void fixMacOSX() {
        if (Configuration.isMacOS()) {
            logger.info("Mac OS X detected - fixing view bug");
            this.theFrame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    GlobeView.this.theFrame.setSize(((GlobeView)GlobeView.this).theFrame.getSize().width + 1, ((GlobeView)GlobeView.this).theFrame.getSize().height + 1);
                }
            });
        }
    }

    private void classifyButtonActionPerformed(ActionEvent e) {
        String[] attributes = this.data.getSortedAttributes();
        if (this.intervallView == null) {
            this.intervallView = new IntervallSettingsView(this.data, attributes);
        } else if (this.attributesComboBox.getSelectedIndex() == this.lastClassifiedIndex) {
            this.intervallView.show();
        } else {
            this.intervallView = new IntervallSettingsView(this.data, attributes);
        }
        this.intervallView.show();
        this.lastClassifiedIndex = this.attributesComboBox.getSelectedIndex();
    }

    public void writeToDisk() {
        try {
            logger.info("Flushing dataset to disk...");
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("../../JAMSworldwind/src/jams/worldwind/test/DataTransfer3DTestData.ser"));
            out.writeObject(this.data);
            out.close();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bos);
            out.writeObject(this.data);
            out.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void readFromDisk(String fileName) {
        try {
            logger.info("Reading dataset from disk...");
            FileInputStream fin = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fin);
            this.data = (DataTransfer3D)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.severe(e.toString());
        }
    }

    public PropertyChangeSupport getPCS() {
        return this.pcs;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.info("Receiving Event: " + evt.getPropertyName());
        int selectedIndex = -1;
        if (evt.getPropertyName().equals("jams.worldwind.events.IntervallCalculated") || evt.getPropertyName().equals("jams.worldwind.events.IntervallColorsSet")) {
            if (this.intervallView != null) {
                selectedIndex = this.intervallView.getSelectedAttributeIndex();
            }
            if (this.intervallCollection == null) {
                this.intervallCollection = new List[this.data.getSortedAttributes().length];
            }
            if (this.colorRampCollection == null) {
                this.colorRampCollection = new ColorRamp[this.data.getSortedAttributes().length];
            }
        }
        switch (evt.getPropertyName()) {
            case "jams.worldwind.events.LayerChanged": {
                this.fillComboBox();
                break;
            }
            case "jams.worldwind.events.IntervallCalculated": {
                if (selectedIndex == -1) {
                    return;
                }
                this.intervall = (List)evt.getNewValue();
                this.intervallCollection[selectedIndex] = this.intervall;
                this.attributesComboBox.setSelectedIndex(selectedIndex);
                break;
            }
            case "jams.worldwind.events.IntervallColorsSet": {
                if (selectedIndex == -1) {
                    return;
                }
                this.colorRampCollection[selectedIndex] = this.colorRamp = (ColorRamp)evt.getNewValue();
            }
        }
        this.timeSeriesSlider.setEnabled(false);
        if (selectedIndex != -1 && this.intervallCollection[selectedIndex] != null && this.colorRampCollection[selectedIndex] != null) {
            this.timeSeriesSlider.setEnabled(true);
        }
        this.fillAttributesComboBox(selectedIndex);
        this.timeSeriesSliderStateChanged(null);
    }

    public void onMessage(Message msg) {
        if (msg.getName().equals("ScreenSelector.SelectionEnded")) {
            if (!this.theScreenSelector.getSelectedObjects().isEmpty()) {
                this.showAttributeTableButton.setEnabled(true);
            }
        } else if (msg.getName().equals("ScreenSelector.SelectionStarted")) {
            this.showAttributeTableButton.setEnabled(false);
        }
    }

    private void attributesComboBoxItemStateChanged(ItemEvent e) {
        if (this.attributesComboBox.getSelectedIndex() != -1 && this.intervallView != null) {
            if (this.intervallCollection[this.attributesComboBox.getSelectedIndex()] == null || this.colorRampCollection[this.attributesComboBox.getSelectedIndex()] == null) {
                this.timeSeriesSlider.setEnabled(false);
            } else {
                this.timeSeriesSlider.setEnabled(true);
                this.timeSeriesSliderStateChanged(null);
            }
        }
    }

    private void activeLayerComboBoxItemStateChanged(ItemEvent e) {
        int index = ((JComboBox)e.getSource()).getSelectedIndex();
        if (e.getStateChange() == 1 && index >= 0) {
            JComboBox cb = (JComboBox)e.getSource();
            Layer l = this.getModel().getLayers().getLayerByName(cb.getSelectedItem().toString());
            new DelayZoom((double[])l.getValue("jams.worldwind.events.BoundingBoxOfShapefile"), 2000L).execute();
            if (l.getClass().equals(RenderableLayer.class)) {
                this.showAttributeTableButton.setEnabled(true);
                DataTransfer3D d = (DataTransfer3D)l.getValue("jams.worldwind.events.DataTransfer3DAppend");
                if (d == null) {
                    logger.info("DATATRANSFER3D not found...");
                    return;
                }
                logger.info("DATATRANSFER3D found...");
                this.fillAttributesComboBox(-1);
                this.classifyButton.setEnabled(true);
                this.attributesComboBox.setEnabled(true);
                String[] ids = d.getSortedIds();
                String[] attr = d.getSortedAttributes();
                JAMSCalendar[] cal = d.getSortedTimeSteps();
                Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>(cal.length);
                for (int i = 0; i < cal.length; ++i) {
                    labelTable.put(new Integer(i), new JLabel(cal[i].toString()));
                }
                this.timeSeriesSlider.setLabelTable(labelTable);
                this.timeSeriesSlider.setMinimum(0);
                this.timeSeriesSlider.setMaximum(cal.length - 1);
                this.timeSeriesSlider.setMajorTickSpacing(1);
                this.timeSeriesSlider.setPaintTicks(true);
                this.timeSeriesSlider.setSnapToTicks(true);
                this.timeSeriesSlider.setPaintLabels(false);
                this.timeSeriesSlider.setEnabled(false);
                Integer value = this.timeSeriesSlider.getValue();
                this.timeSeriesSliderLabel.setText(((JLabel)this.timeSeriesSlider.getLabelTable().get(value)).getText());
            } else {
                this.showAttributeTableButton.setEnabled(false);
            }
            this.internalOpacitySlider.setEnabled(true);
            this.internalOpacitySlider.setValue((int)(l.getOpacity() * 100.0));
            this.outlineOpacitySlider.setEnabled(true);
            this.getPCS().firePropertyChange("jams.worldwind.events.ActiveLayerChanged", null, (Object)index);
        } else {
            this.internalOpacitySlider.setEnabled(false);
            this.outlineOpacitySlider.setEnabled(false);
            this.timeSeriesSlider.setEnabled(false);
            this.showAttributeTableButton.setEnabled(false);
        }
    }

    private void internalOpacitySliderStateChanged(ChangeEvent e) {
        double value = (double)((JSlider)e.getSource()).getValue() / 100.0;
        Layer l = this.getModel().getLayers().getLayerByName(this.activeLayerComboBox.getSelectedItem().toString());
        if (l.getClass().equals(RenderableLayer.class)) {
            Iterable list = ((RenderableLayer)l).getRenderables();
            for (Object obj : list) {
                AbstractSurfaceShape shape = (AbstractSurfaceShape)obj;
                ShapeAttributes shapeAttr = shape.getAttributes();
                shapeAttr.setInteriorOpacity(value);
            }
        }
        l.setOpacity(value);
        this.getWorldWindow().redraw();
    }

    private void outlineSliderStateChanged(ChangeEvent e) {
        double value = (double)((JSlider)e.getSource()).getValue() / 100.0;
        Layer l = this.getModel().getLayers().getLayerByName(this.activeLayerComboBox.getSelectedItem().toString());
        if (l.getClass().equals(RenderableLayer.class)) {
            Iterable list = ((RenderableLayer)l).getRenderables();
            for (Object obj : list) {
                AbstractSurfaceShape shape = (AbstractSurfaceShape)obj;
                ShapeAttributes shapeAttr = shape.getAttributes();
                shapeAttr.setOutlineOpacity(value);
            }
        }
        this.getWorldWindow().redraw();
    }

    private void timeSeriesSliderStateChanged(ChangeEvent e) {
        int selectedIndex = this.attributesComboBox.getSelectedIndex();
        if (this.timeSeriesSlider.isEnabled() && selectedIndex != -1) {
            Layer l = this.getModel().getLayers().getLayerByName(this.activeLayerComboBox.getSelectedItem().toString());
            if (l == null) {
                return;
            }
            if (l.getClass().equals(RenderableLayer.class)) {
                Iterable list = ((RenderableLayer)l).getRenderables();
                ArrayList intervall_temp = new ArrayList(this.intervallCollection[selectedIndex]);
                this.colorRamp = this.colorRampCollection[selectedIndex];
                DataTransfer3D d = (DataTransfer3D)l.getValue("jams.worldwind.events.DataTransfer3DAppend");
                JAMSCalendar[] dates = d.getSortedTimeSteps();
                Integer value = this.timeSeriesSlider.getValue();
                this.timeSeriesSliderLabel.setText(dates[value].toString());
                String column = d.getKeyColumn();
                SurfacePolygons poly = null;
                JamsShapeAttributes sattr = null;
                DBaseRecord record = null;
                for (Object obj : list) {
                    double dataValue;
                    poly = (SurfacePolygons)obj;
                    sattr = (JamsShapeAttributes)poly.getAttributes();
                    record = sattr.getShapeFileRecord().getAttributes();
                    Object idObject = record.getValue(column);
                    if (idObject == null || (dataValue = d.getValue(idObject.toString(), this.attributesComboBox.getSelectedItem().toString(), dates[value])) == Double.NEGATIVE_INFINITY) continue;
                    int index = 0;
                    for (int j = 0; j < intervall_temp.size() - 1; ++j) {
                        if (dataValue >= (Double)intervall_temp.get(j) && dataValue < (Double)intervall_temp.get(j + 1)) {
                            index = j;
                            break;
                        }
                        if (dataValue != (Double)intervall_temp.get(intervall_temp.size() - 1)) continue;
                        index = intervall_temp.size() - 1;
                        break;
                    }
                    sattr.setInteriorMaterial(new Material(this.colorRamp.getColor(index)));
                }
            }
            this.getWorldWindow().redraw();
            this.updateDlgs();
        }
    }

    static /* synthetic */ List[] access$402(GlobeView x0, List[] x1) {
        x0.intervallCollection = x1;
        return x1;
    }

    static /* synthetic */ ColorRamp[] access$502(GlobeView x0, ColorRamp[] x1) {
        x0.colorRampCollection = x1;
        return x1;
    }

    static {
        logger = Logger.getLogger(GlobeView.class.getName());
    }

    private class DisabledItemsComboBox
    extends JComboBox {
        private Set disabled_items = new HashSet();

        public DisabledItemsComboBox() {
            super.setRenderer(new DisabledItemsRenderer());
        }

        public void addItem(Object anObject, boolean disabled) {
            try {
                super.addItem(anObject);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (disabled) {
                this.disabled_items.add(this.getItemCount() - 1);
            }
        }

        @Override
        public void removeAllItems() {
            super.removeAllItems();
            this.disabled_items = new HashSet();
        }

        @Override
        public void removeItemAt(int anIndex) {
            super.removeItemAt(anIndex);
            this.disabled_items.remove(anIndex);
        }

        @Override
        public void removeItem(Object anObject) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (this.getItemAt(i) != anObject) continue;
                this.disabled_items.remove(i);
            }
            super.removeItem(anObject);
        }

        @Override
        public void setSelectedIndex(int index) {
            if (!this.disabled_items.contains(index)) {
                super.setSelectedIndex(index);
            }
        }

        private class DisabledItemsRenderer
        extends BasicComboBoxRenderer {
            private DisabledItemsRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                if (DisabledItemsComboBox.this.disabled_items.contains(index)) {
                    this.setBackground(list.getBackground());
                    this.setForeground(UIManager.getColor("Label.disabledForeground"));
                }
                this.setFont(list.getFont());
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }

    private class DelayZoom
    extends SwingWorker<Object, Object> {
        private Sector sector = null;
        private final long millis;

        public DelayZoom(double[] boundingRectangle, long millis) {
            if (boundingRectangle != null) {
                this.sector = new Sector(Angle.fromDegrees((double)boundingRectangle[0]), Angle.fromDegrees((double)boundingRectangle[1]), Angle.fromDegrees((double)boundingRectangle[2]), Angle.fromDegrees((double)boundingRectangle[3]));
            }
            this.millis = millis;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Thread.sleep(this.millis);
            return null;
        }

        @Override
        protected void done() {
            if (this.sector != null) {
                GlobeView.this.zoomToSector(this.sector);
            }
        }
    }
}

